/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model.layout.actions;

import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.layout.actions.ClearWeightsAction;
import com.intellij.android.designer.model.layout.actions.DistributeWeightsAction;
import com.intellij.android.designer.model.layout.actions.LayoutAction;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import icons.AndroidDesignerIcons;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DominateWeightsAction
extends LayoutAction {
    private final RadViewComponent myLayout;
    private final List<? extends RadViewComponent> mySelectedChildren;

    public DominateWeightsAction(@NotNull DesignerEditorPanel designer, @NotNull RadViewComponent layout, @NotNull List<? extends RadViewComponent> selectedChildren) {
        if (designer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/android/designer/model/layout/actions/DominateWeightsAction", "<init>"));
        }
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/android/designer/model/layout/actions/DominateWeightsAction", "<init>"));
        }
        if (selectedChildren == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/android/designer/model/layout/actions/DominateWeightsAction", "<init>"));
        }
        super(designer, "Assign All Weight", null, AndroidDesignerIcons.DominateWeight);
        this.myLayout = layout;
        this.mySelectedChildren = selectedChildren;
    }

    @Override
    protected void performWriteAction() {
        ClearWeightsAction.clearWeights(this.myLayout, RadViewComponent.getViewComponents(this.myLayout.getChildren()));
        DistributeWeightsAction.distributeWeights(this.myLayout, this.mySelectedChildren);
    }
}

