/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model.layout.actions;

import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.layout.RadLinearLayout;
import com.intellij.android.designer.model.layout.actions.LayoutAction;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.psi.xml.XmlAttribute;
import icons.AndroidDesignerIcons;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ClearWeightsAction
extends LayoutAction {
    private final RadViewComponent myLayout;
    private final List<? extends RadViewComponent> mySelectedChildren;

    public ClearWeightsAction(@NotNull DesignerEditorPanel designer, @NotNull RadViewComponent layout, @NotNull List<? extends RadViewComponent> selectedChildren) {
        if (designer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/android/designer/model/layout/actions/ClearWeightsAction", "<init>"));
        }
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/android/designer/model/layout/actions/ClearWeightsAction", "<init>"));
        }
        if (selectedChildren == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/android/designer/model/layout/actions/ClearWeightsAction", "<init>"));
        }
        super(designer, "Clear All Weights", null, AndroidDesignerIcons.ClearWeights);
        this.myLayout = layout;
        this.mySelectedChildren = selectedChildren;
    }

    @Override
    protected void performWriteAction() {
        ClearWeightsAction.clearWeights(this.myLayout, this.mySelectedChildren);
    }

    static void clearWeights(RadViewComponent parentNode, List<? extends RadViewComponent> targets) {
        String sizeAttribute = ((RadLinearLayout)parentNode.getLayout()).isHorizontal() ? "layout_width" : "layout_height";
        for (RadViewComponent radViewComponent : targets) {
            XmlAttribute size;
            XmlAttribute weight = radViewComponent.getTag().getAttribute("layout_weight", "http://schemas.android.com/apk/res/android");
            if (weight != null) {
                weight.delete();
            }
            if ((size = radViewComponent.getTag().getAttribute(sizeAttribute, "http://schemas.android.com/apk/res/android")) == null || !size.getValue().startsWith("0")) continue;
            size.setValue("wrap_content");
        }
    }
}

