/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model.grid;

import com.intellij.android.designer.designSurface.layout.CaptionStaticDecorator;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.StaticDecorator;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.model.RadComponentVisitor;
import com.intellij.designer.model.RadVisualComponent;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.hash.HashSet;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public abstract class RadCaptionComponent<T extends RadViewComponent>
extends RadVisualComponent {
    private final StaticDecorator myDecorator;
    private final EditableArea myMainArea;
    protected final T myContainer;
    protected final int myIndex;
    protected final int myOffset;
    protected final int myWidth;

    public RadCaptionComponent(EditableArea mainArea, T container, int index, int offset, int width, boolean empty) {
        this.myMainArea = mainArea;
        this.myContainer = container;
        this.myIndex = index;
        this.myOffset = offset;
        this.myWidth = width;
        this.myDecorator = empty ? new CaptionStaticDecorator(this, (Color)JBColor.PINK) : new CaptionStaticDecorator(this);
        this.setNativeComponent(((RadVisualComponent)((Object)container)).getNativeComponent());
    }

    public int getIndex() {
        return this.myIndex;
    }

    @Override
    public void addStaticDecorators(List<StaticDecorator> decorators, List<RadComponent> selection) {
        decorators.add(this.myDecorator);
    }

    protected final void deselect(List<RadComponent> components) {
        HashSet allComponents = new HashSet();
        for (RadComponent component : components) {
            component.accept(new RadComponentVisitor((Set)allComponents){
                final /* synthetic */ Set val$allComponents;
                {
                    this.val$allComponents = set;
                }

                @Override
                public void endVisit(RadComponent component) {
                    this.val$allComponents.add(component);
                }
            }, true);
        }
        this.myMainArea.deselect((Collection<RadComponent>)allComponents);
    }
}

