/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model;

import com.intellij.android.designer.designSurface.graphics.DrawingStyle;
import com.intellij.android.designer.designSurface.graphics.NonResizeSelectionDecorator;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.layout.actions.ToggleSizeAction;
import com.intellij.designer.designSurface.ComponentDecorator;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.designSurface.EmptyComponentDecorator;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.model.RadLayout;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import icons.AndroidDesignerIcons;
import java.util.List;

public class RadViewLayout
extends RadLayout {
    public static final RadLayout INSTANCE = new RadViewLayout();
    public static final ComponentDecorator NON_RESIZE_DECORATOR = new NonResizeSelectionDecorator(DrawingStyle.SELECTION);

    @Override
    public ComponentDecorator getChildSelectionDecorator(RadComponent component, List<RadComponent> selection) {
        if (component.isBackground()) {
            return EmptyComponentDecorator.INSTANCE;
        }
        return NON_RESIZE_DECORATOR;
    }

    public void addContainerSelectionActions(DesignerEditorPanel designer, DefaultActionGroup actionGroup, List<? extends RadViewComponent> selection) {
        if (!selection.isEmpty()) {
            RadViewLayout.addFillActions(designer, actionGroup, selection);
        }
    }

    static void addFillActions(DesignerEditorPanel designer, DefaultActionGroup actionGroup, List<? extends RadViewComponent> selection) {
        actionGroup.add((AnAction)new ToggleSizeAction(designer, selection, "Toggle Width", "layout_width", AndroidDesignerIcons.FillWidth, AndroidDesignerIcons.WrapWidth));
        actionGroup.add((AnAction)new ToggleSizeAction(designer, selection, "Toggle Height", "layout_height", AndroidDesignerIcons.FillHeight, AndroidDesignerIcons.WrapHeight));
    }

    public void wrapIn(RadViewComponent newParent, List<RadViewComponent> components) throws Exception {
    }
}

