/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.designSurface.layout.flow;

import com.intellij.android.designer.designSurface.graphics.DesignerGraphics;
import com.intellij.android.designer.designSurface.graphics.DrawingStyle;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.designer.designSurface.DecorationLayer;
import com.intellij.designer.designSurface.StaticDecorator;
import com.intellij.designer.model.RadComponent;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public abstract class FlowStaticDecorator
extends StaticDecorator {
    public FlowStaticDecorator(RadComponent component) {
        super(component);
    }

    @Override
    protected void paint(DecorationLayer layer, Graphics2D g, RadComponent component) {
        Rectangle bounds = component.getBounds(layer);
        DesignerGraphics.useStroke(DrawingStyle.GRID, g);
        g.drawRect(bounds.x, bounds.y, bounds.width, bounds.height);
        if (this.isHorizontal()) {
            for (RadComponent child : component.getChildren()) {
                Rectangle childBounds = child.getBounds(layer);
                int marginRight = ((RadViewComponent)child).getMargins((Component)layer).right;
                int x = childBounds.x + childBounds.width + marginRight;
                g.drawLine(x, bounds.y, x, bounds.y + bounds.height);
            }
        } else {
            for (RadComponent child : component.getChildren()) {
                Rectangle childBounds = child.getBounds(layer);
                int marginBottom = ((RadViewComponent)child).getMargins((Component)layer).bottom;
                int y = childBounds.y + childBounds.height + marginBottom;
                g.drawLine(bounds.x, y, bounds.x + bounds.width, y);
            }
        }
    }

    protected abstract boolean isHorizontal();
}

