/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.designSurface.layout.flow;

import com.android.tools.idea.designer.Insets;
import com.intellij.android.designer.designSurface.AbstractEditOperation;
import com.intellij.android.designer.designSurface.graphics.DrawingStyle;
import com.intellij.android.designer.designSurface.graphics.LineInsertFeedback;
import com.intellij.android.designer.designSurface.graphics.RectangleFeedback;
import com.intellij.android.designer.designSurface.layout.AbstractFlowBaseOperation;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.designer.designSurface.FeedbackLayer;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.model.RadComponent;
import java.awt.Rectangle;
import org.jetbrains.annotations.Nullable;

public class FlowBaseOperation
extends AbstractFlowBaseOperation {
    public FlowBaseOperation(RadComponent container, OperationContext context, boolean horizontal) {
        super(container, context, horizontal);
    }

    @Override
    protected void createFeedback() {
        if (this.myFirstInsertFeedback == null) {
            FeedbackLayer layer = this.myContext.getArea().getFeedbackLayer();
            this.myBounds = ((RadViewComponent)this.myContainer).getPaddedBounds(layer);
            this.createFirstInsertFeedback();
            this.createInsertFeedback();
            if (this.getChildren().isEmpty()) {
                layer.add(this.myFirstInsertFeedback);
            } else {
                layer.add(this.myInsertFeedback);
            }
            layer.repaint();
        }
    }

    @Override
    protected Rectangle getBounds(RadComponent component, FeedbackLayer layer) {
        Rectangle bounds = component.getBounds(layer);
        Insets margins = ((RadViewComponent)component).getMargins(layer);
        margins.subtractFrom(bounds);
        return bounds;
    }

    @Override
    protected void createInsertFeedback() {
        this.myInsertFeedback = new LineInsertFeedback(DrawingStyle.DROP_ZONE_ACTIVE, !this.myHorizontal);
        this.myInsertFeedback.size(this.myBounds.width, this.myBounds.height);
    }

    @Override
    protected void createFirstInsertFeedback() {
        this.myFirstInsertFeedback = new RectangleFeedback(DrawingStyle.DROP_ZONE_ACTIVE);
        this.myFirstInsertFeedback.setBounds(this.myBounds);
    }

    @Override
    protected void execute(@Nullable RadComponent insertBefore) throws Exception {
        AbstractEditOperation.execute(this.myContext, (RadViewComponent)this.myContainer, this.myComponents, (RadViewComponent)insertBefore);
    }
}

