/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.designSurface.layout.caption;

import com.intellij.android.designer.designSurface.layout.AbstractFlowBaseOperation;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.FeedbackLayer;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.designSurface.feedbacks.LineInsertFeedback;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.model.RadVisualComponent;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.SwingUtilities;

public abstract class VerticalCaptionFlowBaseOperation<T extends RadViewComponent>
extends AbstractFlowBaseOperation {
    protected final T myMainContainer;
    private final EditableArea myMainArea;
    private LineInsertFeedback myMainInsertFeedback;
    private int myMainXLocation;

    public VerticalCaptionFlowBaseOperation(T mainContainer, RadComponent container, OperationContext context, EditableArea mainArea) {
        super(container, context, false);
        this.myMainContainer = mainContainer;
        this.myMainArea = mainArea;
    }

    @Override
    protected void createFeedback() {
        super.createFeedback();
        if (this.myMainInsertFeedback == null) {
            FeedbackLayer layer = this.myMainArea.getFeedbackLayer();
            Rectangle bounds = ((RadVisualComponent)((Object)this.myMainContainer)).getBounds(layer);
            this.myMainXLocation = bounds.x;
            this.myMainInsertFeedback = new LineInsertFeedback((Color)JBColor.GREEN, true);
            this.myMainInsertFeedback.size(this.getMainFeedbackWidth(layer, this.myMainXLocation), 0);
            layer.add(this.myMainInsertFeedback);
            layer.repaint();
        }
    }

    protected int getMainFeedbackWidth(FeedbackLayer layer, int mainXLocation) {
        List<RadComponent> children = ((RadViewComponent)((Object)this.myMainContainer)).getChildren();
        Rectangle lastChildBounds = children.get(children.size() - 1).getBounds(layer);
        return lastChildBounds.x + lastChildBounds.width - mainXLocation;
    }

    @Override
    public void showFeedback() {
        super.showFeedback();
        Point location = SwingUtilities.convertPoint(this.myInsertFeedback.getParent(), this.myInsertFeedback.getLocation(), this.myMainArea.getFeedbackLayer());
        this.myMainInsertFeedback.setLocation(this.myMainXLocation, location.y);
    }

    @Override
    public void eraseFeedback() {
        super.eraseFeedback();
        if (this.myMainInsertFeedback != null) {
            FeedbackLayer layer = this.myMainArea.getFeedbackLayer();
            layer.remove(this.myMainInsertFeedback);
            layer.repaint();
            this.myMainInsertFeedback = null;
        }
    }
}

