/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.designSurface.layout.caption;

import com.intellij.android.designer.designSurface.layout.caption.VerticalCaptionFlowBaseOperation;
import com.intellij.android.designer.model.layout.grid.RadCaptionGridRow;
import com.intellij.android.designer.model.layout.grid.RadGridLayoutComponent;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.FeedbackLayer;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.model.RadComponent;
import java.awt.Component;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class GridVerticalCaptionOperation
extends VerticalCaptionFlowBaseOperation<RadGridLayoutComponent> {
    public GridVerticalCaptionOperation(RadGridLayoutComponent mainContainer, RadComponent container, OperationContext context, EditableArea mainArea) {
        super(mainContainer, container, context, mainArea);
    }

    @Override
    protected int getMainFeedbackWidth(FeedbackLayer layer, int mainXLocation) {
        return ((RadGridLayoutComponent)this.myMainContainer).getGridInfo().getSize((Component)layer).width;
    }

    @Override
    protected void execute(@Nullable RadComponent insertBefore) throws Exception {
        RadComponent[][] components = ((RadGridLayoutComponent)this.myMainContainer).getGridComponents(false);
        for (RadComponent component : this.myComponents) {
            component.removeFromParent();
            this.myContainer.add(component, insertBefore);
        }
        List<RadComponent> rows = this.myContainer.getChildren();
        int size = rows.size();
        for (int i = 0; i < size; ++i) {
            int index = ((RadCaptionGridRow)rows.get(i)).getIndex();
            RadComponent[] rowComponents = components[i];
            for (int j = 0; j < rowComponents.length; ++j) {
                RadComponent cellComponent = components[index][j];
                if (cellComponent == null) continue;
                RadGridLayoutComponent.setCellIndex(cellComponent, i, j, true, false);
            }
        }
    }
}

