/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.designSurface.layout.actions;

import com.intellij.android.designer.designSurface.layout.actions.LayoutSpanOperation;
import com.intellij.android.designer.designSurface.layout.grid.GridSelectionDecorator;
import com.intellij.android.designer.model.layout.grid.RadGridLayoutComponent;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.model.RadComponent;
import java.awt.Point;

public class GridLayoutSpanOperation
extends LayoutSpanOperation {
    public GridLayoutSpanOperation(OperationContext context, GridSelectionDecorator decorator) {
        super(context, decorator);
    }

    @Override
    public void setComponent(RadComponent component) {
        super.setComponent(component);
        int direction = this.myContext.getResizeDirection();
        this.mySpan = RadGridLayoutComponent.getSpan(this.myComponent, direction == 1 || direction == 2);
    }

    @Override
    protected String getColumnAttribute(boolean asName) {
        return asName ? "layout:column" : "layout_column";
    }

    @Override
    protected String getColumnSpanAttribute(boolean asName) {
        return asName ? "layout:columnSpan" : "layout_columnSpan";
    }

    @Override
    protected String getRowAttribute(boolean asName) {
        return asName ? "layout:row" : "layout_row";
    }

    @Override
    protected String getRowSpanAttribute(boolean asName) {
        return asName ? "layout:rowSpan" : "layout_rowSpan";
    }

    @Override
    protected Point getCellInfo() {
        return RadGridLayoutComponent.getCellInfo(this.myComponent).getLocation();
    }

    public static void points(GridSelectionDecorator decorator) {
        decorator.addPoint(new LayoutSpanOperation.SpanPoint(4, "layout_span", "Change layout:column x layout:columnSpan", decorator).move(0.0, 0.25));
        decorator.addPoint(new LayoutSpanOperation.SpanPoint(8, "layout_span", "Change layout:columnSpan", decorator).move(1.0, 0.75));
        decorator.addPoint(new LayoutSpanOperation.SpanPoint(1, "layout_span", "Change layout:row x layout:rowSpan", decorator).move(0.25, 0.0));
        decorator.addPoint(new LayoutSpanOperation.SpanPoint(2, "layout_span", "Change layout:rowSpan", decorator).move(0.75, 1.0));
    }
}

