/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.designSurface.layout;

import com.android.tools.idea.designer.FillPolicy;
import com.android.tools.idea.designer.ResizeContext;
import com.intellij.android.designer.AndroidDesignerUtils;
import com.intellij.android.designer.designSurface.AndroidDesignerEditorPanel;
import com.intellij.android.designer.designSurface.feedbacks.TextFeedback;
import com.intellij.android.designer.designSurface.graphics.DesignerGraphics;
import com.intellij.android.designer.designSurface.graphics.DrawingStyle;
import com.intellij.android.designer.designSurface.layout.flow.FlowBaseOperation;
import com.intellij.android.designer.model.RadComponentOperations;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.layout.Gravity;
import com.intellij.designer.designSurface.FeedbackLayer;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.palette.PaletteItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.IdeBorderFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinearLayoutOperation
extends FlowBaseOperation {
    private GravityFeedback myFeedback;
    private TextFeedback myTextFeedback;
    private FlowPositionFeedback myFlowFeedback;
    private Gravity myExclude;
    private Gravity myGravity;
    private boolean mySetGravity;
    private static final int MIN_MARGIN_DIMENSIONS = 100;

    public LinearLayoutOperation(RadComponent container, OperationContext context, boolean horizontal) {
        super(container, context, horizontal);
        if (context.isMove() && context.getComponents().size() == 1) {
            this.myExclude = LinearLayoutOperation.getGravity(this.myHorizontal, context.getComponents().get(0));
        }
    }

    @Override
    protected void createFeedback() {
        super.createFeedback();
        if (this.myTextFeedback == null) {
            FeedbackLayer layer = this.myContext.getArea().getFeedbackLayer();
            if (this.myHorizontal && this.myBounds.height > 100 || !this.myHorizontal && this.myBounds.width > 100) {
                this.mySetGravity = true;
                this.myFeedback = new GravityFeedback();
                if (this.myContainer.getChildren().isEmpty()) {
                    this.myFeedback.setBounds(this.myBounds);
                }
                layer.add((Component)this.myFeedback, 0);
            }
            this.myFlowFeedback = new FlowPositionFeedback();
            this.myFlowFeedback.setBounds(this.myBounds);
            layer.add((Component)this.myFlowFeedback, 0);
            this.myTextFeedback = new TextFeedback();
            this.myTextFeedback.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)3, (int)2, (int)0));
            layer.add((Component)((Object)this.myTextFeedback));
            layer.repaint();
        }
    }

    @Override
    public void showFeedback() {
        super.showFeedback();
        if (this.mySetGravity) {
            Gravity gravity;
            Point location = this.myContext.getLocation();
            Gravity gravity2 = gravity = this.myHorizontal ? this.calculateVertical(this.myBounds, location) : this.calculateHorizontal(this.myBounds, location);
            if (gravity == null) {
                Gravity gravity3 = gravity = this.myHorizontal ? Gravity.left : Gravity.top;
            }
            if (!this.myContainer.getChildren().isEmpty()) {
                this.myFeedback.setBounds(this.myInsertFeedback.getBounds());
            }
            this.myFeedback.setGravity(gravity);
            this.myTextFeedback.clear();
            if (gravity == Gravity.left || gravity == Gravity.top) {
                this.myTextFeedback.setVisible(false);
            } else {
                this.myTextFeedback.bold(gravity.name());
                this.myTextFeedback.setVisible(true);
            }
            this.myTextFeedback.centerTop(this.myBounds);
            this.myGravity = gravity;
        }
        this.myFlowFeedback.repaint();
    }

    @Override
    public void eraseFeedback() {
        super.eraseFeedback();
        if (this.myTextFeedback != null) {
            FeedbackLayer layer = this.myContext.getArea().getFeedbackLayer();
            if (this.mySetGravity) {
                layer.remove(this.myFeedback);
            }
            layer.remove((Component)((Object)this.myTextFeedback));
            layer.remove(this.myFlowFeedback);
            layer.repaint();
            this.myFeedback = null;
            this.myTextFeedback = null;
        }
    }

    @Nullable
    private Gravity calculateHorizontal(Rectangle bounds, Point location) {
        List<RadComponent> dragged = this.myContext.getComponents();
        assert (!dragged.isEmpty());
        if (dragged.size() > 1) {
            return Gravity.left;
        }
        RadComponent component = dragged.get(0);
        if (component.getBounds((Component)this.myContext.getArea().getFeedbackLayer()).width > bounds.width / 2) {
            return Gravity.left;
        }
        if (LinearLayoutOperation.isFilled(this.myHorizontal, (RadViewComponent)component)) {
            return Gravity.left;
        }
        int thirds = bounds.width / 3;
        int right = bounds.x + 2 * thirds;
        if (location.x >= right) {
            return Gravity.right;
        }
        int center = bounds.x + thirds;
        if (location.x >= center) {
            return Gravity.center;
        }
        return Gravity.left;
    }

    @Nullable
    private Gravity calculateVertical(Rectangle bounds, Point location) {
        List<RadComponent> dragged = this.myContext.getComponents();
        assert (!dragged.isEmpty());
        if (dragged.size() > 1) {
            return Gravity.top;
        }
        RadComponent component = dragged.get(0);
        if (component.getBounds((Component)this.myContext.getArea().getFeedbackLayer()).height > bounds.height / 2) {
            return Gravity.top;
        }
        if (LinearLayoutOperation.isFilled(this.myHorizontal, (RadViewComponent)component)) {
            return Gravity.top;
        }
        int thirds = bounds.height / 3;
        int bottom = bounds.y + 2 * thirds;
        if (location.y >= bottom) {
            return Gravity.bottom;
        }
        int center = bounds.y + thirds;
        if (location.y >= center) {
            return Gravity.center;
        }
        return Gravity.top;
    }

    @Override
    public boolean canExecute() {
        return super.canExecute() || this.myComponents.size() == 1 && this.myGravity != this.myExclude;
    }

    @Override
    public void execute() throws Exception {
        if (super.canExecute()) {
            super.execute();
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                Gravity gravity = LinearLayoutOperation.this.myGravity == Gravity.top || LinearLayoutOperation.this.myGravity == Gravity.left ? null : LinearLayoutOperation.this.myGravity;
                LinearLayoutOperation.this.execute(LinearLayoutOperation.this.myHorizontal, gravity, RadViewComponent.getViewComponents(LinearLayoutOperation.this.myComponents));
            }
        });
    }

    public static void applyGravity(boolean horizontal, @Nullable Gravity gravity, @NotNull List<? extends RadViewComponent> components) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/android/designer/designSurface/layout/LinearLayoutOperation", "applyGravity"));
        }
        if (gravity == null) {
            for (RadViewComponent radViewComponent : components) {
                XmlTag xmlTag = radViewComponent.getTag();
                RadComponentOperations.deleteAttribute(xmlTag, "layout_gravity");
            }
        } else {
            String gravityValue = horizontal ? Gravity.getValue(null, gravity) : Gravity.getValue(gravity, null);
            for (RadViewComponent radViewComponent : components) {
                XmlTag tag = radViewComponent.getTag();
                if (LinearLayoutOperation.isFilled(horizontal, radViewComponent)) {
                    tag.setAttribute(horizontal ? "layout_height" : "layout_width", "http://schemas.android.com/apk/res/android", "wrap_content");
                }
                if (gravityValue != null) {
                    tag.setAttribute("layout_gravity", "http://schemas.android.com/apk/res/android", gravityValue);
                    continue;
                }
                XmlAttribute a = tag.getAttribute("layout_gravity", "http://schemas.android.com/apk/res/android");
                if (a == null) continue;
                a.delete();
            }
        }
    }

    protected final String getFillParentValueName() {
        return this.supportsMatchParent() ? "match_parent" : "fill_parent";
    }

    protected final boolean supportsMatchParent() {
        AndroidPlatform platform;
        AndroidDesignerEditorPanel panel = AndroidDesignerUtils.getPanel(this.myContext.getArea());
        if (panel != null && (platform = AndroidPlatform.getPlatform(panel.getModule())) != null) {
            return platform.getApiLevel() >= 8;
        }
        return true;
    }

    public void execute(boolean horizontal, @Nullable Gravity gravity, @NotNull List<? extends RadViewComponent> components) {
        XmlTag tag;
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/android/designer/designSurface/layout/LinearLayoutOperation", "execute"));
        }
        LinearLayoutOperation.applyGravity(horizontal, gravity, components);
        if (this.myContext.isMove()) {
            return;
        }
        if (components.size() == 1) {
            RadViewComponent node = components.get(0);
            boolean vertical = !horizontal;
            FillPolicy fill = FillPolicy.getFillPreference(node);
            String fillParent = this.getFillParentValueName();
            XmlTag tag2 = node.getTag();
            if (fill.fillHorizontally(vertical)) {
                tag2.setAttribute("layout_width", "http://schemas.android.com/apk/res/android", fillParent);
            } else {
                tag2.setAttribute("layout_width", "http://schemas.android.com/apk/res/android", "wrap_content");
                if (!vertical && fill == FillPolicy.WIDTH_IN_VERTICAL) {
                    tag2.setAttribute("layout_weight", "http://schemas.android.com/apk/res/android", "1");
                }
            }
            if (fill.fillVertically(vertical)) {
                tag2.setAttribute("layout_height", "http://schemas.android.com/apk/res/android", fillParent);
            } else {
                tag2.setAttribute("layout_height", "http://schemas.android.com/apk/res/android", "wrap_content");
            }
        }
        boolean duplicateWeight = true;
        boolean duplicate0dip = true;
        String sameWeight = null;
        String sizeAttribute = horizontal ? "layout_width" : "layout_height";
        List<RadViewComponent> siblings = RadViewComponent.getViewComponents(this.myContainer.getChildren());
        for (RadViewComponent radViewComponent : siblings) {
            String size;
            if (components.contains((Object)radViewComponent)) continue;
            tag = radViewComponent.getTag();
            String weight = tag.getAttributeValue("layout_weight", "http://schemas.android.com/apk/res/android");
            if (weight == null || weight.length() == 0) {
                duplicateWeight = false;
                break;
            }
            if (sameWeight != null && !sameWeight.equals(weight)) {
                duplicateWeight = false;
            } else {
                sameWeight = weight;
            }
            if ((size = tag.getAttributeValue(sizeAttribute, "http://schemas.android.com/apk/res/android")) == null || size.startsWith("0")) continue;
            duplicate0dip = false;
            break;
        }
        if (duplicateWeight && sameWeight != null) {
            for (RadViewComponent radViewComponent : components) {
                tag = radViewComponent.getTag();
                tag.setAttribute("layout_weight", "http://schemas.android.com/apk/res/android", sameWeight);
                if (!duplicate0dip) continue;
                tag.setAttribute(sizeAttribute, "http://schemas.android.com/apk/res/android", "0dp");
            }
        }
    }

    @Nullable
    public static Gravity getGravity(boolean horizontal, RadComponent component) {
        XmlTag tag = ((RadViewComponent)component).getTag();
        String length = tag.getAttributeValue(horizontal ? "layout_height" : "layout_width", "http://schemas.android.com/apk/res/android");
        if (length != null && !ResizeContext.isFill(length)) {
            Pair<Gravity, Gravity> gravity = Gravity.getSides(component);
            return horizontal ? (Gravity)((Object)gravity.second) : (Gravity)((Object)gravity.first);
        }
        return null;
    }

    private static boolean isFilled(boolean horizontal, RadViewComponent component) {
        String creation;
        XmlTag tag = component.getTag();
        if (tag != null) {
            XmlAttribute attribute = tag.getAttribute(horizontal ? "layout_height" : "layout_width", "http://schemas.android.com/apk/res/android");
            if (attribute == null) {
                return false;
            }
            String value = attribute.getValue();
            return "match_parent".equals(value) || "fill_parent".equals(value);
        }
        PaletteItem paletteItem = component.getInitialPaletteItem();
        if (paletteItem != null && (creation = paletteItem.getCreation()) != null) {
            int index = creation.indexOf(horizontal ? "layout_width=\"wrap_content\"" : "layout_height=\"wrap_content\"");
            return index == -1;
        }
        return false;
    }

    private class GravityFeedback
    extends JComponent {
        @Nullable
        private Gravity myGravity;

        private GravityFeedback() {
        }

        public void setGravity(@Nullable Gravity gravity) {
            this.myGravity = gravity;
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (LinearLayoutOperation.this.myComponents.size() == 1) {
                RadViewComponent first = (RadViewComponent)((Object)LinearLayoutOperation.this.myComponents.get(0));
                Dimension size = AndroidDesignerUtils.computePreferredSize(LinearLayoutOperation.this.myContext.getArea(), first, LinearLayoutOperation.this.myContainer);
                Rectangle bounds = LinearLayoutOperation.this.myHorizontal ? this.computeHorizontalPreviewBounds(size) : this.computeVerticalPreviewBounds(size);
                Shape clip = g.getClip();
                g.setClip(bounds);
                DesignerGraphics.drawRect(DrawingStyle.DROP_PREVIEW, g, bounds.x, bounds.y, bounds.width, bounds.height);
                g.setClip(clip);
            } else if (LinearLayoutOperation.this.myHorizontal) {
                this.paintHorizontalCell(g);
            } else {
                this.paintVerticalCell(g);
            }
        }

        private Rectangle computeVerticalPreviewBounds(Dimension b) {
            int x = 0;
            int y = 0;
            if (!LinearLayoutOperation.this.myContainer.getChildren().isEmpty()) {
                y -= b.height / 2;
            }
            if (this.myGravity == Gravity.center) {
                x = this.getWidth() / 2 - b.width / 2;
            } else if (this.myGravity == null) {
                x = 0;
                b.width = this.getWidth();
            } else if (this.myGravity == Gravity.right) {
                x = this.getWidth() - b.width;
            }
            int width = b.width;
            int hSpace = Math.min(5, Math.max(1, this.getWidth() / 30));
            if (hSpace > 1) {
                x += hSpace;
                if ((width -= 2 * hSpace) < 5) {
                    width = 5;
                }
            }
            return new Rectangle(x, y, width, b.height);
        }

        private Rectangle computeHorizontalPreviewBounds(Dimension b) {
            int x = 0;
            int y = 0;
            if (!LinearLayoutOperation.this.myContainer.getChildren().isEmpty()) {
                x -= b.width / 2;
            }
            if (this.myGravity == Gravity.center) {
                y = this.getHeight() / 2 - b.height / 2;
            } else if (this.myGravity == null) {
                y = 0;
                b.height = this.getHeight();
            } else if (this.myGravity == Gravity.bottom) {
                y = this.getHeight() - b.height;
            }
            int vSpace = Math.min(5, Math.max(1, this.getHeight() / 30));
            int height = b.height;
            if (vSpace > 1) {
                y += vSpace;
                if ((height -= 2 * vSpace) < 5) {
                    height = 5;
                }
            }
            return new Rectangle(x, y, b.width, height);
        }

        private void paintHorizontalCell(Graphics g) {
            int y = 0;
            int height = (this.getHeight() - 3) / 4;
            if (this.myGravity == Gravity.center) {
                y = height + 1;
            } else if (this.myGravity == null) {
                y = 2 * height + 2;
            } else if (this.myGravity == Gravity.bottom) {
                y = this.getHeight() - height;
            }
            int vSpace = Math.min(5, Math.max(1, this.getHeight() / 30));
            if (vSpace > 1) {
                y += vSpace;
                height -= 2 * vSpace;
            }
            int thickness = DrawingStyle.GRAVITY.getLineWidth();
            if (LinearLayoutOperation.this.myContainer.getChildren().isEmpty()) {
                DesignerGraphics.drawFilledRect(DrawingStyle.GRAVITY, g, 0, y, thickness, height);
                DesignerGraphics.drawFilledRect(DrawingStyle.GRAVITY, g, ((LinearLayoutOperation)LinearLayoutOperation.this).myBounds.width - thickness, y, thickness, height);
            } else {
                DesignerGraphics.drawLine(DrawingStyle.GRAVITY, g, thickness / 2, y, thickness / 2, y + height);
            }
        }

        private void paintVerticalCell(Graphics g) {
            int x = 0;
            int width = (this.getWidth() - 3) / 4;
            if (this.myGravity == Gravity.center) {
                x = width + 1;
            } else if (this.myGravity == null) {
                x = 2 * width + 2;
            } else if (this.myGravity == Gravity.right) {
                x = this.getWidth() - width;
            }
            int hSpace = Math.min(5, Math.max(1, this.getWidth() / 30));
            if (hSpace > 1) {
                x += hSpace;
                width -= 2 * hSpace;
            }
            int thickness = DrawingStyle.GRAVITY.getLineWidth();
            if (LinearLayoutOperation.this.myContainer.getChildren().isEmpty()) {
                DesignerGraphics.drawFilledRect(DrawingStyle.GRAVITY, g, x, 0, width, thickness);
                DesignerGraphics.drawFilledRect(DrawingStyle.GRAVITY, g, x, ((LinearLayoutOperation)LinearLayoutOperation.this).myBounds.height - thickness, width, thickness);
            } else {
                DesignerGraphics.drawLine(DrawingStyle.GRAVITY, g, x, thickness / 2, x + width, thickness / 2);
            }
        }
    }

    private class FlowPositionFeedback
    extends JComponent {
        private FlowPositionFeedback() {
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Rectangle bounds = ((RadViewComponent)LinearLayoutOperation.this.myContainer).getPaddedBounds(this);
            RadComponent component = LinearLayoutOperation.this.myContainer;
            DesignerGraphics.drawRect(DrawingStyle.DROP_RECIPIENT, g, bounds.x, bounds.y, bounds.width, bounds.height);
            if (LinearLayoutOperation.this.myHorizontal) {
                for (RadComponent child : component.getChildren()) {
                    Rectangle childBounds = child.getBounds(this);
                    int marginRight = ((RadViewComponent)child).getMargins((Component)this).right;
                    int x = childBounds.x + childBounds.width + marginRight;
                    DesignerGraphics.drawLine(DrawingStyle.DROP_ZONE, g, x, bounds.y, x, bounds.y + bounds.height);
                }
            } else {
                for (RadComponent child : component.getChildren()) {
                    Rectangle childBounds = child.getBounds(this);
                    int marginBottom = ((RadViewComponent)child).getMargins((Component)this).bottom;
                    int y = childBounds.y + childBounds.height + marginBottom;
                    DesignerGraphics.drawLine(DrawingStyle.DROP_ZONE, g, bounds.x, y, bounds.x + bounds.width, y);
                }
            }
        }
    }
}

