/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.project.NewProjectImportGradleSyncListener;
import com.android.tools.idea.sdk.VersionCheck;
import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.wizard.AssetSetStep;
import com.android.tools.idea.wizard.AssetStudioAssetGenerator;
import com.android.tools.idea.wizard.ConfigureAndroidModuleStep;
import com.android.tools.idea.wizard.ConfigureAndroidProjectPath;
import com.android.tools.idea.wizard.NewModuleWizardState;
import com.android.tools.idea.wizard.NewProjectWizardState;
import com.android.tools.idea.wizard.TemplateGalleryStep;
import com.android.tools.idea.wizard.TemplateParameterStep;
import com.android.tools.idea.wizard.TemplateWizard;
import com.android.tools.idea.wizard.TemplateWizardState;
import com.android.tools.idea.wizard.TemplateWizardStep;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.pom.java.LanguageLevel;
import icons.AndroidIcons;
import java.awt.Dimension;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class NewProjectWizard
extends TemplateWizard
implements TemplateWizardStep.UpdateListener {
    private static final Logger LOG = Logger.getInstance((String)("#" + NewProjectWizard.class.getName()));
    private static final String ERROR_MSG_TITLE = "New Project Wizard";
    private static final String UNABLE_TO_CREATE_DIR_FORMAT = "Unable to create directory '%1$s'.";
    NewProjectWizardState myWizardState;
    AssetStudioAssetGenerator myAssetGenerator;
    AssetSetStep myAssetSetStep;
    TemplateGalleryStep myChooseActivityStep;
    TemplateParameterStep myActivityParameterStep;
    ConfigureAndroidModuleStep myConfigureAndroidModuleStep;
    boolean myInitializationComplete = false;

    public NewProjectWizard() {
        super("New Project", null);
        Window window = this.getWindow();
        if (window != null) {
            this.getWindow().setMinimumSize(new Dimension(1000, 640));
        } else assert (ApplicationManager.getApplication().isUnitTestMode());
        this.init();
    }

    @Override
    protected void init() {
        if (!AndroidSdkUtils.isAndroidSdkAvailable() || !TemplateManager.templatesAreValid()) {
            String title = "SDK problem";
            String msg = "<html>Your Android SDK is missing, out of date, or is missing templates. Please ensure you are using SDK version " + VersionCheck.MIN_TOOLS_REV + " or later.<br>" + "You can configure your SDK via <b>Configure | Project Defaults | Project Structure | SDKs</b></html>";
            super.init();
            Messages.showErrorDialog((String)msg, (String)title);
            throw new IllegalStateException(msg);
        }
        this.myWizardState = new NewProjectWizardState();
        Template.convertApisToInt(this.myWizardState.getParameters());
        this.myWizardState.put("gradleVersion", "1.12");
        this.myWizardState.put("gradlePluginVersion", "0.12.2");
        this.myWizardState.put("perModuleRepositories", false);
        this.myConfigureAndroidModuleStep = new ConfigureAndroidModuleStep(this.myWizardState, this.myProject, AndroidIcons.Wizards.NewProjectSidePanel, this);
        this.myConfigureAndroidModuleStep.updateStep();
        this.myAssetSetStep = new AssetSetStep(this.myWizardState, this.myProject, null, AndroidIcons.Wizards.NewProjectSidePanel, this, null);
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myAssetSetStep);
        this.myAssetGenerator = new AssetStudioAssetGenerator(this.myWizardState);
        this.myAssetSetStep.finalizeAssetType(AssetStudioAssetGenerator.AssetType.LAUNCHER);
        this.myChooseActivityStep = new TemplateGalleryStep(this.myWizardState.getActivityTemplateState(), "activities", this.myProject, null, AndroidIcons.Wizards.NewProjectSidePanel, this, null);
        this.myActivityParameterStep = new TemplateParameterStep(this.myWizardState.getActivityTemplateState(), this.myProject, null, AndroidIcons.Wizards.NewProjectSidePanel, this);
        this.mySteps.add(this.myConfigureAndroidModuleStep);
        this.mySteps.add(this.myAssetSetStep);
        this.mySteps.add(this.myChooseActivityStep);
        this.mySteps.add(this.myActivityParameterStep);
        this.myInitializationComplete = true;
        super.init();
    }

    @Override
    public void update() {
        if (!this.myInitializationComplete) {
            return;
        }
        this.myAssetSetStep.setVisible(this.myWizardState.getBoolean("createIcons"));
        this.myChooseActivityStep.setVisible(this.myWizardState.getBoolean("createActivity"));
        this.myActivityParameterStep.setVisible(this.myWizardState.getBoolean("createActivity"));
        super.update();
    }

    public void createProject() {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                NewProjectWizard.createProject(NewProjectWizard.this.myWizardState, null, NewProjectWizard.this.myAssetGenerator);
            }
        });
    }

    public static void createProject(final @NotNull NewModuleWizardState wizardState, @Nullable Project project, @Nullable AssetStudioAssetGenerator assetGenerator) {
        if (wizardState == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/wizard/NewProjectWizard", "createProject"));
        }
        ArrayList errors = Lists.newArrayList();
        try {
            wizardState.populateDirectoryParameters();
            String moduleName = wizardState.getString("projectName");
            String projectName = wizardState.getString("appTitle");
            File projectRoot = new File(wizardState.getString("projectLocation"));
            File moduleRoot = new File(projectRoot, moduleName);
            if (FileUtilRt.createDirectory((File)projectRoot)) {
                Object version;
                if (wizardState.getBoolean("createIcons") && assetGenerator != null) {
                    assetGenerator.outputImagesIntoDefaultVariant(moduleRoot);
                }
                wizardState.updateParameters();
                wizardState.updateDependencies();
                if (wizardState instanceof NewProjectWizardState) {
                    ((NewProjectWizardState)wizardState).myProjectTemplate.render(projectRoot, moduleRoot, wizardState.myParameters);
                    ConfigureAndroidProjectPath.setGradleWrapperExecutable(projectRoot);
                }
                wizardState.myTemplate.render(projectRoot, moduleRoot, wizardState.myParameters);
                if (wizardState.getBoolean("createActivity")) {
                    TemplateWizardState activityTemplateState = wizardState.getActivityTemplateState();
                    activityTemplateState.populateRelativePackage(null);
                    Template template = activityTemplateState.getTemplate();
                    assert (template != null);
                    template.render(moduleRoot, moduleRoot, activityTemplateState.myParameters);
                    wizardState.myTemplate.getFilesToOpen().addAll(template.getFilesToOpen());
                }
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    return;
                }
                GradleProjectImporter projectImporter = GradleProjectImporter.getInstance();
                LanguageLevel initialLanguageLevel = null;
                Object object = version = wizardState.hasAttr("javaVersion") ? wizardState.get("javaVersion") : null;
                if (version != null) {
                    initialLanguageLevel = LanguageLevel.parse((String)version.toString());
                }
                projectImporter.importProject(projectName, projectRoot, true, new NewProjectImportGradleSyncListener(){

                    @Override
                    public void syncSucceeded(final @NotNull Project project) {
                        if (project == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/wizard/NewProjectWizard$2", "syncSucceeded"));
                        }
                        StartupManagerEx manager = StartupManagerEx.getInstanceEx((Project)project);
                        if (!manager.postStartupActivityPassed()) {
                            manager.registerPostStartupActivity(new Runnable(){

                                @Override
                                public void run() {
                                    this.openTemplateFiles(project);
                                }
                            });
                        } else {
                            this.openTemplateFiles(project);
                        }
                    }

                    private boolean openTemplateFiles(Project project) {
                        return TemplateUtils.openEditors(project, wizardState.myTemplate.getFilesToOpen(), true);
                    }
                }, project, initialLanguageLevel);
            } else {
                errors.add(String.format(UNABLE_TO_CREATE_DIR_FORMAT, projectRoot.getPath()));
            }
        }
        catch (Exception e) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new RuntimeException(e);
            }
            Messages.showErrorDialog((String)e.getMessage(), (String)ERROR_MSG_TITLE);
            LOG.error((Throwable)e);
        }
        if (!errors.isEmpty()) {
            String msg = errors.size() == 1 ? (String)errors.get(0) : Joiner.on((char)'\n').join((Iterable)errors);
            Messages.showErrorDialog((String)msg, (String)ERROR_MSG_TITLE);
            LOG.error(msg);
        }
    }
}

