/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.tools.idea.gradle.project.ModuleToImport;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.wizard.ImportUIUtil;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.table.JBTable;
import com.intellij.util.BitUtil;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModulesTable
extends JBTable {
    public static final String PROPERTY_SELECTED_MODULES = "selectedModules";
    @Nullable
    private Project myProject;
    @Nullable
    private VirtualFile myCurrentPath;
    private Map<ModuleToImport, ModuleValidationState> myModules;
    private Set<ModuleToImport> myUncheckedModules = new HashSet<ModuleToImport>();
    private Multimap<ModuleToImport, ModuleToImport> myRequiredModules;
    private boolean myHasPrimaryModule;

    public ModulesTable() {
        this.setModel(new ModulesTableModel());
        this.setGridColor(UIUtil.getSlightlyDarkerColor((Color)this.getBackground()));
        this.getColumnModel().getColumn(0).setCellEditor((TableCellEditor)((Object)new ModuleNameCellEditor()));
        this.getColumnModel().getColumn(0).setCellRenderer(new ModuleNameCellEditor());
        this.getColumnModel().getColumn(1).setCellRenderer(new ModulePathCellRenderer());
        this.setSelectionMode(0);
    }

    @Nullable
    public String getDescription(@Nullable ModuleToImport module, @NotNull ModuleValidationState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/wizard/ModulesTable", "getDescription"));
        }
        switch (state) {
            case OK: 
            case NULL: 
            case PRIMARY: {
                return null;
            }
            case NOT_FOUND: {
                return "Module sources not found";
            }
            case ALREADY_EXISTS: {
                return "Project already contains module with this name";
            }
            case REQUIRED: {
                Iterable requiredBy = Iterables.transform((Iterable)this.myRequiredModules.get((Object)module), (Function)new Function<ModuleToImport, String>(){

                    public String apply(ModuleToImport input) {
                        return input.name;
                    }
                });
                return ImportUIUtil.formatElementListString(requiredBy, "Required by %s", "Required by %s and %s", "Required by %s and %d more subprojects");
            }
        }
        throw new IllegalStateException(state.name());
    }

    private void configureComponent(JComponent component, @Nullable ModuleToImport module, @NotNull JTable table, boolean isSelected) {
        Color foreground;
        Color background;
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/wizard/ModulesTable", "configureComponent"));
        }
        if (isSelected) {
            background = table.getSelectionBackground();
            foreground = table.getSelectionForeground();
        } else {
            background = table.getBackground();
            foreground = table.getForeground();
        }
        Font font = component.getFont();
        ModuleValidationState state = this.getModuleValidationState(module);
        int style = BitUtil.set((int)font.getStyle(), (int)1, (boolean)state.isBoldFont());
        component.setFont(font.deriveFont(style));
        component.setBackground(background);
        component.setForeground(foreground);
        component.setEnabled(state == ModuleValidationState.PRIMARY || state.canToggle());
        component.setToolTipText(this.getDescription(module, state));
    }

    private static String getRelativePath(@Nullable VirtualFile baseFile, @Nullable VirtualFile file) {
        if (file == null) {
            return "";
        }
        String path = file.getPath();
        if (baseFile == null) {
            return path;
        }
        if (file.equals(baseFile)) {
            return ".";
        }
        if (!baseFile.isDirectory()) {
            return ModulesTable.getRelativePath(baseFile.getParent(), file);
        }
        String basePath = baseFile.getPath();
        if (path.startsWith(basePath + "/")) {
            return path.substring(basePath.length() + 1);
        }
        if (file.getFileSystem().equals(baseFile.getFileSystem())) {
            StringBuilder builder = new StringBuilder(basePath.length());
            String prefix = Strings.commonPrefix((CharSequence)path, (CharSequence)basePath);
            if (!prefix.endsWith("/")) {
                prefix = prefix.substring(0, prefix.lastIndexOf("/") + 1);
            }
            if (!path.startsWith(basePath)) {
                Iterable segments = Splitter.on((String)"/").split((CharSequence)basePath.substring(prefix.length()));
                Joiner.on((String)"/").appendTo(builder, Iterables.transform((Iterable)segments, (Function)Functions.constant((Object)"..")));
                builder.append("/");
            }
            builder.append(path.substring(prefix.length()));
            return builder.toString();
        }
        return path;
    }

    public List<ModuleToImport> getSelectedModules() {
        ArrayList<ModuleToImport> result = new ArrayList<ModuleToImport>(this.myModules.keySet().size());
        for (ModuleToImport module : this.myModules.keySet()) {
            if (!this.isModuleSelected(module)) continue;
            result.add(module);
        }
        return result;
    }

    private boolean isModuleSelected(@Nullable ModuleToImport module) {
        Boolean checked = this.getModuleValidationState(module).isChecked();
        return checked != null ? checked : !this.myUncheckedModules.contains(module);
    }

    public void setModules(@Nullable Project project, @Nullable VirtualFile currentPath, @Nullable Iterable<ModuleToImport> modules) {
        this.myCurrentPath = currentPath;
        this.myProject = project;
        if (modules == null) {
            this.myModules = Collections.emptyMap();
        } else {
            this.myModules = Maps.newTreeMap((Comparator)new ModuleComparator(this.myCurrentPath));
            for (ModuleToImport module : modules) {
                this.myModules.put(module, null);
            }
        }
        this.revalidate(this.myModules.keySet());
        ((ModulesTableModel)this.getModel()).setModules(this.myModules.keySet());
    }

    private void revalidate(Set<ModuleToImport> modules) {
        for (ModuleToImport module : modules) {
            this.myModules.put(module, this.validateModule(module));
        }
        boolean bl = this.myHasPrimaryModule = !Maps.filterValues(this.myModules, (Predicate)Predicates.equalTo((Object)((Object)ModuleValidationState.PRIMARY))).isEmpty();
        if (!this.myHasPrimaryModule) {
            this.computeRequiredModules();
        }
    }

    private void computeRequiredModules() {
        Set validModules = Maps.filterValues(this.myModules, (Predicate)Predicates.in(Arrays.asList(ModuleValidationState.OK, ModuleValidationState.PRIMARY))).keySet();
        HashMap namesToModules = Maps.newHashMapWithExpectedSize((int)this.myModules.size());
        for (ModuleToImport module : validModules) {
            namesToModules.put(module.name, module);
        }
        this.myRequiredModules = LinkedListMultimap.create();
        LinkedList queue = Lists.newLinkedList((Iterable)Iterables.filter(validModules, (Predicate)Predicates.not((Predicate)Predicates.in(this.myUncheckedModules))));
        while (!queue.isEmpty()) {
            ModuleToImport moduleToImport = (ModuleToImport)queue.remove();
            for (ModuleToImport dep : Iterables.transform(moduleToImport.getDependencies(), (Function)Functions.forMap((Map)namesToModules, null))) {
                if (dep == null) continue;
                if (!this.myRequiredModules.containsKey((Object)dep)) {
                    queue.add(dep);
                }
                this.myRequiredModules.put((Object)dep, (Object)moduleToImport);
            }
        }
    }

    protected TableModel createDefaultDataModel() {
        return new ModulesTableModel();
    }

    private void setModuleSelection(@Nullable ModuleToImport module, boolean selected) {
        if (module != null && this.getModuleValidationState(module).canToggle()) {
            List<ModuleToImport> old = this.getSelectedModules();
            if (selected) {
                this.myUncheckedModules.remove(module);
            } else {
                this.myUncheckedModules.add(module);
            }
            this.computeRequiredModules();
            List<ModuleToImport> current = this.getSelectedModules();
            this.firePropertyChange(PROPERTY_SELECTED_MODULES, old, current);
        }
    }

    private ModuleValidationState validateModule(ModuleToImport module) {
        VirtualFile location = module.location;
        if (location == null) {
            return ModuleValidationState.NOT_FOUND;
        }
        if (GradleUtil.hasModule(this.myProject, module.name, true)) {
            return ModuleValidationState.ALREADY_EXISTS;
        }
        if (Objects.equal((Object)location, (Object)this.myCurrentPath)) {
            return ModuleValidationState.PRIMARY;
        }
        return ModuleValidationState.OK;
    }

    @NotNull
    private ModuleValidationState getModuleValidationState(@Nullable ModuleToImport module) {
        if (module == null) {
            ModuleValidationState moduleValidationState = ModuleValidationState.NULL;
            if (moduleValidationState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ModulesTable", "getModuleValidationState"));
            }
            return moduleValidationState;
        }
        ModuleValidationState state = this.myModules.get(module);
        if (!this.myHasPrimaryModule && state == ModuleValidationState.OK && this.myRequiredModules.containsKey((Object)module)) {
            ModuleValidationState moduleValidationState = ModuleValidationState.REQUIRED;
            if (moduleValidationState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ModulesTable", "getModuleValidationState"));
            }
            return moduleValidationState;
        }
        ModuleValidationState moduleValidationState = state;
        if (moduleValidationState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ModulesTable", "getModuleValidationState"));
        }
        return moduleValidationState;
    }

    private class ModulesTableModel
    extends AbstractTableModel {
        private List<ModuleToImport> myModules = Collections.emptyList();

        private ModulesTableModel() {
        }

        @Override
        public int getRowCount() {
            return this.myModules.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            ModuleToImport module = this.myModules.get(rowIndex);
            return !ModulesTable.this.myHasPrimaryModule && columnIndex == 0 && ModulesTable.this.getModuleValidationState(module).canToggle();
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            ModuleToImport module = this.myModules.get(rowIndex);
            if (columnIndex == 0) {
                ModulesTable.this.setModuleSelection(module, Boolean.TRUE.equals(aValue));
            }
            this.fireTableRowsUpdated(0, this.myModules.size() - 1);
        }

        @Override
        public Object getValueAt(int row, int column) {
            return this.myModules.get(row);
        }

        public void setModules(@NotNull Collection<ModuleToImport> modules) {
            if (modules == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/wizard/ModulesTable$ModulesTableModel", "setModules"));
            }
            this.myModules = new ArrayList<ModuleToImport>(modules);
            this.fireTableDataChanged();
        }
    }

    private final class ModuleNameCellEditor
    extends AbstractTableCellEditor
    implements TableCellRenderer {
        private final JBCheckBox myCheckBox = new JBCheckBox();
        private final JLabel myLabel = new JLabel();

        public ModuleNameCellEditor() {
            this.myCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ModuleNameCellEditor.this.stopCellEditing();
                }
            });
            this.myCheckBox.setOpaque(true);
            this.myLabel.setOpaque(true);
        }

        private JComponent setupComponent(@NotNull JTable table, @Nullable ModuleToImport module, @NotNull JBCheckBox checkBox, boolean isSelected) {
            JLabel component;
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/wizard/ModulesTable$ModuleNameCellEditor", "setupComponent"));
            }
            if (checkBox == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/wizard/ModulesTable$ModuleNameCellEditor", "setupComponent"));
            }
            String text = module != null ? module.name : "<No Module>";
            if (ModulesTable.this.myHasPrimaryModule) {
                this.myLabel.setText(text);
                component = this.myLabel;
            } else {
                checkBox.setText(text);
                checkBox.setSelected(ModulesTable.this.isModuleSelected(module));
                component = checkBox;
            }
            ModulesTable.this.configureComponent(component, module, table, isSelected);
            return component;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return this.setupComponent(table, (ModuleToImport)value, this.myCheckBox, true);
        }

        public Object getCellEditorValue() {
            return this.myCheckBox.isSelected();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this.setupComponent(table, (ModuleToImport)value, this.myCheckBox, isSelected);
        }
    }

    private class ModulePathCellRenderer
    implements TableCellRenderer {
        private final JLabel myLabel = new JLabel();

        public ModulePathCellRenderer() {
            this.myLabel.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ModuleToImport module = (ModuleToImport)value;
            this.myLabel.setText(this.getModulePath(module));
            ModulesTable.this.configureComponent(this.myLabel, module, table, isSelected);
            return this.myLabel;
        }

        private String getModulePath(ModuleToImport module) {
            if (module == null || module.location == null) {
                return "";
            }
            if (ModulesTable.this.getModuleValidationState(module) == ModuleValidationState.PRIMARY) {
                return module.location.getPath();
            }
            return ModulesTable.getRelativePath(ModulesTable.this.myCurrentPath, module.location);
        }
    }

    private static class ModuleComparator
    implements Comparator<ModuleToImport> {
        @Nullable
        private final VirtualFile myImportPath;

        public ModuleComparator(@Nullable VirtualFile importPath) {
            this.myImportPath = importPath;
        }

        @Override
        public int compare(ModuleToImport o1, ModuleToImport o2) {
            if (o1 == null) {
                return o2 == null ? 0 : 1;
            }
            if (o2 == null) {
                return -1;
            }
            VirtualFile l1 = o1.location;
            VirtualFile l2 = o2.location;
            Collator collator = Collator.getInstance();
            int namesComparison = collator.compare(o1.name, o2.name);
            if (l1 == null) {
                return l2 == null ? namesComparison : 1;
            }
            if (l2 == null) {
                return -1;
            }
            if (Objects.equal((Object)l1, (Object)this.myImportPath)) {
                return Objects.equal((Object)l2, (Object)this.myImportPath) ? namesComparison : -1;
            }
            if (Objects.equal((Object)l2, (Object)this.myImportPath)) {
                return 1;
            }
            int pathComparison = collator.compare(l1.getPath(), l2.getPath());
            return pathComparison == 0 ? namesComparison : pathComparison;
        }
    }

    private static enum ModuleValidationState {
        OK(null),
        NULL(false),
        NOT_FOUND(false),
        ALREADY_EXISTS(false),
        PRIMARY(true),
        REQUIRED(true);

        private final Boolean myAlwaysChecked;

        private ModuleValidationState(Boolean alwaysChecked) {
            this.myAlwaysChecked = alwaysChecked;
        }

        @Nullable
        public Boolean isChecked() {
            return this.myAlwaysChecked;
        }

        public boolean isBoldFont() {
            return this == PRIMARY;
        }

        public boolean canToggle() {
            return this == OK;
        }
    }
}

