/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.templates.Template;
import com.android.tools.idea.wizard.AssetStudioAssetGenerator;
import com.android.tools.idea.wizard.ChooseTemplateStep;
import com.android.tools.idea.wizard.ImportSourceModulePath;
import com.android.tools.idea.wizard.NewModuleWizardState;
import com.android.tools.idea.wizard.NewProjectWizard;
import com.android.tools.idea.wizard.NewProjectWizardState;
import com.android.tools.idea.wizard.TemplateWizardStep;
import com.android.tools.idea.wizard.WizardPath;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.VirtualFile;
import icons.AndroidIcons;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportWizardModuleBuilder
extends ModuleBuilder
implements TemplateWizardStep.UpdateListener,
ChooseTemplateStep.TemplateChangeListener {
    @Nullable
    private final VirtualFile myImportSource;
    @NotNull
    protected final List<ModuleWizardStep> mySteps;
    @NotNull
    private final Map<ModuleWizardStep, WizardPath> myStepsToPath;
    @Nullable
    private Project myProject;
    @NotNull
    protected final Iterable<WizardPath> myPaths;
    protected final NewModuleWizardState myWizardState;
    protected boolean myInitializationComplete;
    private ImportSourceModulePath myImportSourcesPath;

    public ImportWizardModuleBuilder(@Nullable File templateFile, @Nullable Project project, @Nullable VirtualFile importSource, @Nullable Icon sidePanelIcon, @NotNull List<ModuleWizardStep> steps, @NotNull Disposable disposable, boolean inGlobalWizard) {
        if (steps == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/android/tools/idea/wizard/ImportWizardModuleBuilder", "<init>"));
        }
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/android/tools/idea/wizard/ImportWizardModuleBuilder", "<init>"));
        }
        this.myStepsToPath = Maps.newHashMap();
        this.myInitializationComplete = false;
        this.myProject = project;
        this.myImportSource = importSource;
        this.mySteps = steps;
        this.myWizardState = project == null ? new NewProjectWizardState(){

            @Override
            public void setTemplateLocation(@NotNull File file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/wizard/ImportWizardModuleBuilder$1", "setTemplateLocation"));
                }
                super.setTemplateLocation(file);
                ImportWizardModuleBuilder.this.update();
            }
        } : new NewModuleWizardState(){

            @Override
            public void setTemplateLocation(@NotNull File file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/wizard/ImportWizardModuleBuilder$2", "setTemplateLocation"));
                }
                super.setTemplateLocation(file);
                ImportWizardModuleBuilder.this.update();
            }
        };
        this.myWizardState.put("isLauncher", project == null);
        this.myWizardState.updateParameters();
        if (templateFile != null) {
            this.myWizardState.setTemplateLocation(templateFile);
        }
        if (inGlobalWizard) {
            if (this.myProject != null) {
                this.myWizardState.myHidden.add("projectName");
            }
            this.myWizardState.myHidden.add("projectLocation");
        }
        Template.convertApisToInt(this.myWizardState.getParameters());
        Iterable<WizardPath> paths = this.setupWizardPaths(project, sidePanelIcon, disposable);
        this.myPaths = inGlobalWizard ? Iterables.filter(paths, (Predicate)new Predicate<WizardPath>(){

            public boolean apply(WizardPath input) {
                return input.supportsGlobalWizard();
            }
        }) : paths;
        for (WizardPath path : this.myPaths) {
            this.addSteps(path);
        }
        this.myWizardState.setDefaultWizardPath(this.getDefaultPath());
        if (project != null) {
            this.myWizardState.put("projectLocation", project.getBasePath());
        }
        this.myWizardState.put("gradleVersion", "1.12");
        this.myWizardState.put("gradlePluginVersion", "0.12.2");
        this.update();
        this.myInitializationComplete = true;
    }

    protected WizardPath getDefaultPath() {
        return this.myImportSourcesPath;
    }

    protected Iterable<WizardPath> setupWizardPaths(@Nullable Project project, @Nullable Icon sidePanelIcon, Disposable disposable) {
        this.myImportSourcesPath = new ImportSourceModulePath(this.myImportSource, this.myWizardState, new WizardContext(project), sidePanelIcon, this);
        return ImmutableList.of((Object)this.myImportSourcesPath);
    }

    protected void addSteps(WizardPath path) {
        Collection<ModuleWizardStep> steps = path.getSteps();
        this.mySteps.addAll(steps);
        this.myStepsToPath.putAll((Map<ModuleWizardStep, WizardPath>)Maps.toMap(steps, (Function)Functions.constant((Object)path)));
    }

    public boolean isStepVisible(ModuleWizardStep step) {
        WizardPath path = this.myStepsToPath.get(step);
        return path == null ? step.isStepVisible() : path == this.myWizardState.getActiveWizardPath() && path.isStepVisible(step);
    }

    public boolean updateWizardSteps() {
        if (!this.myInitializationComplete) {
            return false;
        }
        this.myWizardState.getActiveWizardPath().update();
        return true;
    }

    public void setupModuleBuilder(boolean haveGlobalRepository) {
        this.myWizardState.myHidden.add("isLibraryProject");
        this.myWizardState.put("perModuleRepositories", !haveGlobalRepository);
    }

    @NotNull
    public ModuleWizardStep[] createWizardSteps(@NotNull WizardContext wizardContext, @NotNull ModulesProvider modulesProvider) {
        if (wizardContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/wizard/ImportWizardModuleBuilder", "createWizardSteps"));
        }
        if (modulesProvider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/wizard/ImportWizardModuleBuilder", "createWizardSteps"));
        }
        this.update();
        ModuleWizardStep[] moduleWizardStepArray = this.mySteps.toArray(new ModuleWizardStep[this.mySteps.size()]);
        if (moduleWizardStepArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ImportWizardModuleBuilder", "createWizardSteps"));
        }
        return moduleWizardStepArray;
    }

    @Nullable
    public ModuleWizardStep modifySettingsStep(@NotNull SettingsStep settingsStep) {
        String applicationName;
        if (settingsStep == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/wizard/ImportWizardModuleBuilder", "modifySettingsStep"));
        }
        if (this.myWizardState.hasAttr("appTitle") && !(applicationName = this.myWizardState.getString("appTitle")).isEmpty()) {
            settingsStep.getModuleNameField().setText(applicationName.replace(" ", ""));
        }
        return null;
    }

    @Override
    public void update() {
        if (!this.myInitializationComplete) {
            return;
        }
        this.updateWizardSteps();
    }

    public void setupRootModel(@NotNull ModifiableRootModel rootModel) throws ConfigurationException {
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/wizard/ImportWizardModuleBuilder", "setupRootModel"));
        }
        final Project project = rootModel.getProject();
        if (this.myJdk != null) {
            rootModel.setSdk(this.myJdk);
        } else {
            rootModel.inheritSdk();
        }
        if (this.myProject == null) {
            project.putUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT, (Object)Boolean.TRUE);
        }
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized((Runnable)new DumbAwareRunnable(){

            public void run() {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ApplicationManager.getApplication().runWriteAction(new Runnable(){

                            @Override
                            public void run() {
                                if (ImportWizardModuleBuilder.this.myProject == null) {
                                    ImportWizardModuleBuilder.this.myWizardState.putSdkDependentParams();
                                    ImportWizardModuleBuilder.this.myWizardState.put("projectLocation", project.getBasePath());
                                    AssetStudioAssetGenerator assetGenerator = new AssetStudioAssetGenerator(ImportWizardModuleBuilder.this.myWizardState);
                                    NewProjectWizard.createProject(ImportWizardModuleBuilder.this.myWizardState, project, assetGenerator);
                                } else {
                                    ImportWizardModuleBuilder.this.myWizardState.put("projectName", ImportWizardModuleBuilder.this.getName());
                                    ImportWizardModuleBuilder.this.createModule();
                                }
                            }
                        });
                    }
                });
            }
        });
    }

    @NotNull
    public ModuleType getModuleType() {
        ModuleType moduleType = StdModuleTypes.JAVA;
        if (moduleType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ImportWizardModuleBuilder", "getModuleType"));
        }
        return moduleType;
    }

    public Icon getBigIcon() {
        return AndroidIcons.Android24;
    }

    public Icon getNodeIcon() {
        return AndroidIcons.Android;
    }

    public void createModule() {
        this.createModule(true);
    }

    public void createModule(boolean performGradleSync) {
        WizardPath path = this.myWizardState.getActiveWizardPath();
        path.createModule();
        if (performGradleSync && this.myProject != null) {
            GradleProjectImporter.getInstance().requestProjectSync(this.myProject, null);
        }
    }

    public boolean isSuitableSdkType(SdkTypeId sdkType) {
        boolean isJavaTemplate = this.myWizardState.isOnDefaultWizardPath() && NewModuleWizardState.isAndroidTemplate(this.myWizardState.getTemplateMetadata());
        return isJavaTemplate ? sdkType instanceof JavaSdkType : AndroidSdkType.getInstance().equals(sdkType);
    }

    @Override
    public void templateChanged(String templateName) {
        this.myWizardState.templateChanged(this.myProject, templateName);
        for (ModuleWizardStep step : this.mySteps) {
            step.updateStep();
        }
    }
}

