/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.Nullable;

public class ImportUIUtil {
    private ImportUIUtil() {
    }

    public static String formatElementListString(Iterable<String> values, String oneElementMessage, String twoOrThreeElementsMessage, String moreThenThreeElementsMessage) {
        int size = Iterables.size(values);
        if (size <= 1) {
            return String.format(oneElementMessage, Iterables.getFirst(values, (Object)"<validation error>"));
        }
        if (size <= 3) {
            return String.format(twoOrThreeElementsMessage, ImportUIUtil.atMostTwo(values, size), Iterables.getLast(values));
        }
        return String.format(moreThenThreeElementsMessage, ImportUIUtil.atMostTwo(values, size), size - 2);
    }

    private static String atMostTwo(Iterable<String> names, int size) {
        return Joiner.on((String)", ").join(Iterables.limit(names, (int)Math.min(size - 1, 2)));
    }

    @Nullable
    public static String makeHtmlString(@Nullable String templateDescription) {
        if (!StringUtil.isEmpty((String)templateDescription) && !templateDescription.startsWith("<html>")) {
            templateDescription = String.format("<html>%1$s</html>", templateDescription.trim());
        }
        return templateDescription;
    }
}

