/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.tools.idea.wizard.AndroidStudioWizardPath;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.android.tools.idea.wizard.WizardConstants;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.wizard.Step;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogEarthquakeShaker;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DynamicWizard
extends DialogWrapper
implements ScopedStateStore.ScopedStoreListener {
    Logger LOG;
    private final MergingUpdateQueue myUpdateQueue;
    private boolean myUpdateInProgress;
    @Nullable
    private Project myProject;
    @Nullable
    private Module myModule;
    protected String myName;
    protected ArrayList<AndroidStudioWizardPath> myPaths;
    protected AndroidStudioWizardPath myCurrentPath;
    protected PathIterator myPathListIterator;
    protected Action myPreviousAction;
    protected Action myNextAction;
    protected Action myFinishAction;
    protected TallImageComponent myIcon;
    private boolean myIsInitialized;
    private Map<Action, JButton> myActionToButtonMap;
    private JPanel myContentPanel;
    private Map<JComponent, String> myComponentToIdMap;
    private ScopedStateStore myState;
    private JPanel myCenterPanel;
    private JPanel mySouthPanel;

    public DynamicWizard(@Nullable Project project, @Nullable Module module, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/wizard/DynamicWizard", "<init>"));
        }
        super(project);
        this.LOG = Logger.getInstance(DynamicWizard.class);
        this.myPaths = Lists.newArrayList();
        this.myPathListIterator = new PathIterator(this.myPaths);
        this.myPreviousAction = new PreviousAction();
        this.myNextAction = new NextAction();
        this.myFinishAction = new FinishAction();
        this.myIsInitialized = false;
        this.myActionToButtonMap = Maps.newHashMapWithExpectedSize((int)5);
        this.myComponentToIdMap = Maps.newHashMap();
        this.myProject = project;
        this.myModule = module;
        this.myName = name;
        this.myUpdateQueue = ApplicationManager.getApplication().isUnitTestMode() ? null : new MergingUpdateQueue("wizard", 100, true, null, this.getDisposable(), null, false);
        this.myState = new ScopedStateStore(ScopedStateStore.Scope.WIZARD, null, this);
        this.myIcon = new TallImageComponent(null);
        Window window = this.getWindow();
        if (window == null) {
            assert (ApplicationManager.getApplication().isUnitTestMode());
        } else {
            window.setPreferredSize(WizardConstants.DEFAULT_WIZARD_WINDOW_SIZE);
        }
    }

    public void init() {
        Container rootPanel;
        super.init();
        Container centerRootPanel = this.myCenterPanel.getParent();
        if (centerRootPanel != null && (rootPanel = centerRootPanel.getParent()) instanceof JPanel) {
            ((JPanel)rootPanel).setBorder(new EmptyBorder(0, 0, 0, 0));
        }
        this.myIsInitialized = true;
        if (this.myCurrentPath != null) {
            this.myCurrentPath.onPathStarted(true);
            this.showStep(this.myCurrentPath.getCurrentStep());
            this.myCurrentPath.updateCurrentStep();
        }
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.myCenterPanel = new JPanel(new BorderLayout());
        this.myContentPanel = new JPanel(new CardLayout());
        this.myCenterPanel.add((Component)this.myContentPanel, "Center");
        this.myCenterPanel.add((Component)((Object)this.myIcon), "West");
        return this.myCenterPanel;
    }

    @Nullable
    protected JComponent createSouthPanel() {
        this.mySouthPanel = (JPanel)super.createSouthPanel();
        assert (this.mySouthPanel != null);
        this.mySouthPanel.setBorder(new EmptyBorder(WizardConstants.STUDIO_WIZARD_INSETS));
        return this.mySouthPanel;
    }

    @Override
    public <T> void invokeUpdate(@Nullable ScopedStateStore.Key<T> changedKey) {
        if (this.myUpdateQueue != null) {
            this.myUpdateQueue.cancelAllUpdates();
            this.myUpdateQueue.queue(new Update("update"){

                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DynamicWizard.this.update();
                        }
                    });
                }
            });
        } else {
            this.update();
        }
    }

    private void update() {
        if (!this.myUpdateInProgress) {
            this.myUpdateInProgress = true;
            this.deriveValues(this.myState.getRecentUpdates());
            this.myState.clearRecentUpdates();
            this.myUpdateInProgress = false;
        }
    }

    public void deriveValues(Set<ScopedStateStore.Key> modified) {
    }

    public abstract void performFinishingActions();

    @Nullable
    protected final Project getProject() {
        return this.myProject;
    }

    @Nullable
    protected final Module getModule() {
        return this.myModule;
    }

    public final void setErrorHtml(String errorMessage) {
        if (this.myCurrentPath != null) {
            this.myCurrentPath.setErrorHtml(errorMessage);
        }
    }

    public final void updateButtons(boolean canGoPrev, boolean canGoNext, boolean canFinishCurrentPath) {
        if (!this.myIsInitialized) {
            return;
        }
        this.getPreviousButton().setEnabled(canGoPrev && this.hasPrevious());
        this.getNextButton().setEnabled(canGoNext && this.hasNext());
        boolean canFinish = canFinishCurrentPath && this.canFinish();
        this.getFinishButton().setEnabled(canFinish);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.getRootPane().setDefaultButton(canFinish ? this.getFinishButton() : this.getNextButton());
        }
    }

    protected final void addPath(@NotNull AndroidStudioWizardPath path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/wizard/DynamicWizard", "addPath"));
        }
        this.myPaths.add(path);
        if (this.myCurrentPath == null && path.isPathVisible()) {
            this.myCurrentPath = path;
        }
        this.myPathListIterator = new PathIterator(this.myPaths);
        path.attachToWizard(this);
    }

    public final int getVisibleStepCount() {
        int sum = 0;
        for (AndroidStudioWizardPath path : this.myPaths) {
            sum += path.getVisibleStepCount();
        }
        return sum;
    }

    @NotNull
    protected final JButton getNextButton() {
        JButton jButton = this.myActionToButtonMap.get(this.myNextAction);
        if (jButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/DynamicWizard", "getNextButton"));
        }
        return jButton;
    }

    @NotNull
    protected final JButton getPreviousButton() {
        JButton jButton = this.myActionToButtonMap.get(this.myPreviousAction);
        if (jButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/DynamicWizard", "getPreviousButton"));
        }
        return jButton;
    }

    @NotNull
    protected final JButton getHelpButton() {
        JButton jButton = this.myActionToButtonMap.get(this.myHelpAction);
        if (jButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/DynamicWizard", "getHelpButton"));
        }
        return jButton;
    }

    @NotNull
    protected final JButton getCancelButton() {
        JButton jButton = this.myActionToButtonMap.get(this.myCancelAction);
        if (jButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/DynamicWizard", "getCancelButton"));
        }
        return jButton;
    }

    @NotNull
    protected final JButton getFinishButton() {
        JButton jButton = this.myActionToButtonMap.get(this.myFinishAction);
        if (jButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/DynamicWizard", "getFinishButton"));
        }
        return jButton;
    }

    protected void showStep(@NotNull Step step) {
        String id;
        if (step == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/wizard/DynamicWizard", "showStep"));
        }
        JComponent component = step.getComponent();
        Icon icon = step.getIcon();
        if (icon != null) {
            this.myIcon.setIcon(icon);
            this.myIcon.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
        }
        if ((id = this.myComponentToIdMap.get(component)) == null) {
            id = String.valueOf(this.myComponentToIdMap.size());
            this.myComponentToIdMap.put(component, id);
            this.myContentPanel.add((Component)component, id);
        }
        ((CardLayout)this.myContentPanel.getLayout()).show(this.myContentPanel, id);
        JComponent focusedComponent = step.getPreferredFocusedComponent();
        if (focusedComponent != null) {
            IdeFocusManager.findInstanceByComponent((Component)focusedComponent).requestFocus((Component)focusedComponent, false);
        }
    }

    protected boolean canGoNext() {
        return this.myCurrentPath != null && this.myCurrentPath.canGoNext();
    }

    protected boolean canGoPrevious() {
        return this.myCurrentPath != null && this.myCurrentPath.canGoPrevious();
    }

    protected boolean hasNext() {
        return this.myCurrentPath != null && this.myCurrentPath.hasNext() || this.myPathListIterator.hasNext();
    }

    protected boolean hasPrevious() {
        return this.myCurrentPath != null && this.myCurrentPath.hasPrevious() || this.myPathListIterator.hasPrevious();
    }

    protected boolean canFinish() {
        if (!(this.myPathListIterator.hasNext() || this.myCurrentPath != null && this.myCurrentPath.hasNext())) {
            return true;
        }
        if (this.myCurrentPath != null && this.myCurrentPath.hasNext()) {
            return false;
        }
        boolean canFinish = true;
        PathIterator remainingPaths = this.myPathListIterator.getFreshCopy();
        while (canFinish && remainingPaths.hasNext()) {
            canFinish = !remainingPaths.next().isPathRequired();
        }
        return canFinish;
    }

    protected final boolean isLastStep() {
        if (this.myCurrentPath != null) {
            return !this.myPathListIterator.hasNext() && !this.myCurrentPath.hasNext();
        }
        return !this.myPathListIterator.hasNext();
    }

    @NotNull
    protected final Action[] createActions() {
        if (this.getHelpId() == null) {
            if (SystemInfo.isMac) {
                Action[] actionArray = new Action[]{this.getCancelAction(), this.myPreviousAction, this.myNextAction, this.myFinishAction};
                if (actionArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/DynamicWizard", "createActions"));
                }
                return actionArray;
            }
            Action[] actionArray = new Action[]{this.myPreviousAction, this.myNextAction, this.getCancelAction(), this.myFinishAction};
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/DynamicWizard", "createActions"));
            }
            return actionArray;
        }
        if (SystemInfo.isMac) {
            Action[] actionArray = new Action[]{this.getHelpAction(), this.getCancelAction(), this.myPreviousAction, this.myNextAction, this.myFinishAction};
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/DynamicWizard", "createActions"));
            }
            return actionArray;
        }
        Action[] actionArray = new Action[]{this.myPreviousAction, this.myNextAction, this.getCancelAction(), this.myFinishAction, this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/DynamicWizard", "createActions"));
        }
        return actionArray;
    }

    protected final JButton createJButtonForAction(Action action) {
        JButton button = super.createJButtonForAction(action);
        this.myActionToButtonMap.put(action, button);
        return button;
    }

    protected void doNextAction() {
        Step newStep;
        assert (this.myCurrentPath != null);
        if (!this.myCurrentPath.canGoNext()) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                DialogEarthquakeShaker.shake((JDialog)((JDialog)this.getPeer().getWindow()));
            }
            return;
        }
        if (!this.myCurrentPath.hasNext() && this.myPathListIterator.hasNext()) {
            this.myCurrentPath = this.myPathListIterator.next();
            this.myCurrentPath.onPathStarted(true);
            newStep = this.myCurrentPath.getCurrentStep();
        } else if (this.myCurrentPath.hasNext()) {
            newStep = this.myCurrentPath.next();
        } else {
            this.doFinishAction();
            return;
        }
        if (newStep != null) {
            this.showStep(newStep);
        }
    }

    protected void doPreviousAction() {
        Step newStep;
        assert (this.myCurrentPath != null);
        if (!this.myCurrentPath.canGoPrevious()) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                DialogEarthquakeShaker.shake((JDialog)((JDialog)this.getPeer().getWindow()));
            }
            return;
        }
        if ((this.myCurrentPath == null || !this.myCurrentPath.hasPrevious()) && this.myPathListIterator.hasPrevious()) {
            this.myCurrentPath = this.myPathListIterator.previous();
            this.myCurrentPath.onPathStarted(false);
            newStep = this.myCurrentPath.getCurrentStep();
        } else if (this.myCurrentPath.hasPrevious()) {
            newStep = this.myCurrentPath.previous();
        } else {
            this.doCancelAction();
            return;
        }
        if (newStep != null) {
            this.showStep(newStep);
        }
    }

    protected void doFinishAction() {
        super.doOKAction();
        new WriteCommandAction<Void>(this.getProject(), this.getWizardActionDescription(), (PsiFile[])null){

            protected void run(@NotNull Result<Void> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/wizard/DynamicWizard$2", "run"));
                }
                for (AndroidStudioWizardPath path : DynamicWizard.this.myPaths) {
                    if (!path.isPathVisible()) continue;
                    path.performFinishingActions();
                }
                DynamicWizard.this.performFinishingActions();
            }

            protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
                return DynamicWizard.this.getUndoConfirmationPolicy();
            }
        }.execute();
    }

    protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
        return UndoConfirmationPolicy.DEFAULT;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        Step currentStep = this.myCurrentPath.getCurrentStep();
        if (currentStep != null) {
            return currentStep.getPreferredFocusedComponent();
        }
        return this.getNextButton();
    }

    protected abstract String getWizardActionDescription();

    protected void doHelpAction() {
    }

    public final ScopedStateStore getState() {
        return this.myState;
    }

    public static class TallImageComponent
    extends OpaquePanel {
        private Icon myIcon;

        public TallImageComponent(Icon icon) {
            this.myIcon = icon;
        }

        protected void paintChildren(Graphics g) {
            if (this.myIcon == null) {
                return;
            }
            this.paintIcon(g);
        }

        public void paintIcon(Graphics g) {
            if (this.myIcon == null) {
                return;
            }
            BufferedImage image = UIUtil.createImage((int)this.myIcon.getIconWidth(), (int)this.myIcon.getIconHeight(), (int)2);
            Graphics2D gg = image.createGraphics();
            this.myIcon.paintIcon((Component)((Object)this), gg, 0, 0);
            Rectangle bounds = g.getClipBounds();
            for (int y = this.myIcon.getIconHeight() - 1; y < bounds.y + bounds.height; ++y) {
                g.drawImage(image, bounds.x, y, bounds.x + bounds.width, y + 1, 0, this.myIcon.getIconHeight() - 1, bounds.width, this.myIcon.getIconHeight(), (ImageObserver)((Object)this));
            }
            g.drawImage(image, 0, 0, (ImageObserver)((Object)this));
        }

        public void setIcon(Icon icon) {
            this.myIcon = icon;
            this.revalidate();
            this.repaint();
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.myIcon != null ? this.myIcon.getIconWidth() : 0, 0);
        }

        public Dimension getMinimumSize() {
            return new Dimension(this.myIcon != null ? this.myIcon.getIconWidth() : 0, 0);
        }
    }

    protected static class PathIterator {
        private int myCurrentIndex;
        private ArrayList<AndroidStudioWizardPath> myList;

        public PathIterator(ArrayList<AndroidStudioWizardPath> list) {
            this.myList = list;
            this.myCurrentIndex = 0;
        }

        public PathIterator getFreshCopy() {
            PathIterator toReturn = new PathIterator(this.myList);
            toReturn.myCurrentIndex = this.myCurrentIndex;
            return toReturn;
        }

        public boolean hasNext() {
            if (this.myCurrentIndex >= this.myList.size() - 1) {
                return false;
            }
            for (int i = this.myCurrentIndex + 1; i < this.myList.size(); ++i) {
                AndroidStudioWizardPath path = this.myList.get(i);
                if (!path.isPathVisible() || path.getVisibleStepCount() <= 0) continue;
                return true;
            }
            return false;
        }

        public boolean hasPrevious() {
            if (this.myCurrentIndex <= 0) {
                return false;
            }
            for (int i = this.myCurrentIndex - 1; i >= 0; --i) {
                if (!this.myList.get(i).isPathVisible()) continue;
                return true;
            }
            return false;
        }

        @Nullable
        public AndroidStudioWizardPath next() {
            do {
                ++this.myCurrentIndex;
            } while (this.myCurrentIndex < this.myList.size() && !this.myList.get(this.myCurrentIndex).isPathVisible());
            if (this.myCurrentIndex < this.myList.size()) {
                return this.myList.get(this.myCurrentIndex);
            }
            return null;
        }

        @Nullable
        public AndroidStudioWizardPath previous() {
            do {
                --this.myCurrentIndex;
            } while (this.myCurrentIndex >= 0 && !this.myList.get(this.myCurrentIndex).isPathVisible());
            if (this.myCurrentIndex >= 0) {
                return this.myList.get(this.myCurrentIndex);
            }
            return null;
        }
    }

    protected class FinishAction
    extends DialogWrapper.DialogWrapperAction {
        protected FinishAction() {
            super((DialogWrapper)DynamicWizard.this, IdeBundle.message((String)"button.finish", (Object[])new Object[0]));
        }

        protected void doAction(ActionEvent e) {
            DynamicWizard.this.doFinishAction();
        }
    }

    protected class PreviousAction
    extends DialogWrapper.DialogWrapperAction {
        protected PreviousAction() {
            super((DialogWrapper)DynamicWizard.this, IdeBundle.message((String)"button.wizard.previous", (Object[])new Object[0]));
        }

        protected void doAction(ActionEvent e) {
            DynamicWizard.this.doPreviousAction();
        }
    }

    protected class NextAction
    extends DialogWrapper.DialogWrapperAction {
        protected NextAction() {
            super((DialogWrapper)DynamicWizard.this, IdeBundle.message((String)"button.wizard.next", (Object[])new Object[0]));
            this.putValue("DefaultAction", Boolean.TRUE);
        }

        protected void doAction(ActionEvent e) {
            DynamicWizard.this.doNextAction();
        }
    }
}

