/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.sdklib.repository.FullRevision;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.JBColor;
import com.intellij.util.ResourceUtil;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DistributionChartComponent
extends JPanel {
    private static final Logger LOG = Logger.getInstance(DistributionChartComponent.class);
    private static final Color TEXT_COLOR = new Color(0xFEFEFE);
    private static final Color API_LEVEL_COLOR = new Color(0, 0, 0, 77);
    private static final int INTER_SECTION_SPACING = 1;
    private static final double MIN_PERCENTAGE_HEIGHT = 0.06;
    private static final double EXPANSION_ON_SELECTION = 1.063882064;
    private static final double RIGHT_GUTTER_PERCENTAGE = 0.209708738;
    private static final int TOP_PADDING = 40;
    private static final int NAME_OFFSET = 50;
    private static final int MIN_API_FONT_SIZE = 18;
    private static final int MAX_API_FONT_SIZE = 45;
    private static final int API_OFFSET = 120;
    private static final int NUMBER_OFFSET = 10;
    private static Font MEDIUM_WEIGHT_FONT;
    private static Font REGULAR_WEIGHT_FONT;
    private static Font VERSION_NAME_FONT;
    private static Font VERSION_NUMBER_FONT;
    private static Font TITLE_FONT;
    private static final Color[] RECT_COLORS;
    private static List<Distribution> ourDistributions;
    private int[] myCurrentBottoms;
    private Distribution mySelectedDistribution;
    private DistributionSelectionChangedListener myListener;

    public void init() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int i;
                int y = mouseEvent.getY();
                for (i = 0; i < DistributionChartComponent.this.myCurrentBottoms.length && y > DistributionChartComponent.this.myCurrentBottoms[i]; ++i) {
                }
                if (i < DistributionChartComponent.this.myCurrentBottoms.length) {
                    DistributionChartComponent.this.mySelectedDistribution = (Distribution)ourDistributions.get(i);
                    if (DistributionChartComponent.this.myListener != null) {
                        DistributionChartComponent.this.myListener.onDistributionSelected(DistributionChartComponent.this.mySelectedDistribution);
                    }
                    DistributionChartComponent.this.repaint();
                }
            }
        });
        if (ourDistributions == null) {
            try {
                String jsonString = ResourceUtil.loadText((URL)ResourceUtil.getResource(this.getClass(), (String)"wizardData", (String)"distributions.json"));
                ourDistributions = DistributionChartComponent.loadDistributionsFromJson(jsonString);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        DistributionChartComponent.loadFonts();
    }

    private static void loadFonts() {
        if (MEDIUM_WEIGHT_FONT == null) {
            REGULAR_WEIGHT_FONT = new Font("Sans", 0, 12);
            MEDIUM_WEIGHT_FONT = new Font("Sans", 1, 12);
            VERSION_NAME_FONT = REGULAR_WEIGHT_FONT.deriveFont(16.0f);
            VERSION_NUMBER_FONT = REGULAR_WEIGHT_FONT.deriveFont(20.0f);
            TITLE_FONT = MEDIUM_WEIGHT_FONT.deriveFont(16.0f);
        }
    }

    @Nullable
    private static List<Distribution> loadDistributionsFromJson(String jsonString) {
        Type fullRevisionType = new TypeToken<FullRevision>(){}.getType();
        GsonBuilder gsonBuilder = new GsonBuilder().registerTypeAdapter(fullRevisionType, (Object)new JsonDeserializer<FullRevision>(){

            public FullRevision deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return FullRevision.parseRevision((String)json.getAsString());
            }
        });
        Gson gson = gsonBuilder.create();
        Type listType = new TypeToken<ArrayList<Distribution>>(){}.getType();
        try {
            return (List)gson.fromJson(jsonString, listType);
        }
        catch (JsonParseException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public void registerDistributionSelectionChangedListener(@NotNull DistributionSelectionChangedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/wizard/DistributionChartComponent", "registerDistributionSelectionChangedListener"));
        }
        this.myListener = listener;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(300, 300);
    }

    @Override
    public void paintComponent(Graphics g) {
        GraphicsUtil.setupAntialiasing((Graphics)g);
        GraphicsUtil.setupAAPainting((Graphics)g);
        super.paintComponent(g);
        if (this.myCurrentBottoms == null) {
            this.myCurrentBottoms = new int[ourDistributions.size()];
        }
        int startY = 40;
        int totalWidth = this.getBounds().width;
        int rightGutter = (int)Math.round((double)totalWidth * 0.209708738);
        int width = totalWidth - rightGutter;
        int normalBoxSize = (int)Math.round((double)width / 1.063882064);
        int leftGutter = (width - normalBoxSize) / 2;
        FontMetrics titleMetrics = g.getFontMetrics(TITLE_FONT);
        int titleHeight = titleMetrics.getHeight();
        FontMetrics versionNumberMetrics = g.getFontMetrics(VERSION_NUMBER_FONT);
        int halfVersionNumberHeight = (versionNumberMetrics.getHeight() - versionNumberMetrics.getDescent()) / 2;
        FontMetrics versionNameMetrics = g.getFontMetrics(VERSION_NAME_FONT);
        int halfVersionNameHeight = (versionNameMetrics.getHeight() - versionNameMetrics.getDescent()) / 2;
        g.setFont(TITLE_FONT);
        g.drawString("API Level".toUpperCase(), leftGutter, titleHeight);
        String distributionTitle = "Distribution".toUpperCase();
        String accumulativeTitle = "Cumulative".toUpperCase();
        g.drawString(accumulativeTitle, totalWidth - titleMetrics.stringWidth(accumulativeTitle), titleHeight);
        g.drawString(distributionTitle, totalWidth - titleMetrics.stringWidth(distributionTitle), titleHeight * 2);
        int heightToDistribute = this.getBounds().height - 1 * (ourDistributions.size() - 1) - 40;
        double percentageSum = 0.0;
        int smallItemCount = 0;
        for (Distribution d : ourDistributions) {
            if (!(d.distributionPercentage < 0.06)) continue;
            ++smallItemCount;
        }
        heightToDistribute -= (int)Math.round((double)smallItemCount * 0.06 * (double)heightToDistribute);
        int i = 0;
        for (Distribution d : ourDistributions) {
            if (d.color == null) {
                d.color = RECT_COLORS[i % RECT_COLORS.length];
            }
            g.setColor(d.color);
            double effectivePercentage = Math.max(d.distributionPercentage, 0.06);
            int calculatedHeight = (int)Math.round(effectivePercentage * (double)heightToDistribute);
            int bottom = startY + calculatedHeight;
            if (d.equals(this.mySelectedDistribution)) {
                g.fillRect(0, bottom - calculatedHeight, width, calculatedHeight);
            } else {
                g.fillRect(leftGutter, bottom - calculatedHeight, normalBoxSize, calculatedHeight);
            }
            Font apiLevelFont = REGULAR_WEIGHT_FONT.deriveFont(DistributionChartComponent.logistic(effectivePercentage, 18, 45));
            FontMetrics apiLevelMetrics = g.getFontMetrics(apiLevelFont);
            int halfApiFontHeight = (apiLevelMetrics.getHeight() - apiLevelMetrics.getDescent()) / 2;
            int currentMidY = startY + calculatedHeight / 2;
            g.setColor(TEXT_COLOR);
            g.setFont(VERSION_NAME_FONT);
            this.myCurrentBottoms[i] = bottom;
            g.drawString(d.name, leftGutter + 50, currentMidY + halfVersionNameHeight);
            g.setColor(API_LEVEL_COLOR);
            g.setFont(VERSION_NUMBER_FONT);
            String versionString = d.version.toString().substring(0, 3);
            g.drawString(versionString, leftGutter + 10, currentMidY + halfVersionNumberHeight);
            g.setFont(apiLevelFont);
            g.drawString(Integer.toString(d.apiLevel), width - 120, currentMidY + halfApiFontHeight);
            percentageSum += d.distributionPercentage;
            if (i < ourDistributions.size() - 1) {
                g.setColor(JBColor.foreground());
                g.setFont(VERSION_NUMBER_FONT);
                String percentageString = new DecimalFormat("0.0%").format(0.999 - percentageSum);
                int percentStringWidth = versionNumberMetrics.stringWidth(percentageString);
                g.drawString(percentageString, totalWidth - percentStringWidth - 2, bottom - 2);
                g.setColor((Color)JBColor.darkGray);
                g.drawLine(leftGutter + normalBoxSize, startY + calculatedHeight, totalWidth, startY + calculatedHeight);
            }
            startY += calculatedHeight + 1;
            ++i;
        }
    }

    private static float logistic(double normalizedValue, int min, int max) {
        double t = normalizedValue * 1.0;
        double result = (double)(max * min) * Math.exp((double)min * t) / ((double)max + (double)min * Math.exp((double)min * t));
        return (float)result;
    }

    public double getSupportedDistributionForApiLevel(int apiLevel) {
        double unsupportedSum = 0.0;
        for (Distribution d : ourDistributions) {
            if (d.apiLevel >= apiLevel) break;
            unsupportedSum += d.distributionPercentage;
        }
        return 1.0 - unsupportedSum;
    }

    static {
        RECT_COLORS = new Color[]{new Color(13361099), new Color(8242833), new Color(9614007), new Color(14596672), new Color(15031647), new Color(7258322), new Color(14191971), new Color(0xFF9229), new Color(15383853)};
    }

    public static interface DistributionSelectionChangedListener {
        public void onDistributionSelected(Distribution var1);
    }

    protected static class Distribution
    implements Comparable<Distribution> {
        public int apiLevel;
        public FullRevision version;
        public double distributionPercentage;
        public String name;
        public Color color;
        public String description;
        public String url;
        public List<TextBlock> descriptionBlocks;

        private Distribution() {
        }

        @Override
        public int compareTo(Distribution other) {
            return Integer.valueOf(this.apiLevel).compareTo(other.apiLevel);
        }

        public static class TextBlock {
            public String title;
            public String body;
        }
    }
}

