/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.tools.idea.sdk.VersionCheck;
import com.android.tools.idea.sdk.wizard.LicenseAgreementStep;
import com.android.tools.idea.sdk.wizard.SmwOldApiDirectInstall;
import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.wizard.ConfigureAndroidProjectStep;
import com.android.tools.idea.wizard.ConfigureFormFactorStep;
import com.android.tools.idea.wizard.DynamicWizardPath;
import com.android.tools.idea.wizard.ImageComponent;
import com.android.tools.idea.wizard.WizardConstants;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import icons.AndroidIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;

public class ConfigureAndroidProjectPath
extends DynamicWizardPath {
    private static final Logger LOG = Logger.getInstance(ConfigureAndroidProjectPath.class);
    @NotNull
    private final Disposable myParentDisposable;

    public ConfigureAndroidProjectPath(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/wizard/ConfigureAndroidProjectPath", "<init>"));
        }
        this.myParentDisposable = parentDisposable;
    }

    @Override
    protected void init() {
        this.putSdkDependentParams();
        this.addStep(new ConfigureAndroidProjectStep(this.myParentDisposable));
        this.addStep(new ConfigureFormFactorStep(this.myParentDisposable));
        this.addStep(new LicenseAgreementStep(this.myParentDisposable));
        this.addStep(new SmwOldApiDirectInstall(this.myParentDisposable));
    }

    @Override
    public boolean validate() {
        if (!AndroidSdkUtils.isAndroidSdkAvailable() || !TemplateManager.templatesAreValid()) {
            this.setErrorHtml("<html>Your Android SDK is missing, out of date, or is missing templates. Please ensure you are using SDK version " + VersionCheck.MIN_TOOLS_REV + " or later.<br>" + "You can configure your SDK via <b>Configure | Project Defaults | Project Structure | SDKs</b></html>");
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public String getPathName() {
        if ("Configure Android Project" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ConfigureAndroidProjectPath", "getPathName"));
        }
        return "Configure Android Project";
    }

    public void putSdkDependentParams() {
        AndroidSdkData sdkData = AndroidSdkUtils.tryToChooseAndroidSdk();
        BuildToolInfo buildTool = sdkData != null ? sdkData.getLatestBuildTool() : null;
        FullRevision minimumRequiredBuildToolVersion = FullRevision.parseRevision((String)"19.1.0");
        if (buildTool != null && buildTool.getRevision().compareTo(minimumRequiredBuildToolVersion) >= 0) {
            this.myState.put(WizardConstants.BUILD_TOOLS_VERSION_KEY, buildTool.getRevision().toString());
        } else {
            this.myState.listPush(WizardConstants.INSTALL_REQUESTS_KEY, PkgDesc.Builder.newBuildTool((FullRevision)minimumRequiredBuildToolVersion).create());
            this.myState.put(WizardConstants.BUILD_TOOLS_VERSION_KEY, minimumRequiredBuildToolVersion.toString());
        }
        if (sdkData != null) {
            this.myState.put(WizardConstants.SDK_HOME_KEY, FileUtil.toSystemIndependentName((String)sdkData.getPath()));
        }
    }

    @Override
    public boolean performFinishingActions() {
        String projectLocation = this.myState.get(WizardConstants.PROJECT_LOCATION_KEY);
        if (projectLocation != null) {
            try {
                VirtualFile vf = VfsUtil.createDirectories((String)projectLocation);
                File projectRoot = VfsUtilCore.virtualToIoFile((VirtualFile)vf);
                Template projectTemplate = Template.createFromName("gradle-projects", "NewAndroidProject");
                projectTemplate.render(projectRoot, projectRoot, this.myState.flatten());
                try {
                    ConfigureAndroidProjectPath.setGradleWrapperExecutable(projectRoot);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                    return false;
                }
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    protected static JPanel buildConfigurationHeader() {
        JPanel panel = new JPanel();
        panel.setBackground((Color)WizardConstants.ANDROID_NPW_HEADER_COLOR);
        panel.setBorder(BorderFactory.createLineBorder(Color.RED));
        panel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(18, 0, 12, 0), 2, 2));
        GridConstraints c = new GridConstraints(0, 0, 2, 1, 9, 0, 0, 0, null, new Dimension(60, 60), null);
        ImageComponent image = new ImageComponent(AndroidIcons.Wizards.NewProjectMascotGreen);
        panel.add((Component)((Object)image), c);
        c = new GridConstraints(0, 1, 1, 1, 10, 1, 6, 0, null, null, null);
        JLabel projectLabel = new JLabel("New Project");
        projectLabel.setForeground(Color.WHITE);
        projectLabel.setFont(projectLabel.getFont().deriveFont(24.0f));
        panel.add((Component)projectLabel, c);
        c.setRow(1);
        c.setAnchor(9);
        JLabel productLabel = new JLabel("Android Studio");
        productLabel.setForeground(Color.WHITE);
        panel.add((Component)productLabel, c);
        return panel;
    }

    public static void setGradleWrapperExecutable(File projectRoot) throws IOException {
        if (SystemInfo.isUnix) {
            File gradlewFile = new File(projectRoot, "gradlew");
            if (!gradlewFile.isFile()) {
                LOG.error("Could not find gradle wrapper. Command line builds may not work properly.");
            } else {
                FileUtil.setExecutableAttribute((String)gradlewFile.getPath(), (boolean)true);
            }
        }
    }
}

