/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.assetstudiolib.ActionBarIconGenerator;
import com.android.assetstudiolib.GraphicGenerator;
import com.android.assetstudiolib.GraphicGeneratorContext;
import com.android.assetstudiolib.LauncherIconGenerator;
import com.android.assetstudiolib.NotificationIconGenerator;
import com.android.assetstudiolib.TextRenderUtil;
import com.android.assetstudiolib.Util;
import com.android.tools.idea.rendering.ImageUtils;
import com.android.tools.idea.wizard.TemplateWizardContextAdapter;
import com.android.tools.idea.wizard.TemplateWizardState;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssetStudioAssetGenerator
implements GraphicGeneratorContext {
    public static final String ATTR_TEXT = "text";
    public static final String ATTR_SCALING = "scaling";
    public static final String ATTR_SHAPE = "shape";
    public static final String ATTR_PADDING = "padding";
    public static final String ATTR_TRIM = "trim";
    public static final String ATTR_FONT = "font";
    public static final String ATTR_FONT_SIZE = "fontSize";
    public static final String ATTR_SOURCE_TYPE = "sourceType";
    public static final String ATTR_IMAGE_PATH = "imagePath";
    public static final String ATTR_CLIPART_NAME = "clipartPath";
    public static final String ATTR_FOREGROUND_COLOR = "foregroundColor";
    public static final String ATTR_BACKGROUND_COLOR = "backgroundColor";
    public static final String ATTR_ASSET_TYPE = "assetType";
    public static final String ATTR_ASSET_THEME = "assetTheme";
    public static final String ATTR_ASSET_NAME = "assetName";
    private static final Logger LOG = Logger.getInstance((String)("#" + AssetStudioAssetGenerator.class.getName()));
    private static final String OUTPUT_DIRECTORY = "src/main/";
    private static Cache<String, BufferedImage> ourImageCache = CacheBuilder.newBuilder().build();
    private final ActionBarIconGenerator myActionBarIconGenerator;
    private final NotificationIconGenerator myNotificationIconGenerator;
    private final LauncherIconGenerator myLauncherIconGenerator;
    private AssetStudioContext myContext;

    public AssetStudioAssetGenerator(AssetStudioContext context) {
        this(context, new ActionBarIconGenerator(), new NotificationIconGenerator(), new LauncherIconGenerator());
    }

    public AssetStudioAssetGenerator(TemplateWizardState state) {
        this(new TemplateWizardContextAdapter(state), new ActionBarIconGenerator(), new NotificationIconGenerator(), new LauncherIconGenerator());
    }

    public AssetStudioAssetGenerator(@NotNull AssetStudioContext context, @Nullable ActionBarIconGenerator actionBarIconGenerator, @Nullable NotificationIconGenerator notificationIconGenerator, @Nullable LauncherIconGenerator launcherIconGenerator) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/wizard/AssetStudioAssetGenerator", "<init>"));
        }
        this.myContext = context;
        this.myActionBarIconGenerator = actionBarIconGenerator != null ? actionBarIconGenerator : new ActionBarIconGenerator();
        this.myNotificationIconGenerator = notificationIconGenerator != null ? notificationIconGenerator : new NotificationIconGenerator();
        this.myLauncherIconGenerator = launcherIconGenerator != null ? launcherIconGenerator : new LauncherIconGenerator();
        this.myContext.setText("Aa");
        this.myContext.setFont("Arial Black");
        this.myContext.setScaling(Scaling.CROP);
        this.myContext.setShape(GraphicGenerator.Shape.NONE);
        this.myContext.setFontSize(144);
        this.myContext.setSourceType(SourceType.IMAGE);
        this.myContext.setClipartName("android.png");
        this.myContext.setForegroundColor(Color.BLUE);
        this.myContext.setBackgroundColor(Color.WHITE);
        this.myContext.setTrim(false);
        this.myContext.setPadding(0);
    }

    @Nullable
    public BufferedImage loadImageResource(final @NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/wizard/AssetStudioAssetGenerator", "loadImageResource"));
        }
        try {
            return (BufferedImage)ourImageCache.get((Object)path, (Callable)new Callable<BufferedImage>(){

                @Override
                public BufferedImage call() throws Exception {
                    return AssetStudioAssetGenerator.getImage(path, true);
                }
            });
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @NotNull
    public Map<String, Map<String, BufferedImage>> generateImages(boolean previewOnly) throws ImageGeneratorException {
        LinkedHashMap<String, Map<String, BufferedImage>> categoryMap = new LinkedHashMap<String, Map<String, BufferedImage>>();
        this.generateImages(categoryMap, false, previewOnly);
        LinkedHashMap<String, Map<String, BufferedImage>> linkedHashMap = categoryMap;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/AssetStudioAssetGenerator", "generateImages"));
        }
        return linkedHashMap;
    }

    public void generateImages(Map<String, Map<String, BufferedImage>> categoryMap, boolean clearMap, boolean previewOnly) throws ImageGeneratorException {
        AssetType type;
        if (clearMap) {
            categoryMap.clear();
        }
        if ((type = this.myContext.getAssetType()) == null) {
            return;
        }
        boolean trim = this.myContext.isTrim();
        int padding = this.myContext.getPadding();
        SourceType sourceType = this.myContext.getSourceType();
        if (sourceType == null) {
            return;
        }
        BufferedImage sourceImage = null;
        switch (sourceType) {
            case IMAGE: {
                String path = this.myContext.getImagePath();
                if (path == null || path.isEmpty()) {
                    throw new ImageGeneratorException("Path to image is empty.");
                }
                try {
                    sourceImage = AssetStudioAssetGenerator.getImage(path, false);
                    break;
                }
                catch (FileNotFoundException e) {
                    throw new ImageGeneratorException("Image file not found: " + path);
                }
                catch (IOException e) {
                    throw new ImageGeneratorException("Unable to load image file: " + path);
                }
            }
            case CLIPART: {
                String clipartName = this.myContext.getClipartName();
                try {
                    sourceImage = GraphicGenerator.getClipartImage((String)clipartName);
                }
                catch (IOException e) {
                    throw new ImageGeneratorException("Unable to load clip art image: " + clipartName);
                }
                if (!type.needsColors()) break;
                Color paint = this.myContext.getForegroundColor();
                sourceImage = Util.filledImage((BufferedImage)sourceImage, (Paint)paint);
                break;
            }
            case TEXT: {
                TextRenderUtil.Options options = new TextRenderUtil.Options();
                options.font = Font.decode(this.myContext.getFont() + " " + this.myContext.getFontSize());
                options.foregroundColor = type.needsColors() ? this.myContext.getForegroundColor().getRGB() : -1;
                sourceImage = TextRenderUtil.renderTextImage((String)this.myContext.getText(), (int)1, (TextRenderUtil.Options)options);
                break;
            }
        }
        if (trim) {
            sourceImage = AssetStudioAssetGenerator.crop(sourceImage);
        }
        if (padding != 0) {
            sourceImage = Util.paddedImage((BufferedImage)sourceImage, (int)padding);
        }
        LauncherIconGenerator generator = null;
        NotificationIconGenerator.NotificationOptions options = null;
        String baseName = Strings.nullToEmpty((String)this.myContext.getAssetName());
        switch (type) {
            case LAUNCHER: {
                generator = this.myLauncherIconGenerator;
                LauncherIconGenerator.LauncherOptions launcherOptions = new LauncherIconGenerator.LauncherOptions();
                launcherOptions.shape = this.myContext.getShape();
                launcherOptions.crop = Scaling.CROP.equals((Object)this.myContext.getScaling());
                launcherOptions.style = GraphicGenerator.Style.SIMPLE;
                launcherOptions.backgroundColor = this.myContext.getBackgroundColor().getRGB();
                launcherOptions.isWebGraphic = !previewOnly;
                options = launcherOptions;
                break;
            }
            case ACTIONBAR: {
                ActionBarIconGenerator.Theme theme;
                generator = this.myActionBarIconGenerator;
                ActionBarIconGenerator.ActionBarOptions actionBarOptions = new ActionBarIconGenerator.ActionBarOptions();
                String themeName = this.myContext.getAssetTheme();
                if (!StringUtil.isEmpty((String)themeName) && (theme = ActionBarIconGenerator.Theme.valueOf((String)themeName)) != null) {
                    switch (theme) {
                        case HOLO_DARK: {
                            actionBarOptions.theme = ActionBarIconGenerator.Theme.HOLO_DARK;
                            break;
                        }
                        case HOLO_LIGHT: {
                            actionBarOptions.theme = ActionBarIconGenerator.Theme.HOLO_LIGHT;
                            break;
                        }
                        case CUSTOM: {
                            actionBarOptions.theme = ActionBarIconGenerator.Theme.CUSTOM;
                            actionBarOptions.customThemeColor = this.myContext.getForegroundColor().getRGB();
                        }
                    }
                }
                actionBarOptions.sourceIsClipart = sourceType == SourceType.CLIPART;
                options = actionBarOptions;
                break;
            }
            case NOTIFICATION: {
                generator = this.myNotificationIconGenerator;
                NotificationIconGenerator.NotificationOptions notificationOptions = new NotificationIconGenerator.NotificationOptions();
                notificationOptions.version = NotificationIconGenerator.Version.V11;
                options = notificationOptions;
            }
        }
        options.sourceImage = sourceImage;
        generator.generate(null, categoryMap, (GraphicGeneratorContext)this, options, baseName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputImagesIntoVariantRoot(@NotNull File variantDir) {
        if (variantDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/wizard/AssetStudioAssetGenerator", "outputImagesIntoVariantRoot"));
        }
        try {
            Map<String, Map<String, BufferedImage>> images = this.generateImages(false);
            for (Map<String, BufferedImage> density : images.values()) {
                for (Map.Entry<String, BufferedImage> image : density.entrySet()) {
                    File file = new File(variantDir, image.getKey());
                    try {
                        VirtualFile directory = VfsUtil.createDirectories((String)file.getParentFile().getAbsolutePath());
                        VirtualFile imageFile = directory.findChild(file.getName());
                        if (imageFile == null || !imageFile.exists()) {
                            imageFile = directory.createChildData((Object)this, file.getName());
                        }
                        OutputStream outputStream = imageFile.getOutputStream((Object)this);
                        try {
                            ImageIO.write((RenderedImage)image.getValue(), "PNG", outputStream);
                        }
                        finally {
                            outputStream.close();
                        }
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    public void outputImagesIntoDefaultVariant(@NotNull File contentRoot) {
        if (contentRoot == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/wizard/AssetStudioAssetGenerator", "outputImagesIntoDefaultVariant"));
        }
        File directory = new File(contentRoot, OUTPUT_DIRECTORY);
        this.outputImagesIntoVariantRoot(directory);
    }

    @NotNull
    protected static BufferedImage getImage(@NotNull String path, boolean isPluginRelative) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/wizard/AssetStudioAssetGenerator", "getImage"));
        }
        BufferedImage image = isPluginRelative ? GraphicGenerator.getStencilImage((String)path) : ImageIO.read(new File(path));
        if (image == null) {
            image = new BufferedImage(1, 1, 2);
        }
        BufferedImage bufferedImage = image;
        if (bufferedImage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/AssetStudioAssetGenerator", "getImage"));
        }
        return bufferedImage;
    }

    @NotNull
    protected static BufferedImage crop(@NotNull BufferedImage sourceImage) {
        if (sourceImage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/wizard/AssetStudioAssetGenerator", "crop"));
        }
        BufferedImage cropped = ImageUtils.cropBlank(sourceImage, null, 2);
        BufferedImage bufferedImage = cropped != null ? cropped : sourceImage;
        if (bufferedImage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/AssetStudioAssetGenerator", "crop"));
        }
        return bufferedImage;
    }

    public static enum AssetType {
        LAUNCHER("Launcher Icons", "ic_launcher"),
        ACTIONBAR("Action Bar and Tab Icons", "ic_action_%s"),
        NOTIFICATION("Notification Icons", "ic_stat_%s");

        private final String myDisplayName;
        private String myDefaultNameFormat;

        private AssetType(String displayName, String defaultNameFormat) {
            this.myDisplayName = displayName;
            this.myDefaultNameFormat = defaultNameFormat;
        }

        public String getDisplayName() {
            return this.myDisplayName;
        }

        public String toString() {
            return this.getDisplayName();
        }

        public String getDefaultNameFormat() {
            return this.myDefaultNameFormat;
        }

        public boolean needsForegroundScaling() {
            return this == LAUNCHER;
        }

        public boolean needsShape() {
            return this == LAUNCHER;
        }

        public boolean needsColors() {
            return this == LAUNCHER;
        }

        public boolean needsEffects() {
            return this == LAUNCHER;
        }

        public boolean needsTheme() {
            return this == ACTIONBAR;
        }
    }

    public static enum Scaling {
        CENTER,
        CROP;

    }

    public static enum SourceType {
        IMAGE,
        CLIPART,
        TEXT;

    }

    public static class ImageGeneratorException
    extends Exception {
        public ImageGeneratorException(String message) {
            super(message);
        }
    }

    public static interface AssetStudioContext {
        public int getPadding();

        public void setPadding(int var1);

        @Nullable
        public SourceType getSourceType();

        public void setSourceType(SourceType var1);

        @Nullable
        public AssetType getAssetType();

        public boolean isTrim();

        public void setTrim(boolean var1);

        @Nullable
        public String getImagePath();

        @Nullable
        public String getText();

        public void setText(String var1);

        @Nullable
        public String getClipartName();

        public void setClipartName(String var1);

        public Color getForegroundColor();

        public void setForegroundColor(Color var1);

        @Nullable
        public String getFont();

        public void setFont(String var1);

        public int getFontSize();

        public void setFontSize(int var1);

        public Scaling getScaling();

        public void setScaling(Scaling var1);

        @Nullable
        public String getAssetName();

        public GraphicGenerator.Shape getShape();

        public void setShape(GraphicGenerator.Shape var1);

        public Color getBackgroundColor();

        public void setBackgroundColor(Color var1);

        @Nullable
        public String getAssetTheme();
    }
}

