/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.wizard;

import com.android.annotations.NonNull;
import com.android.sdklib.internal.repository.IListDescription;
import com.android.sdklib.repository.local.LocalPkgInfo;
import com.android.sdklib.repository.remote.RemotePkgInfo;
import com.android.tools.idea.sdk.wizard.SmwSelectionAction;
import com.android.utils.Pair;
import com.intellij.openapi.Disposable;
import com.intellij.ui.BooleanTableCellEditor;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.util.ui.ColumnInfo;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.Nullable;

public class SmwConfirmationTableModel
extends AbstractTableModel
implements Disposable {
    private boolean myIsDisposed;
    private final ColumnInfo[] myColumns;
    private final List<LineInfo> myLines = new ArrayList<LineInfo>();

    public SmwConfirmationTableModel(ColumnInfo ... columns) {
        this.myColumns = columns;
    }

    @Override
    public int getRowCount() {
        return this.myLines.size();
    }

    @Override
    public int getColumnCount() {
        return this.myColumns.length;
    }

    @NonNull
    public ColumnInfo getColumnInfo(int columnIndex) {
        return this.myColumns[columnIndex];
    }

    @NonNull
    public LineInfo getObjectAt(int rowIndex) {
        return this.myLines.get(rowIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.myColumns[columnIndex].valueOf((Object)this.myLines.get(rowIndex));
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.myColumns[columnIndex].isCellEditable((Object)this.myLines.get(rowIndex));
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.myColumns[columnIndex].setValue((Object)this.myLines.get(rowIndex), aValue);
        for (int i = 0; i < this.myColumns.length; ++i) {
            this.fireTableCellUpdated(rowIndex, i);
        }
    }

    public void fillModel(List<Pair<SmwSelectionAction, IListDescription>> selectedActions) {
        this.myLines.clear();
        boolean needHeader = true;
        for (Pair<SmwSelectionAction, IListDescription> action : selectedActions) {
            if (action.getFirst() != SmwSelectionAction.UPDATE && action.getFirst() != SmwSelectionAction.INSTALL) continue;
            if (needHeader) {
                this.myLines.add(new LineInfo("===[ Packages to install/update ]===="));
                needHeader = false;
            }
            if (action.getFirst() == SmwSelectionAction.UPDATE) {
                this.myLines.add(new LineInfo((LocalPkgInfo)action.getSecond(), LineType.UPDATE));
                continue;
            }
            this.myLines.add(new LineInfo((RemotePkgInfo)action.getSecond()));
        }
        needHeader = true;
        for (Pair<SmwSelectionAction, IListDescription> action : selectedActions) {
            if (action.getFirst() != SmwSelectionAction.REMOVE) continue;
            if (needHeader) {
                this.myLines.add(new LineInfo("===[ Packages to remove ]===="));
                needHeader = false;
            }
            this.myLines.add(new LineInfo((LocalPkgInfo)action.getSecond(), LineType.REMOVE));
        }
        this.fireTableDataChanged();
    }

    public void fillModel(@NonNull List<LocalPkgInfo> removeList, @NonNull List<RemotePkgInfo> installList) {
        this.myLines.clear();
        this.fireTableDataChanged();
    }

    public void dispose() {
        this.myIsDisposed = true;
    }

    public static class InstallColumnInfo
    extends ColumnInfo<LineInfo, Boolean> {
        public InstallColumnInfo(@NonNull String name) {
            super(name);
        }

        public Boolean valueOf(LineInfo item) {
            return item.myAccept;
        }

        public boolean isCellEditable(LineInfo item) {
            return item.myType != LineType.HEADER;
        }

        public Class getColumnClass() {
            return Boolean.class;
        }

        public TableCellEditor getEditor(LineInfo item) {
            return new BooleanTableCellEditor();
        }

        @Nullable
        public TableCellRenderer getRenderer(LineInfo o) {
            return new BooleanTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    return super.getTableCellRendererComponent(table, value == null ? Boolean.TRUE : value, isSelected, hasFocus, row, column);
                }
            };
        }

        public int getWidth(JTable table) {
            return new JCheckBox().getPreferredSize().width;
        }

        public void setValue(LineInfo item, Boolean value) {
            item.myAccept = value;
            super.setValue((Object)item, (Object)value);
        }
    }

    public static class LabelColumnInfo
    extends ColumnInfo<LineInfo, String> {
        private SmwConfirmationTableModel myModel;

        public LabelColumnInfo(@NonNull String name) {
            super(name);
        }

        public void setModel(@NonNull SmwConfirmationTableModel model) {
            this.myModel = model;
        }

        public String valueOf(LineInfo item) {
            switch (item.myType) {
                case HEADER: {
                    return item.myHeader;
                }
                case REMOVE: {
                    return "Remove " + item.myRemovedPkg.getListDescription();
                }
                case INSTALL: {
                    return "New " + item.myInstallNewPkg.getListDescription();
                }
                case UPDATE: {
                    assert (item.myUpdatePkg.getUpdate() != null);
                    return "Update to " + item.myUpdatePkg.getUpdate().getListDescription();
                }
            }
            return "";
        }

        public boolean isCellEditable(LineInfo item) {
            return false;
        }

        @Nullable
        public TableCellRenderer getRenderer(LineInfo item) {
            return new DefaultTableCellRenderer();
        }
    }

    static class LineInfo {
        private LineType myType;
        private String myHeader;
        private LocalPkgInfo myRemovedPkg;
        private LocalPkgInfo myUpdatePkg;
        private RemotePkgInfo myInstallNewPkg;
        private boolean myAccept;

        public LineInfo(@NonNull String header) {
            this.myType = LineType.HEADER;
            this.myHeader = header;
        }

        public LineInfo(@NonNull LocalPkgInfo info, LineType type) {
            assert (type == LineType.REMOVE || type == LineType.UPDATE);
            this.myType = type;
            if (type == LineType.REMOVE) {
                this.myRemovedPkg = info;
            } else if (type == LineType.UPDATE) {
                this.myUpdatePkg = info;
            }
        }

        public LineInfo(@NonNull RemotePkgInfo info) {
            this.myType = LineType.INSTALL;
            this.myInstallNewPkg = info;
        }

        @NonNull
        public LineType getType() {
            return this.myType;
        }

        @Nullable
        public LocalPkgInfo getRemovedPkg() {
            return this.myRemovedPkg;
        }

        @Nullable
        public LocalPkgInfo getUpdatePkg() {
            return this.myUpdatePkg;
        }

        @Nullable
        public RemotePkgInfo getInstallNewPkg() {
            return this.myInstallNewPkg;
        }
    }

    static enum LineType {
        HEADER,
        REMOVE,
        UPDATE,
        INSTALL;

    }
}

