/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.ddms.DevicePropertyUtil;
import com.google.common.base.Objects;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThreeState;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaunchCompatibility {
    private final ThreeState myCompatible;
    private final String myReason;
    private static final LaunchCompatibility YES = new LaunchCompatibility(ThreeState.YES, null);

    public LaunchCompatibility(ThreeState compatible, @Nullable String reason) {
        this.myCompatible = compatible;
        this.myReason = reason;
    }

    public ThreeState isCompatible() {
        return this.myCompatible;
    }

    @Nullable
    public String getReason() {
        return this.myReason;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("compatible", (Object)this.myCompatible).add("reason", (Object)this.myReason).toString();
    }

    public boolean equals(Object o) {
        return o instanceof LaunchCompatibility && this.myCompatible == ((LaunchCompatibility)o).myCompatible && Objects.equal((Object)this.myReason, (Object)((LaunchCompatibility)o).myReason);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.myCompatible, this.myReason});
    }

    @NotNull
    public static LaunchCompatibility canRunOnDevice(@NotNull AndroidVersion minSdkVersion, @NotNull IAndroidTarget projectTarget, @NotNull EnumSet<IDevice.HardwareFeature> requiredFeatures, @NotNull IDevice device, @Nullable IAndroidTarget avdTarget) {
        if (minSdkVersion == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/run/LaunchCompatibility", "canRunOnDevice"));
        }
        if (projectTarget == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/run/LaunchCompatibility", "canRunOnDevice"));
        }
        if (requiredFeatures == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/run/LaunchCompatibility", "canRunOnDevice"));
        }
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/android/tools/idea/run/LaunchCompatibility", "canRunOnDevice"));
        }
        AndroidVersion deviceVersion = DevicePropertyUtil.getDeviceVersion(device);
        if (!deviceVersion.canRun(minSdkVersion)) {
            String reason = String.format("minSdk(%1$s) %3$s deviceSdk(%2$s)", minSdkVersion, deviceVersion, minSdkVersion.getCodename() == null ? ">" : "!=");
            LaunchCompatibility launchCompatibility = new LaunchCompatibility(ThreeState.NO, reason);
            if (launchCompatibility == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/LaunchCompatibility", "canRunOnDevice"));
            }
            return launchCompatibility;
        }
        for (IDevice.HardwareFeature feature : requiredFeatures) {
            if (device.supportsFeature(feature)) continue;
            LaunchCompatibility launchCompatibility = new LaunchCompatibility(ThreeState.NO, "missing feature: " + feature);
            if (launchCompatibility == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/LaunchCompatibility", "canRunOnDevice"));
            }
            return launchCompatibility;
        }
        if (device.supportsFeature(IDevice.HardwareFeature.WATCH) && !requiredFeatures.contains(IDevice.HardwareFeature.WATCH)) {
            LaunchCompatibility launchCompatibility = new LaunchCompatibility(ThreeState.NO, "missing uses-feature watch, non-watch apks cannot be launched on a watch");
            if (launchCompatibility == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/LaunchCompatibility", "canRunOnDevice"));
            }
            return launchCompatibility;
        }
        if (projectTarget.isPlatform()) {
            LaunchCompatibility launchCompatibility = YES;
            if (launchCompatibility == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/LaunchCompatibility", "canRunOnDevice"));
            }
            return launchCompatibility;
        }
        IAndroidTarget.IOptionalLibrary[] optionalLibs = projectTarget.getOptionalLibraries();
        if (optionalLibs == null || optionalLibs.length == 0) {
            LaunchCompatibility launchCompatibility = YES;
            if (launchCompatibility == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/LaunchCompatibility", "canRunOnDevice"));
            }
            return launchCompatibility;
        }
        if (avdTarget == null) {
            LaunchCompatibility launchCompatibility = new LaunchCompatibility(ThreeState.UNSURE, "unsure if device supports addon: " + projectTarget.getName());
            if (launchCompatibility == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/LaunchCompatibility", "canRunOnDevice"));
            }
            return launchCompatibility;
        }
        LaunchCompatibility launchCompatibility = LaunchCompatibility.isCompatibleAddonAvd(projectTarget, avdTarget);
        if (launchCompatibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/LaunchCompatibility", "canRunOnDevice"));
        }
        return launchCompatibility;
    }

    private static LaunchCompatibility isCompatibleAddonAvd(IAndroidTarget projectTarget, IAndroidTarget avdTarget) {
        if (!StringUtil.equals((CharSequence)projectTarget.getVendor(), (CharSequence)avdTarget.getVendor())) {
            String reason = String.format("AVD vendor (%1$s) != AVD target (%2$s)", avdTarget.getVendor(), projectTarget.getVendor());
            return new LaunchCompatibility(ThreeState.NO, reason);
        }
        if (!StringUtil.equals((CharSequence)projectTarget.getName(), (CharSequence)avdTarget.getName())) {
            String reason = String.format("AVD target name (%1$s) != Project target name (%2$s)", avdTarget.getName(), projectTarget.getName());
            return new LaunchCompatibility(ThreeState.NO, reason);
        }
        return YES;
    }

    @NotNull
    public static LaunchCompatibility canRunOnAvd(@NotNull AndroidVersion minSdkVersion, @NotNull IAndroidTarget projectTarget, @NotNull IAndroidTarget avdTarget) {
        if (minSdkVersion == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/run/LaunchCompatibility", "canRunOnAvd"));
        }
        if (projectTarget == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/run/LaunchCompatibility", "canRunOnAvd"));
        }
        if (avdTarget == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/run/LaunchCompatibility", "canRunOnAvd"));
        }
        AndroidVersion avdVersion = avdTarget.getVersion();
        if (!avdVersion.canRun(minSdkVersion)) {
            String reason = String.format("minSdk(%1$s) %3$s deviceSdk(%2$s)", minSdkVersion, avdVersion, minSdkVersion.getCodename() == null ? ">" : "!=");
            LaunchCompatibility launchCompatibility = new LaunchCompatibility(ThreeState.NO, reason);
            if (launchCompatibility == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/LaunchCompatibility", "canRunOnAvd"));
            }
            return launchCompatibility;
        }
        LaunchCompatibility launchCompatibility = projectTarget.isPlatform() ? YES : LaunchCompatibility.isCompatibleAddonAvd(projectTarget, avdTarget);
        if (launchCompatibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/LaunchCompatibility", "canRunOnAvd"));
        }
        return launchCompatibility;
    }
}

