/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.multi;

import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.RenderContext;
import com.android.tools.idea.rendering.RenderedViewHierarchy;
import com.android.tools.idea.rendering.multi.RenderPreviewManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlFile;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PreviewRenderContext
implements RenderContext {
    @NotNull
    private final RenderContext myRenderContext;
    @NotNull
    private final Configuration myConfiguration;
    @NotNull
    private final XmlFile myPsiFile;

    public PreviewRenderContext(@NotNull RenderContext renderContext, @NotNull Configuration configuration, @NotNull XmlFile psiFile) {
        if (renderContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/multi/PreviewRenderContext", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/rendering/multi/PreviewRenderContext", "<init>"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/rendering/multi/PreviewRenderContext", "<init>"));
        }
        this.myRenderContext = renderContext;
        this.myConfiguration = configuration;
        this.myPsiFile = psiFile;
    }

    @Override
    @NotNull
    public Configuration getConfiguration() {
        Configuration configuration = this.myConfiguration;
        if (configuration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/multi/PreviewRenderContext", "getConfiguration"));
        }
        return configuration;
    }

    @Override
    public void setConfiguration(@NotNull Configuration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/multi/PreviewRenderContext", "setConfiguration"));
        }
        this.myRenderContext.setConfiguration(configuration);
    }

    @Override
    public void requestRender() {
        this.myRenderContext.requestRender();
    }

    @Override
    @NotNull
    public RenderContext.UsageType getType() {
        RenderContext.UsageType usageType = RenderContext.UsageType.THUMBNAIL_PREVIEW;
        if (usageType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/multi/PreviewRenderContext", "getType"));
        }
        return usageType;
    }

    @Override
    @Nullable
    public XmlFile getXmlFile() {
        return this.myPsiFile;
    }

    @Override
    @Nullable
    public VirtualFile getVirtualFile() {
        return this.myPsiFile.getVirtualFile();
    }

    @Override
    @Nullable
    public Module getModule() {
        return this.myRenderContext.getModule();
    }

    @Override
    public boolean hasAlphaChannel() {
        return this.myRenderContext.hasAlphaChannel();
    }

    @Override
    @NotNull
    public Component getComponent() {
        Component component = this.myRenderContext.getComponent();
        if (component == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/multi/PreviewRenderContext", "getComponent"));
        }
        return component;
    }

    @Override
    @NotNull
    public Dimension getFullImageSize() {
        Dimension dimension = this.myRenderContext.getFullImageSize();
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/multi/PreviewRenderContext", "getFullImageSize"));
        }
        return dimension;
    }

    @Override
    @NotNull
    public Dimension getScaledImageSize() {
        Dimension dimension = this.myRenderContext.getScaledImageSize();
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/multi/PreviewRenderContext", "getScaledImageSize"));
        }
        return dimension;
    }

    @Override
    @NotNull
    public Rectangle getClientArea() {
        Rectangle rectangle = this.myRenderContext.getClientArea();
        if (rectangle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/multi/PreviewRenderContext", "getClientArea"));
        }
        return rectangle;
    }

    @Override
    @Nullable
    public RenderPreviewManager getPreviewManager(boolean createIfNecessary) {
        return this.myRenderContext.getPreviewManager(createIfNecessary);
    }

    @Override
    public void setMaxSize(int width, int height) {
        this.myRenderContext.setMaxSize(width, height);
    }

    @Override
    public boolean supportsPreviews() {
        return this.myRenderContext.supportsPreviews();
    }

    @Override
    public void zoomFit(boolean onlyZoomOut, boolean allowZoomIn) {
        this.myRenderContext.zoomFit(onlyZoomOut, allowZoomIn);
    }

    @Override
    public void updateLayout() {
        this.myRenderContext.updateLayout();
    }

    @Override
    public void setDeviceFramesEnabled(boolean on) {
        this.myRenderContext.setDeviceFramesEnabled(on);
    }

    @Override
    @Nullable
    public BufferedImage getRenderedImage() {
        return this.myRenderContext.getRenderedImage();
    }

    @Override
    @Nullable
    public RenderedViewHierarchy getViewHierarchy() {
        return this.myRenderContext.getViewHierarchy();
    }
}

