/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.rendering.ResourceFolderRepository;
import com.google.common.collect.Maps;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.ui.EditorNotifications;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;

public class PsiProjectListener
extends PsiTreeChangeAdapter {
    @NotNull
    private static Map<Project, PsiProjectListener> ourListeners = Maps.newHashMap();
    @NotNull
    private final Map<VirtualFile, ResourceFolderRepository> myListeners;

    private PsiProjectListener(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/PsiProjectListener", "<init>"));
        }
        this.myListeners = Maps.newHashMap();
        PsiManager.getInstance((Project)project).addPsiTreeChangeListener((PsiTreeChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRoot(@NotNull Project project, @NotNull VirtualFile root, @NotNull ResourceFolderRepository repository) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/PsiProjectListener", "addRoot"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/rendering/PsiProjectListener", "addRoot"));
        }
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/rendering/PsiProjectListener", "addRoot"));
        }
        Class<PsiProjectListener> clazz = PsiProjectListener.class;
        synchronized (PsiProjectListener.class) {
            PsiProjectListener.getListener(project).addRoot(root, repository);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeRoot(@NotNull Project project, @NotNull VirtualFile root, @NotNull ResourceFolderRepository repository) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/PsiProjectListener", "removeRoot"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/rendering/PsiProjectListener", "removeRoot"));
        }
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/rendering/PsiProjectListener", "removeRoot"));
        }
        Class<PsiProjectListener> clazz = PsiProjectListener.class;
        synchronized (PsiProjectListener.class) {
            PsiProjectListener.getListener(project).removeRoot(root, repository);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @NotNull
    public static PsiProjectListener getListener(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/PsiProjectListener", "getListener"));
        }
        PsiProjectListener listener = ourListeners.get(project);
        if (listener == null) {
            listener = new PsiProjectListener(project);
            ourListeners.put(project, listener);
        }
        PsiProjectListener psiProjectListener = listener;
        if (psiProjectListener == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/PsiProjectListener", "getListener"));
        }
        return psiProjectListener;
    }

    private void addRoot(@NotNull VirtualFile root, @NotNull ResourceFolderRepository repository) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/PsiProjectListener", "addRoot"));
        }
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/rendering/PsiProjectListener", "addRoot"));
        }
        assert (this.myListeners.get(root) == null);
        this.myListeners.put(root, repository);
    }

    private void removeRoot(@NotNull VirtualFile root, @NotNull ResourceFolderRepository repository) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/PsiProjectListener", "removeRoot"));
        }
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/rendering/PsiProjectListener", "removeRoot"));
        }
        assert (this.myListeners.get(root) == repository) : repository;
        this.myListeners.remove(root);
    }

    static boolean isRelevantFileType(@NotNull FileType fileType) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/PsiProjectListener", "isRelevantFileType"));
        }
        if (fileType == StdFileTypes.JAVA) {
            return false;
        }
        return fileType == StdFileTypes.XML || fileType.isBinary() && fileType == FileTypeManager.getInstance().getFileTypeByExtension("png");
    }

    static boolean isRelevantFile(@NotNull VirtualFile file) {
        String parentName;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/PsiProjectListener", "isRelevantFile"));
        }
        FileType fileType = file.getFileType();
        if (fileType == StdFileTypes.JAVA) {
            return false;
        }
        if (PsiProjectListener.isRelevantFileType(fileType)) {
            return true;
        }
        VirtualFile parent = file.getParent();
        return parent != null && (parentName = parent.getName()).startsWith("raw");
    }

    static boolean isRelevantFile(@NotNull PsiFile file) {
        String parentName;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/PsiProjectListener", "isRelevantFile"));
        }
        FileType fileType = file.getFileType();
        if (fileType == StdFileTypes.JAVA) {
            return false;
        }
        if (PsiProjectListener.isRelevantFileType(fileType)) {
            return true;
        }
        PsiDirectory parent = file.getParent();
        return parent != null && (parentName = parent.getName()).startsWith("raw");
    }

    @Nullable
    private ResourceFolderRepository findRepository(@Nullable VirtualFile file) {
        if (file == null) {
            return null;
        }
        while (file != null) {
            ResourceFolderRepository repository = this.myListeners.get(file);
            if (repository != null) {
                return repository;
            }
            file = file.getParent();
        }
        return null;
    }

    public void childAdded(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/PsiProjectListener", "childAdded"));
        }
        PsiFile psiFile = event.getFile();
        if (psiFile == null) {
            PsiElement child = event.getChild();
            if (child instanceof PsiFile) {
                VirtualFile file = ((PsiFile)child).getVirtualFile();
                if (file != null && PsiProjectListener.isRelevantFile(file)) {
                    this.dispatchChildAdded(event, file);
                }
            } else if (child instanceof PsiDirectory) {
                PsiDirectory directory = (PsiDirectory)child;
                this.dispatchChildAdded(event, directory.getVirtualFile());
            }
        } else if (PsiProjectListener.isRelevantFile(psiFile)) {
            this.dispatchChildAdded(event, psiFile.getVirtualFile());
        }
    }

    private void dispatchChildAdded(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/PsiProjectListener", "dispatchChildAdded"));
        }
        ResourceFolderRepository repository = this.findRepository(virtualFile);
        if (repository != null) {
            repository.getPsiListener().childAdded(event);
        }
    }

    public void childRemoved(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/PsiProjectListener", "childRemoved"));
        }
        PsiFile psiFile = event.getFile();
        if (psiFile == null) {
            PsiDirectory directory;
            PsiElement child = event.getChild();
            if (child instanceof PsiFile) {
                VirtualFile file = ((PsiFile)child).getVirtualFile();
                if (file != null && PsiProjectListener.isRelevantFile(file)) {
                    this.dispatchChildRemoved(event, file);
                }
            } else if (child instanceof PsiDirectory && ResourceFolderType.getFolderType((String)(directory = (PsiDirectory)child).getName()) != null) {
                VirtualFile file = directory.getVirtualFile();
                this.dispatchChildRemoved(event, file);
            }
        } else if (PsiProjectListener.isRelevantFile(psiFile)) {
            VirtualFile file = psiFile.getVirtualFile();
            this.dispatchChildRemoved(event, file);
        }
    }

    private void dispatchChildRemoved(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/PsiProjectListener", "dispatchChildRemoved"));
        }
        ResourceFolderRepository repository = this.findRepository(virtualFile);
        if (repository != null) {
            repository.getPsiListener().childRemoved(event);
        }
    }

    public void childReplaced(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/PsiProjectListener", "childReplaced"));
        }
        PsiFile psiFile = event.getFile();
        if (psiFile != null) {
            VirtualFile virtualFile;
            if (PsiProjectListener.isRelevantFile(psiFile)) {
                this.dispatchChildReplaced(event, psiFile.getVirtualFile());
            }
            if (psiFile.getFileType() == GroovyFileType.GROOVY_FILE_TYPE && (virtualFile = psiFile.getVirtualFile()) != null && "gradle".equals(virtualFile.getExtension())) {
                EditorNotifications.getInstance((Project)psiFile.getProject()).updateAllNotifications();
            }
        } else {
            PsiElement parent = event.getParent();
            if (parent instanceof PsiDirectory) {
                PsiDirectory directory = (PsiDirectory)parent;
                this.dispatchChildReplaced(event, directory.getVirtualFile());
            }
        }
    }

    private void dispatchChildReplaced(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/PsiProjectListener", "dispatchChildReplaced"));
        }
        ResourceFolderRepository repository = this.findRepository(virtualFile);
        if (repository != null) {
            repository.getPsiListener().childReplaced(event);
        }
    }

    public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/PsiProjectListener", "childrenChanged"));
        }
        PsiFile psiFile = event.getFile();
        if (psiFile != null && PsiProjectListener.isRelevantFile(psiFile)) {
            VirtualFile file = psiFile.getVirtualFile();
            this.dispatchChildrenChanged(event, file);
        }
    }

    private void dispatchChildrenChanged(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/PsiProjectListener", "dispatchChildrenChanged"));
        }
        ResourceFolderRepository repository = this.findRepository(virtualFile);
        if (repository != null) {
            repository.getPsiListener().childrenChanged(event);
        }
    }

    public void childMoved(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/PsiProjectListener", "childMoved"));
        }
        PsiElement child = event.getChild();
        PsiFile psiFile = event.getFile();
        if (psiFile == null) {
            if (child instanceof PsiFile && PsiProjectListener.isRelevantFile((PsiFile)child)) {
                VirtualFile file = ((PsiFile)child).getVirtualFile();
                if (file != null) {
                    this.dispatchChildMoved(event, file);
                    return;
                }
                PsiElement oldParent = event.getOldParent();
                if (oldParent instanceof PsiDirectory) {
                    PsiDirectory directory = (PsiDirectory)oldParent;
                    VirtualFile dir = directory.getVirtualFile();
                    this.dispatchChildMoved(event, dir);
                }
            }
        } else {
            VirtualFile file = psiFile.getVirtualFile();
            if (file != null && PsiProjectListener.isRelevantFile(file)) {
                this.dispatchChildMoved(event, file);
            }
        }
    }

    private void dispatchChildMoved(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
        PsiDirectory sourceDir;
        ResourceFolderRepository targetRepository;
        PsiElement oldParent;
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/PsiProjectListener", "dispatchChildMoved"));
        }
        ResourceFolderRepository repository = this.findRepository(virtualFile);
        if (repository != null) {
            repository.getPsiListener().childMoved(event);
        }
        if (event.getFile() == null && (oldParent = event.getOldParent()) instanceof PsiDirectory && (targetRepository = this.findRepository((sourceDir = (PsiDirectory)oldParent).getVirtualFile())) != null && targetRepository != repository) {
            targetRepository.getPsiListener().childMoved(event);
        }
    }

    public void beforePropertyChange(@NotNull PsiTreeChangeEvent event) {
        PsiFile psiFile;
        PsiElement child;
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/PsiProjectListener", "beforePropertyChange"));
        }
        if ("fileName" == event.getPropertyName() && (child = event.getChild()) instanceof PsiFile && PsiProjectListener.isRelevantFile(psiFile = (PsiFile)child)) {
            VirtualFile file = psiFile.getVirtualFile();
            this.dispatchBeforePropertyChange(event, file);
        }
    }

    private void dispatchBeforePropertyChange(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/PsiProjectListener", "dispatchBeforePropertyChange"));
        }
        ResourceFolderRepository repository = this.findRepository(virtualFile);
        if (repository != null) {
            repository.getPsiListener().beforePropertyChange(event);
        }
    }

    public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
        PsiFile psiFile;
        PsiElement child;
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/PsiProjectListener", "propertyChanged"));
        }
        if ("fileName" == event.getPropertyName() && (child = event.getElement()) instanceof PsiFile && PsiProjectListener.isRelevantFile(psiFile = (PsiFile)child)) {
            VirtualFile file = psiFile.getVirtualFile();
            this.dispatchPropertyChange(event, file);
        }
    }

    private void dispatchPropertyChange(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/PsiProjectListener", "dispatchPropertyChange"));
        }
        ResourceFolderRepository repository = this.findRepository(virtualFile);
        if (repository != null) {
            repository.getPsiListener().propertyChanged(event);
        }
    }
}

