/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.io.FileWrapper;
import com.android.io.IAbstractFile;
import com.android.tools.idea.rendering.AarResourceClassGenerator;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.android.tools.idea.rendering.FileResourceRepository;
import com.android.xml.AndroidManifest;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AarResourceClassRegistry {
    private static AarResourceClassRegistry ourInstance = new AarResourceClassRegistry();
    private final Map<String, AarResourceClassGenerator> myGeneratorMap = Maps.newHashMap();

    public static AarResourceClassRegistry get() {
        return ourInstance;
    }

    public void addLibrary(AppResourceRepository appResources, File aarDir) {
        AarResourceClassGenerator generator;
        String pkg;
        FileResourceRepository repository;
        String path = aarDir.getPath();
        if ((path.endsWith(".aar") || path.contains("exploded-aar")) && (repository = appResources.findRepositoryFor(aarDir)) != null && (pkg = AarResourceClassRegistry.getAarPackage(aarDir)) != null && (generator = AarResourceClassGenerator.create(appResources, repository)) != null) {
            this.myGeneratorMap.put(pkg, generator);
        }
    }

    @Nullable
    private static String getAarPackage(@NotNull File aarDir) {
        if (aarDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/AarResourceClassRegistry", "getAarPackage"));
        }
        File manifest = new File(aarDir, "AndroidManifest.xml");
        if (manifest.exists()) {
            try {
                return AndroidManifest.getPackage((IAbstractFile)new FileWrapper(manifest));
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    @Nullable
    public byte[] findClassDefinition(@NotNull String name) {
        String pkg;
        AarResourceClassGenerator generator;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/AarResourceClassRegistry", "findClassDefinition"));
        }
        int index = name.lastIndexOf(46);
        if (index != -1 && name.charAt(index + 1) == 'R' && (index == name.length() - 2 || name.charAt(index + 2) == '$') && index > 1 && (generator = this.myGeneratorMap.get(pkg = name.substring(0, index))) != null) {
            return generator.generate(name);
        }
        return null;
    }
}

