/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.android.tools.idea.navigator.AndroidProjectViewPane;
import com.google.common.base.Joiner;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidResFileNode
extends PsiFileNode {
    private final AndroidFacet myFacet;

    public AndroidResFileNode(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull ViewSettings settings, @NotNull AndroidFacet facet) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/navigator/nodes/AndroidResFileNode", "<init>"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/navigator/nodes/AndroidResFileNode", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/navigator/nodes/AndroidResFileNode", "<init>"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/android/tools/idea/navigator/nodes/AndroidResFileNode", "<init>"));
        }
        super(project, psiFile, settings);
        this.myFacet = facet;
    }

    public void update(PresentationData data) {
        super.update(data);
        String text = data.getPresentableText();
        data.addText(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        data.setPresentableText(text);
        String qualifier = this.getQualifier((PsiFile)this.getValue());
        if (qualifier != null) {
            data.addText(qualifier, SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        PsiFile psiFile = (PsiFile)this.getValue();
        String qualifier = this.getQualifier(psiFile);
        return psiFile.getName() + (qualifier == null ? "" : qualifier);
    }

    @Nullable
    private String getQualifier(@Nullable PsiFile resFile) {
        IdeaSourceProvider ideaSourceProvider;
        if (resFile == null) {
            return null;
        }
        PsiDirectory resTypeFolder = resFile.getParent();
        if (resTypeFolder == null) {
            return null;
        }
        String folderName = resTypeFolder.getName();
        int index = folderName.indexOf("-");
        String qualifier = index < 0 ? null : folderName.substring(index + 1);
        String providerName = null;
        PsiDirectory resFolder = resTypeFolder.getParent();
        if (resFolder != null && (ideaSourceProvider = this.findSourceProviderForResFolder(resFolder)) != null && "main".equals(providerName = ideaSourceProvider.getName())) {
            providerName = null;
        }
        if (qualifier == null && providerName == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(10);
        sb.append(" (");
        sb.append(Joiner.on((String)", ").skipNulls().join((Object)qualifier, (Object)providerName, new Object[0]));
        sb.append(')');
        return sb.toString();
    }

    @Nullable
    private IdeaSourceProvider findSourceProviderForResFolder(@NotNull PsiDirectory resDirectory) {
        if (resDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/navigator/nodes/AndroidResFileNode", "findSourceProviderForResFolder"));
        }
        for (IdeaSourceProvider provider : AndroidProjectViewPane.getSourceProviders(this.myFacet)) {
            if (!provider.getResDirectories().contains(resDirectory.getVirtualFile())) continue;
            return provider;
        }
        return null;
    }
}

