/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.psi.PsiDirectory;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidPsiDirectoryNode
extends PsiDirectoryNode {
    private final IdeaSourceProvider mySourceProvider;

    public AndroidPsiDirectoryNode(@NotNull Project project, @NotNull PsiDirectory directory, @NotNull ViewSettings settings, @Nullable IdeaSourceProvider sourceProvider) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/navigator/nodes/AndroidPsiDirectoryNode", "<init>"));
        }
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/navigator/nodes/AndroidPsiDirectoryNode", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/navigator/nodes/AndroidPsiDirectoryNode", "<init>"));
        }
        super(project, directory, settings);
        this.mySourceProvider = sourceProvider;
    }

    protected void updateImpl(PresentationData data) {
        super.updateImpl(data);
        if (this.mySourceProvider != null & !"main".equals(this.mySourceProvider.getName())) {
            data.addText(data.getPresentableText(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            data.addText(" (" + this.mySourceProvider.getName() + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        PsiDirectory directory = (PsiDirectory)this.getValue();
        return directory.getName() + " (" + this.mySourceProvider.getName() + ")";
    }
}

