/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.android.tools.idea.navigator.AndroidProjectViewPane;
import com.android.tools.idea.navigator.nodes.AndroidProjectViewNode;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidManifestFileNode
extends PsiFileNode
implements AndroidProjectViewNode {
    @NotNull
    private final AndroidFacet myFacet;

    public AndroidManifestFileNode(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull ViewSettings settings, @NotNull AndroidFacet facet) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/navigator/nodes/AndroidManifestFileNode", "<init>"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/navigator/nodes/AndroidManifestFileNode", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/navigator/nodes/AndroidManifestFileNode", "<init>"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/android/tools/idea/navigator/nodes/AndroidManifestFileNode", "<init>"));
        }
        super(project, psiFile, settings);
        this.myFacet = facet;
    }

    public void update(PresentationData data) {
        super.update(data);
        IdeaSourceProvider sourceProvider = this.getSourceProvider((PsiFile)this.getValue());
        if (sourceProvider != null && !"main".equals(sourceProvider.getName())) {
            PsiFile file = (PsiFile)this.getValue();
            data.addText(file.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            data.addText(" (" + sourceProvider.getName() + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
            data.setPresentableText(file.getName());
        }
    }

    @Nullable
    private IdeaSourceProvider getSourceProvider(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/navigator/nodes/AndroidManifestFileNode", "getSourceProvider"));
        }
        for (IdeaSourceProvider provider : AndroidProjectViewPane.getSourceProviders(this.myFacet)) {
            if (!file.getVirtualFile().equals(provider.getManifestFile())) continue;
            return provider;
        }
        return null;
    }

    @Override
    @NotNull
    public AndroidFacet getAndroidFacet() {
        AndroidFacet androidFacet = this.myFacet;
        if (androidFacet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/navigator/nodes/AndroidManifestFileNode", "getAndroidFacet"));
        }
        return androidFacet;
    }

    @Override
    @NotNull
    public PsiDirectory[] getDirectories() {
        if (PsiDirectory.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/navigator/nodes/AndroidManifestFileNode", "getDirectories"));
        }
        return PsiDirectory.EMPTY_ARRAY;
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        StringBuilder sb = new StringBuilder();
        PsiFile file = (PsiFile)this.getValue();
        sb.append(file.getName());
        sb.append(" (");
        sb.append(this.getSourceProvider((PsiFile)this.getValue()).getName());
        sb.append(")");
        return sb.toString();
    }
}

