/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.android.tools.idea.gradle.project.AndroidGradleProjectData;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.navigator.nodes.AndroidBuildScriptNode;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import icons.GradleIcons;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidBuildScriptsGroupNode
extends ProjectViewNode<List<PsiDirectory>> {
    private static final Set<String> ourBuildFileNames = ImmutableSet.of((Object)"settings.gradle", (Object)"gradle.properties", (Object)"build.gradle", (Object)"gradle-wrapper.properties");

    public AndroidBuildScriptsGroupNode(@NotNull Project project, @NotNull ViewSettings viewSettings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/navigator/nodes/AndroidBuildScriptsGroupNode", "<init>"));
        }
        if (viewSettings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/navigator/nodes/AndroidBuildScriptsGroupNode", "<init>"));
        }
        super(project, Collections.emptyList(), viewSettings);
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/navigator/nodes/AndroidBuildScriptsGroupNode", "contains"));
        }
        return ourBuildFileNames.contains(file.getName());
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        File userSettingsFile;
        ArrayList children = Lists.newArrayList();
        VirtualFile baseDir = this.myProject.getBaseDir();
        this.addPsiFile(children, baseDir.findChild("settings.gradle"), "Project Settings");
        this.addPsiFile(children, baseDir.findChild("gradle.properties"), "Project Properties");
        this.addPsiFile(children, baseDir.findFileByRelativePath(GradleUtil.GRADLEW_PROPERTIES_PATH), null);
        if (!ApplicationManager.getApplication().isUnitTestMode() && (userSettingsFile = AndroidGradleProjectData.getGradleUserSettingsFile()) != null) {
            this.addPsiFile(children, VfsUtil.findFileByIoFile((File)userSettingsFile, (boolean)false), "Global Properties");
        }
        for (Module m : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            this.addPsiFile(children, GradleUtil.getGradleBuildFile(m), m.getName());
        }
        ArrayList arrayList = children;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/navigator/nodes/AndroidBuildScriptsGroupNode", "getChildren"));
        }
        return arrayList;
    }

    private void addPsiFile(@NotNull List<PsiFileNode> psiFileNodes, @Nullable VirtualFile file, @Nullable String qualifier) {
        if (psiFileNodes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/navigator/nodes/AndroidBuildScriptsGroupNode", "addPsiFile"));
        }
        if (file == null) {
            return;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
        if (psiFile != null) {
            psiFileNodes.add(new AndroidBuildScriptNode(this.myProject, psiFile, this.getSettings(), qualifier));
        }
    }

    protected void update(PresentationData presentation) {
        presentation.setPresentableText("Gradle Scripts");
        presentation.setIcon(GradleIcons.Gradle);
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return "Gradle Scripts";
    }
}

