/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator;

import com.android.tools.idea.navigator.AndroidProjectTreeBuilder;
import com.android.tools.idea.navigator.nodes.AndroidProjectViewNode;
import com.android.tools.idea.navigator.nodes.AndroidViewProjectNode;
import com.google.common.collect.Lists;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.impl.ProjectPaneSelectInTarget;
import com.intellij.ide.projectView.BaseProjectTreeBuilder;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.AbstractProjectViewPSIPane;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.projectView.impl.ProjectTreeStructure;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.ide.projectView.impl.nodes.PackageElement;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import icons.AndroidIcons;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;

public class AndroidProjectViewPane
extends AbstractProjectViewPSIPane {
    public static final String ID = "AndroidView";

    public AndroidProjectViewPane(Project project) {
        super(project);
    }

    public String getTitle() {
        return "Android";
    }

    public Icon getIcon() {
        return AndroidIcons.Android;
    }

    @NotNull
    public String getId() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/navigator/AndroidProjectViewPane", "getId"));
        }
        return ID;
    }

    public int getWeight() {
        return 142;
    }

    @NotNull
    public static List<IdeaSourceProvider> getSourceProviders(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/navigator/AndroidProjectViewPane", "getSourceProviders"));
        }
        List<IdeaSourceProvider> sourceProviders = IdeaSourceProvider.getCurrentSourceProviders(facet);
        sourceProviders.addAll(IdeaSourceProvider.getCurrentTestSourceProviders(facet));
        List<IdeaSourceProvider> list = sourceProviders;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/navigator/AndroidProjectViewPane", "getSourceProviders"));
        }
        return list;
    }

    public SelectInTarget createSelectInTarget() {
        return new ProjectPaneSelectInTarget(this.myProject);
    }

    protected ProjectAbstractTreeStructureBase createStructure() {
        return new ProjectTreeStructure(this.myProject, ID){

            protected AbstractTreeNode createRoot(Project project, ViewSettings settings) {
                return new AndroidViewProjectNode(project, settings, AndroidProjectViewPane.this);
            }
        };
    }

    @NotNull
    protected BaseProjectTreeBuilder createBuilder(DefaultTreeModel treeModel) {
        AndroidProjectTreeBuilder androidProjectTreeBuilder = new AndroidProjectTreeBuilder(this.myProject, (JTree)this.myTree, treeModel, null, (ProjectAbstractTreeStructureBase)this.myTreeStructure);
        if (androidProjectTreeBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/navigator/AndroidProjectViewPane", "createBuilder"));
        }
        return androidProjectTreeBuilder;
    }

    protected ProjectViewTree createTree(DefaultTreeModel treeModel) {
        return new ProjectViewTree(this.myProject, treeModel){

            public DefaultMutableTreeNode getSelectedNode() {
                return AndroidProjectViewPane.this.getSelectedNode();
            }
        };
    }

    protected AbstractTreeUpdater createTreeUpdater(AbstractTreeBuilder treeBuilder) {
        return new AbstractTreeUpdater(treeBuilder);
    }

    public PsiDirectory[] getSelectedDirectories() {
        PackageElement packageElement;
        Module m;
        Object selectedElement = this.getSelectedElement();
        if (selectedElement instanceof PackageElement && (m = (packageElement = (PackageElement)selectedElement).getModule()) != null) {
            return packageElement.getPackage().getDirectories(GlobalSearchScope.moduleScope((Module)m));
        }
        NodeDescriptor descriptor = this.getSelectedDescriptor();
        if (descriptor instanceof AndroidProjectViewNode) {
            return ((AndroidProjectViewNode)descriptor).getDirectories();
        }
        return super.getSelectedDirectories();
    }

    public Object getData(String dataId) {
        PsiDirectory[] directories;
        NodeDescriptor selectedDescriptor;
        PackageElement packageElement;
        Module m;
        Object o;
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        if (LangDataKeys.MODULE.is(dataId)) {
            o = this.getSelectedElement();
            if (o instanceof PackageElement) {
                PackageElement packageElement2 = (PackageElement)o;
                return packageElement2.getModule();
            }
            if (o instanceof AndroidFacet) {
                return ((AndroidFacet)((Object)o)).getModule();
            }
        }
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId) && (o = this.getSelectedElement()) instanceof PackageElement && (m = (packageElement = (PackageElement)o).getModule()) != null) {
            PsiDirectory[] folders = packageElement.getPackage().getDirectories(GlobalSearchScope.moduleScope((Module)m));
            if (folders.length > 0) {
                return folders[0].getVirtualFile();
            }
            return null;
        }
        if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId) && (selectedDescriptor = this.getSelectedDescriptor()) instanceof AndroidProjectViewNode && (directories = ((AndroidProjectViewNode)selectedDescriptor).getDirectories()).length > 0) {
            ArrayList virtualFiles = Lists.newArrayListWithExpectedSize((int)directories.length);
            for (PsiDirectory directory : directories) {
                if (!directory.isValid()) continue;
                virtualFiles.add(directory.getVirtualFile());
            }
            return virtualFiles.toArray(new VirtualFile[virtualFiles.size()]);
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            PsiDirectory[] directories2;
            List l;
            o = this.getSelectedElement();
            if (o instanceof PsiElement) {
                return o;
            }
            if (o instanceof List && !(l = (List)o).isEmpty() && l.get(0) instanceof PsiElement) {
                return l.get(0);
            }
            NodeDescriptor selectedDescriptor2 = this.getSelectedDescriptor();
            if (selectedDescriptor2 instanceof AndroidProjectViewNode && (directories2 = ((AndroidProjectViewNode)selectedDescriptor2).getDirectories()).length > 0) {
                return directories2[0];
            }
        }
        return super.getData(dataId);
    }
}

