/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.variant.conflict;

import com.android.tools.idea.gradle.util.ModuleTypeComparator;
import com.android.tools.idea.gradle.util.ui.ToolWindowAlikePanel;
import com.android.tools.idea.gradle.variant.conflict.Conflict;
import com.android.tools.idea.gradle.variant.ui.VariantCheckboxTreeCellRenderer;
import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import org.jdesktop.swingx.JXLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ConflictResolutionDialog
extends DialogWrapper {
    private final JPanel myPanel;
    private final ConflictTree myTree;

    ConflictResolutionDialog(@NotNull Conflict conflict) {
        if (conflict == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/variant/conflict/ConflictResolutionDialog", "<init>"));
        }
        super(conflict.getSource().getProject());
        this.setTitle("Resolve Variant Selection Conflict");
        this.myPanel = new JPanel(new BorderLayout());
        this.myPanel.setPreferredSize(new Dimension(400, 400));
        this.init();
        VariantCheckboxTreeCellRenderer renderer = new VariantCheckboxTreeCellRenderer(){

            public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (value instanceof DefaultMutableTreeNode) {
                    Object data = ((DefaultMutableTreeNode)value).getUserObject();
                    if (data instanceof String) {
                        this.appendVariant((String)data);
                    }
                    if (data instanceof Module) {
                        this.appendModule((Module)data, null);
                    }
                }
            }
        };
        CheckedTreeNode root = new CheckedTreeNode(null);
        this.myTree = new ConflictTree(renderer, root);
        this.myTree.setRootVisible(false);
        ArrayList variants = Lists.newArrayList(conflict.getVariants());
        Collections.sort(variants);
        for (String variant : variants) {
            CheckedTreeNode variantNode = new CheckedTreeNode((Object)variant);
            variantNode.setChecked(false);
            root.add((MutableTreeNode)variantNode);
            ArrayList dependents = Lists.newArrayList();
            for (Conflict.AffectedModule affected : conflict.getModulesExpectingVariant(variant)) {
                Module module = affected.getTarget();
                dependents.add(module);
            }
            if (dependents.size() > 1) {
                Collections.sort(dependents, ModuleTypeComparator.INSTANCE);
            }
            for (Module dependent : dependents) {
                DefaultMutableTreeNode moduleNode = new DefaultMutableTreeNode(dependent);
                variantNode.add((MutableTreeNode)moduleNode);
            }
        }
        this.myTree.expandAll();
        JXLabel descriptionLabel = new JXLabel();
        descriptionLabel.setLineWrap(true);
        String sourceName = conflict.getSource().getName();
        String text = "The conflict cannot be automatically solved.\n";
        text = text + String.format("Module '%1$s' has variant '%2$s' selected, but multiple modules require different variants.", sourceName, conflict.getSelectedVariant());
        descriptionLabel.setText(text);
        descriptionLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 5, 2));
        this.myPanel.add((Component)descriptionLabel, "North");
        String title = String.format("Variants in '%1$s' and their dependents", sourceName);
        this.myPanel.add((Component)ToolWindowAlikePanel.createTreePanel(title, (JTree)((Object)this.myTree)), "Center");
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/variant/conflict/ConflictResolutionDialog", "createCenterPanel"));
        }
        return jPanel;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = super.createActions();
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/variant/conflict/ConflictResolutionDialog", "createActions"));
        }
        return actionArray;
    }

    protected boolean postponeValidation() {
        return false;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        if (StringUtil.isEmpty((String)this.getSelectedVariant())) {
            return new ValidationInfo("Please choose the variant to set");
        }
        return null;
    }

    @Nullable
    String getSelectedVariant() {
        return this.myTree.getSelectedVariant();
    }

    private static class ConflictTree
    extends CheckboxTree {
        @NotNull
        final CheckedTreeNode myRoot;

        ConflictTree(@NotNull CheckboxTree.CheckboxTreeCellRenderer cellRenderer, @NotNull CheckedTreeNode root) {
            if (cellRenderer == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/variant/conflict/ConflictResolutionDialog$ConflictTree", "<init>"));
            }
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/variant/conflict/ConflictResolutionDialog$ConflictTree", "<init>"));
            }
            super(cellRenderer, root);
            this.myRoot = root;
        }

        @Nullable
        String getSelectedVariant() {
            Enumeration moduleNodes = this.myRoot.children();
            while (moduleNodes.hasMoreElements()) {
                CheckedTreeNode node;
                Object child = moduleNodes.nextElement();
                if (!(child instanceof CheckedTreeNode) || !(node = (CheckedTreeNode)child).isChecked()) continue;
                return node.getUserObject().toString();
            }
            return null;
        }

        void expandAll() {
            TreeUtil.expandAll((JTree)((Object)this));
        }

        public DefaultTreeModel getModel() {
            return (DefaultTreeModel)super.getModel();
        }

        protected void onNodeStateChanged(CheckedTreeNode node) {
            if (!node.isChecked()) {
                return;
            }
            Enumeration moduleNodes = this.myRoot.children();
            while (moduleNodes.hasMoreElements()) {
                Object child = moduleNodes.nextElement();
                if (child == node || !(child instanceof CheckedTreeNode)) continue;
                CheckedTreeNode childNode = (CheckedTreeNode)child;
                childNode.setChecked(false);
            }
        }
    }
}

