/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.variant.conflict;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.intellij.openapi.module.Module;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class Conflict {
    @NotNull
    private final Module mySource;
    @NotNull
    private final String mySelectedVariant;
    @NotNull
    private final Multimap<String, AffectedModule> myAffectedModulesByExpectedVariant;
    @NotNull
    private final List<AffectedModule> myAffectedModules;
    private boolean myResolved;

    public Conflict(@NotNull Module source, @NotNull String selectedVariant) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/variant/conflict/Conflict", "<init>"));
        }
        if (selectedVariant == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/variant/conflict/Conflict", "<init>"));
        }
        this.myAffectedModulesByExpectedVariant = ArrayListMultimap.create();
        this.myAffectedModules = Lists.newArrayList();
        this.mySource = source;
        this.mySelectedVariant = selectedVariant;
    }

    public void addAffectedModule(@NotNull Module target, @NotNull String expectedVariant) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/variant/conflict/Conflict", "addAffectedModule"));
        }
        if (expectedVariant == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/variant/conflict/Conflict", "addAffectedModule"));
        }
        AffectedModule affected = new AffectedModule(this, target, expectedVariant);
        this.myAffectedModules.add(affected);
        this.myAffectedModulesByExpectedVariant.put((Object)expectedVariant, (Object)affected);
    }

    @NotNull
    public Collection<String> getVariants() {
        Set set = this.myAffectedModulesByExpectedVariant.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/variant/conflict/Conflict", "getVariants"));
        }
        return set;
    }

    @NotNull
    public Collection<AffectedModule> getModulesExpectingVariant(@NotNull String variant) {
        if (variant == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/variant/conflict/Conflict", "getModulesExpectingVariant"));
        }
        Collection collection = this.myAffectedModulesByExpectedVariant.get((Object)variant);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/variant/conflict/Conflict", "getModulesExpectingVariant"));
        }
        return collection;
    }

    @NotNull
    public Module getSource() {
        Module module = this.mySource;
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/variant/conflict/Conflict", "getSource"));
        }
        return module;
    }

    @NotNull
    public String getSelectedVariant() {
        String string = this.mySelectedVariant;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/variant/conflict/Conflict", "getSelectedVariant"));
        }
        return string;
    }

    @NotNull
    public List<AffectedModule> getAffectedModules() {
        List<AffectedModule> list = this.myAffectedModules;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/variant/conflict/Conflict", "getAffectedModules"));
        }
        return list;
    }

    public void refreshStatus() {
        int selectedVariantCount = 0;
        block0: for (String variant : this.myAffectedModulesByExpectedVariant.keySet()) {
            for (AffectedModule affected : this.getModulesExpectingVariant(variant)) {
                if (!affected.isSelected()) continue;
                ++selectedVariantCount;
                continue block0;
            }
        }
        this.setResolved(selectedVariantCount <= 1);
    }

    public boolean isResolved() {
        return this.myResolved;
    }

    public void setResolved(boolean resolved) {
        this.myResolved = resolved;
    }

    public String toString() {
        String text = String.format("Module '%1$s' has variant '%2$s' selected, but", this.mySource.getName(), this.mySelectedVariant);
        ArrayList expectedVariants = Lists.newArrayList(this.getVariants());
        if (expectedVariants.size() == 1) {
            String expectedVariant = (String)expectedVariants.get(0);
            Collection<AffectedModule> modules = this.getModulesExpectingVariant(expectedVariant);
            String moduleNames = Conflict.getModuleNames(modules);
            String format = modules.size() == 1 ? " the module '%1$s' depends on variant '%2$s'" : " the modules %1$s depend on variant '%2$s'";
            text = text + String.format(format, moduleNames, expectedVariant);
        } else {
            Collections.sort(expectedVariants);
            for (String expectedVariant : expectedVariants) {
                Collection<AffectedModule> modules = this.getModulesExpectingVariant(expectedVariant);
                String moduleNames = Conflict.getModuleNames(modules);
                text = text + "\n- ";
                String format = modules.size() == 1 ? "Module '%1$s' depends on variant '%2$s'" : "Modules %1$s depend on variant '%2$s'";
                text = text + String.format(format, moduleNames, expectedVariant);
            }
        }
        return text;
    }

    @NotNull
    private static String getModuleNames(@NotNull Collection<AffectedModule> modules) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/variant/conflict/Conflict", "getModuleNames"));
        }
        if (modules.size() == 1) {
            AffectedModule module = (AffectedModule)ContainerUtil.getFirstItem(modules);
            assert (module != null);
            String string = "'" + module.getTarget().getName() + "'";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/variant/conflict/Conflict", "getModuleNames"));
            }
            return string;
        }
        ArrayList names = Lists.newArrayList();
        for (AffectedModule module : modules) {
            names.add("'" + module.getTarget().getName() + "'");
        }
        Collections.sort(names);
        String string = ((Object)names).toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/variant/conflict/Conflict", "getModuleNames"));
        }
        return string;
    }

    public static class AffectedModule {
        @NotNull
        private final Conflict myConflict;
        @NotNull
        private final Module myTarget;
        @NotNull
        private final String myExpectedVariant;
        private boolean mySelected;

        AffectedModule(@NotNull Conflict conflict, @NotNull Module target, @NotNull String expectedVariant) {
            if (conflict == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/variant/conflict/Conflict$AffectedModule", "<init>"));
            }
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/variant/conflict/Conflict$AffectedModule", "<init>"));
            }
            if (expectedVariant == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/gradle/variant/conflict/Conflict$AffectedModule", "<init>"));
            }
            this.mySelected = true;
            this.myConflict = conflict;
            this.myTarget = target;
            this.myExpectedVariant = expectedVariant;
        }

        @NotNull
        public Conflict getConflict() {
            Conflict conflict = this.myConflict;
            if (conflict == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/variant/conflict/Conflict$AffectedModule", "getConflict"));
            }
            return conflict;
        }

        @NotNull
        public Module getTarget() {
            Module module = this.myTarget;
            if (module == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/variant/conflict/Conflict$AffectedModule", "getTarget"));
            }
            return module;
        }

        @NotNull
        public String getExpectedVariant() {
            String string = this.myExpectedVariant;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/variant/conflict/Conflict$AffectedModule", "getExpectedVariant"));
            }
            return string;
        }

        public boolean isSelected() {
            return this.mySelected;
        }

        public void setSelected(boolean selected) {
            this.mySelected = selected;
            this.myConflict.refreshStatus();
        }
    }
}

