/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.JavaModel;
import com.android.tools.idea.gradle.compiler.AndroidGradleBuildConfiguration;
import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.facet.JavaGradleFacet;
import com.android.tools.idea.gradle.facet.JavaGradleFacetConfiguration;
import com.android.tools.idea.gradle.messages.ProjectSyncMessages;
import com.android.tools.idea.startup.AndroidStudioSpecificInitializer;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.compiler.options.ExternalBuildOptionListener;
import com.intellij.ide.DataManager;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.IdeFrameEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.util.messages.MessageBus;
import java.awt.Component;
import java.io.File;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public final class Projects {
    public static final Key<Boolean> HAS_UNRESOLVED_DEPENDENCIES = Key.create((String)"has.unresolved.dependencies");
    public static final Key<Boolean> HAS_WRONG_JDK = Key.create((String)"has.wrong.jdk");
    private static final Logger LOG = Logger.getInstance(Projects.class);
    private static final Module[] NO_MODULES = new Module[0];

    private Projects() {
    }

    public static boolean lastGradleSyncFailed(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/util/Projects", "lastGradleSyncFailed"));
        }
        return !GradleSyncState.getInstance(project).isSyncInProgress() && Projects.isGradleProjectWithoutModel(project) || Projects.hasErrors(project);
    }

    public static boolean hasErrors(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/util/Projects", "hasErrors"));
        }
        if (Projects.hasUnresolvedDependencies(project) || Projects.hasWrongJdk(project)) {
            return true;
        }
        ProjectSyncMessages messages = ProjectSyncMessages.getInstance(project);
        int errorCount = messages.getErrorCount();
        if (errorCount > 0) {
            return false;
        }
        int variantSelectionErrorCount = messages.getMessageCount("Variant selection conflicts");
        return errorCount != variantSelectionErrorCount;
    }

    private static boolean hasUnresolvedDependencies(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/util/Projects", "hasUnresolvedDependencies"));
        }
        return Projects.getBoolean(project, HAS_UNRESOLVED_DEPENDENCIES);
    }

    private static boolean hasWrongJdk(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/util/Projects", "hasWrongJdk"));
        }
        return Projects.getBoolean(project, HAS_WRONG_JDK);
    }

    private static boolean getBoolean(@NotNull Project project, @NotNull Key<Boolean> key) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/util/Projects", "getBoolean"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/util/Projects", "getBoolean"));
        }
        Boolean val = (Boolean)project.getUserData(key);
        return val != null && val != false;
    }

    public static boolean isGradleProjectWithoutModel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/util/Projects", "isGradleProjectWithoutModel"));
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null || !facet.isGradleProject() || facet.getIdeaAndroidProject() != null) continue;
            return true;
        }
        return false;
    }

    public static void open(@NotNull Project project) {
        boolean fullScreen;
        IdeFocusManager instance;
        IdeFrame lastFocusedFrame;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/util/Projects", "open"));
        }
        ProjectManagerEx projectManager = ProjectManagerEx.getInstanceEx();
        ProjectUtil.updateLastProjectLocation((String)project.getBasePath());
        if (WindowManager.getInstance().isFullScreenSupportedInCurrentOS() && (lastFocusedFrame = (instance = IdeFocusManager.findInstance()).getLastFocusedFrame()) instanceof IdeFrameEx && (fullScreen = ((IdeFrameEx)lastFocusedFrame).isInFullScreen())) {
            project.putUserData(IdeFrameImpl.SHOULD_OPEN_IN_FULL_SCREEN, (Object)Boolean.TRUE);
        }
        projectManager.openProject(project);
    }

    public static boolean isDirectGradleInvocationEnabled(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/util/Projects", "isDirectGradleInvocationEnabled"));
        }
        AndroidGradleBuildConfiguration buildConfiguration = AndroidGradleBuildConfiguration.getInstance(project);
        return buildConfiguration.USE_EXPERIMENTAL_FASTER_BUILD;
    }

    public static boolean isOfflineBuildModeEnabled(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/util/Projects", "isOfflineBuildModeEnabled"));
        }
        return GradleSettings.getInstance((Project)project).isOfflineWork();
    }

    public static boolean isGradleProject(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/util/Projects", "isGradleProject"));
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            AndroidFacet androidFacet = AndroidFacet.getInstance(module);
            if (androidFacet == null || !androidFacet.isGradleProject()) continue;
            return true;
        }
        return false;
    }

    public static boolean isIdeaAndroidProject(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/util/Projects", "isIdeaAndroidProject"));
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            if (AndroidFacet.getInstance(module) == null || AndroidGradleFacet.getInstance(module) != null) continue;
            return true;
        }
        return false;
    }

    public static void enforceExternalBuild(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/util/Projects", "enforceExternalBuild"));
        }
        if (Projects.isGradleProject(project)) {
            CompilerWorkspaceConfiguration workspaceConfiguration;
            boolean wasUsingExternalMake;
            if (!AndroidStudioSpecificInitializer.isAndroidStudio()) {
                AndroidGradleBuildConfiguration.getInstance((Project)project).USE_EXPERIMENTAL_FASTER_BUILD = false;
            }
            if (!(wasUsingExternalMake = (workspaceConfiguration = CompilerWorkspaceConfiguration.getInstance((Project)project)).useOutOfProcessBuild())) {
                String format = "Enabled 'External Build' for Android project '%1$s'. Otherwise, the project will not be built with Gradle";
                String msg = String.format(format, project.getName());
                LOG.info(msg);
                workspaceConfiguration.USE_OUT_OF_PROCESS_BUILD = true;
                MessageBus messageBus = project.getMessageBus();
                ((ExternalBuildOptionListener)messageBus.syncPublisher(ExternalBuildOptionListener.TOPIC)).externalBuildOptionChanged(true);
            }
        }
    }

    @NotNull
    public static Module[] getModulesToBuildFromSelection(@NotNull Project project, @Nullable DataContext dataContext) {
        Module[] modules;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/util/Projects", "getModulesToBuildFromSelection"));
        }
        if (dataContext == null) {
            ProjectView projectView = ProjectView.getInstance((Project)project);
            JComponent treeComponent = projectView.getCurrentProjectViewPane().getComponentToFocus();
            dataContext = DataManager.getInstance().getDataContext((Component)treeComponent);
        }
        if ((modules = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext)) != null) {
            if (modules.length == 1 && Projects.isProjectModule(project, modules[0])) {
                Module[] moduleArray = ModuleManager.getInstance((Project)project).getModules();
                if (moduleArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/Projects", "getModulesToBuildFromSelection"));
                }
                return moduleArray;
            }
            if (modules == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/Projects", "getModulesToBuildFromSelection"));
            }
            return modules;
        }
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        if (module != null) {
            Module[] moduleArray;
            if (Projects.isProjectModule(project, module)) {
                moduleArray = ModuleManager.getInstance((Project)project).getModules();
            } else {
                Module[] moduleArray2 = new Module[1];
                moduleArray = moduleArray2;
                moduleArray2[0] = module;
            }
            if (moduleArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/Projects", "getModulesToBuildFromSelection"));
            }
            return moduleArray;
        }
        if (NO_MODULES == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/Projects", "getModulesToBuildFromSelection"));
        }
        return NO_MODULES;
    }

    private static boolean isProjectModule(@NotNull Project project, @NotNull Module module) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/util/Projects", "isProjectModule"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/util/Projects", "isProjectModule"));
        }
        File moduleFilePath = new File(FileUtil.toSystemDependentName((String)module.getModuleFilePath()));
        File moduleRootDirPath = moduleFilePath.getParentFile();
        if (moduleRootDirPath == null) {
            return false;
        }
        return FileUtil.filesEqual((File)moduleRootDirPath, (File)new File(project.getBasePath())) && AndroidGradleFacet.getInstance(module) == null;
    }

    public static boolean isBuildWithGradle(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/util/Projects", "isBuildWithGradle"));
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            if (AndroidGradleFacet.getInstance(module) == null) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static Module findGradleProjectModule(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/util/Projects", "findGradleProjectModule"));
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        Module[] modules = moduleManager.getModules();
        if (modules.length == 1) {
            return modules[0];
        }
        for (Module module : modules) {
            if (!Projects.isGradleProjectModule(module)) continue;
            return module;
        }
        return null;
    }

    public static boolean isGradleProjectModule(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/util/Projects", "isGradleProjectModule"));
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance(module);
        if (androidFacet != null && androidFacet.isGradleProject()) {
            File moduleRootDirPath = new File(FileUtil.toSystemDependentName((String)module.getModuleFilePath())).getParentFile();
            return FileUtil.pathsEqual((String)moduleRootDirPath.getPath(), (String)module.getProject().getBasePath());
        }
        return AndroidGradleFacet.getInstance(module) == null;
    }

    @Nullable
    public static File getBuildFolderPath(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/util/Projects", "getBuildFolderPath"));
        }
        if (module.isDisposed() || !Projects.isGradleProject(module.getProject())) {
            return null;
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance(module);
        if (androidFacet != null && androidFacet.getIdeaAndroidProject() != null) {
            return androidFacet.getIdeaAndroidProject().getDelegate().getBuildFolder();
        }
        JavaGradleFacet javaFacet = JavaGradleFacet.getInstance(module);
        if (javaFacet != null) {
            JavaModel javaModel = javaFacet.getJavaModel();
            if (javaModel != null) {
                return javaFacet.getJavaModel().getBuildFolderPath();
            }
            String path = ((JavaGradleFacetConfiguration)javaFacet.getConfiguration()).BUILD_FOLDER_PATH;
            if (StringUtil.isNotEmpty((String)path)) {
                return new File(FileUtil.toSystemDependentName((String)path));
            }
        }
        return null;
    }
}

