/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.tools.idea.gradle.invoker.GradleInvocationResult;
import com.android.tools.idea.gradle.invoker.GradleInvoker;
import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.Projects;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class ProjectBuilder {
    @NotNull
    private final Project myProject;

    @NotNull
    public static ProjectBuilder getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/util/ProjectBuilder", "getInstance"));
        }
        ProjectBuilder projectBuilder = (ProjectBuilder)ServiceManager.getService((Project)project, ProjectBuilder.class);
        if (projectBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/ProjectBuilder", "getInstance"));
        }
        return projectBuilder;
    }

    public ProjectBuilder(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/util/ProjectBuilder", "<init>"));
        }
        this.myProject = project;
    }

    public void assembleTranslate() {
        if (Projects.isGradleProject(this.myProject)) {
            if (Projects.isDirectGradleInvocationEnabled(this.myProject)) {
                GradleInvoker.getInstance(this.myProject).assembleTranslate();
                return;
            }
            this.buildProjectWithJps(BuildMode.ASSEMBLE_TRANSLATE);
        }
    }

    public void compileJava() {
        if (Projects.isGradleProject(this.myProject)) {
            if (Projects.isDirectGradleInvocationEnabled(this.myProject)) {
                Module[] modules = ModuleManager.getInstance((Project)this.myProject).getModules();
                GradleInvoker.getInstance(this.myProject).compileJava(modules);
                return;
            }
            this.buildProjectWithJps(BuildMode.COMPILE_JAVA);
        }
    }

    public void clean() {
        if (Projects.isGradleProject(this.myProject)) {
            if (Projects.isDirectGradleInvocationEnabled(this.myProject)) {
                GradleInvoker.getInstance(this.myProject).cleanProject();
                return;
            }
            this.buildProjectWithJps(BuildMode.CLEAN);
        }
    }

    public void generateSourcesOnly() {
        if (Projects.isGradleProject(this.myProject)) {
            if (Projects.isDirectGradleInvocationEnabled(this.myProject)) {
                GradleInvoker.getInstance(this.myProject).generateSources();
                return;
            }
            this.buildProjectWithJps(BuildMode.SOURCE_GEN);
        }
    }

    private void buildProjectWithJps(@NotNull BuildMode buildMode) {
        if (buildMode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/util/ProjectBuilder", "buildProjectWithJps"));
        }
        BuildSettings.getInstance(this.myProject).setBuildMode(buildMode);
        CompilerManager.getInstance((Project)this.myProject).make(null);
    }

    public void addAfterProjectBuildTask(@NotNull AfterProjectBuildTask task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/util/ProjectBuilder", "addAfterProjectBuildTask"));
        }
        CompilerManager.getInstance((Project)this.myProject).addAfterTask((CompileTask)task);
        GradleInvoker.getInstance(this.myProject).addAfterGradleInvocationTask(task);
    }

    public static interface AfterProjectBuildTask
    extends CompileTask,
    GradleInvoker.AfterGradleInvocationTask {
    }

    public static abstract class AfterProjectBuildListener
    implements AfterProjectBuildTask {
        @Override
        public void execute(@NotNull GradleInvocationResult result) {
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/util/ProjectBuilder$AfterProjectBuildListener", "execute"));
            }
            this.buildFinished();
        }

        public boolean execute(CompileContext context) {
            this.buildFinished();
            return true;
        }

        protected abstract void buildFinished();
    }
}

