/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public final class FilePaths {
    private FilePaths() {
    }

    public static boolean isPathInContentEntry(@NotNull File path, @NotNull ContentEntry contentEntry) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/util/FilePaths", "isPathInContentEntry"));
        }
        if (contentEntry == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/util/FilePaths", "isPathInContentEntry"));
        }
        VirtualFile rootFile = contentEntry.getFile();
        if (rootFile == null) {
            return false;
        }
        File rootFilePath = VfsUtilCore.virtualToIoFile((VirtualFile)rootFile);
        return FileUtil.isAncestor((File)rootFilePath, (File)path, (boolean)false);
    }

    @NotNull
    public static String pathToIdeaUrl(@NotNull File path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/util/FilePaths", "pathToIdeaUrl"));
        }
        String string = VfsUtilCore.pathToUrl((String)FileUtil.toSystemIndependentName((String)path.getPath()));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/FilePaths", "pathToIdeaUrl"));
        }
        return string;
    }
}

