/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification;

import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.tools.idea.gradle.service.notification.DisableIdeProxySettingsHyperlink;
import com.android.tools.idea.gradle.service.notification.FileBugHyperlink;
import com.android.tools.idea.gradle.service.notification.FixBuildToolsVersionHyperlink;
import com.android.tools.idea.gradle.service.notification.FixGradleModelVersionHyperlink;
import com.android.tools.idea.gradle.service.notification.InstallBuildToolsHyperlink;
import com.android.tools.idea.gradle.service.notification.InstallPlatformHyperlink;
import com.android.tools.idea.gradle.service.notification.NotificationHyperlink;
import com.android.tools.idea.gradle.service.notification.OpenAndroidSdkManagerHyperlink;
import com.android.tools.idea.gradle.service.notification.OpenFileHyperlink;
import com.android.tools.idea.gradle.service.notification.OpenGradleSettingsHyperlink;
import com.android.tools.idea.gradle.service.notification.OpenHttpSettingsHyperlink;
import com.android.tools.idea.gradle.service.notification.OpenUrlHyperlink;
import com.android.tools.idea.gradle.service.notification.SearchInBuildFilesHyperlink;
import com.android.tools.idea.gradle.service.notification.ShowLogHyperlink;
import com.android.tools.idea.gradle.service.notification.ToggleOfflineModeHyperlink;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationExtension;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.net.HttpConfigurable;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleNotificationExtension
implements ExternalSystemNotificationExtension {
    private static final Logger LOG = Logger.getInstance(GradleNotificationExtension.class);
    public static final String FAILED_TO_SYNC_GRADLE_PROJECT_ERROR_GROUP_FORMAT = "Failed to sync Gradle project '%1$s'";
    private static final Pattern ERROR_LOCATION_IN_FILE_PATTERN = Pattern.compile("Build file '(.*)' line: ([\\d]+)");
    private static final Pattern ERROR_IN_FILE_PATTERN = Pattern.compile("Build file '(.*)'");
    private static final Pattern MISSING_DEPENDENCY_PATTERN = Pattern.compile("Could not find (.*)\\.");
    private static final Pattern MISSING_MATCHING_DEPENDENCY_PATTERN = Pattern.compile("Could not find any version that matches (.*)\\.");
    private static final Pattern UNKNOWN_HOST_PATTERN = Pattern.compile("Unknown host '(.*)'(.*)");
    private static final Pattern SDK_BUILD_TOOLS_TOO_LOW_PATTERN = Pattern.compile("The SDK Build Tools revision \\((.*)\\) is too low for project '(.*)'. Minimum required is (.*)");
    private static final Pattern MISSING_PLATFORM_PATTERN_1 = Pattern.compile("(Cause: )?failed to find target (.*) : (.*)");
    private static final Pattern MISSING_PLATFORM_PATTERN_2 = Pattern.compile("(Cause: )?failed to find target (.*)");
    private static final Pattern MISSING_BUILD_TOOLS_PATTERN = Pattern.compile("(Cause: )?failed to find Build Tools revision (.*)");
    private static final NotificationType DEFAULT_NOTIFICATION_TYPE = NotificationType.ERROR;

    @NotNull
    public ProjectSystemId getTargetExternalSystemId() {
        ProjectSystemId projectSystemId = GradleConstants.SYSTEM_ID;
        if (projectSystemId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/service/notification/GradleNotificationExtension", "getTargetExternalSystemId"));
        }
        return projectSystemId;
    }

    public void customize(@NotNull NotificationData notification, @NotNull Project project, @Nullable Throwable error) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/service/notification/GradleNotificationExtension", "customize"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/service/notification/GradleNotificationExtension", "customize"));
        }
        Throwable cause = error;
        if (error instanceof UndeclaredThrowableException && (cause = ((UndeclaredThrowableException)error).getUndeclaredThrowable()) instanceof InvocationTargetException) {
            cause = ((InvocationTargetException)cause).getTargetException();
        }
        if (cause instanceof ExternalSystemException) {
            GradleNotificationExtension.updateNotification(notification, project, (ExternalSystemException)cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void updateNotification(@NotNull NotificationData notification, @NotNull Project project, @NotNull ExternalSystemException error) {
        block55: {
            if (notification == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", new Object[]{"0", "com/android/tools/idea/gradle/service/notification/GradleNotificationExtension", "updateNotification"}));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", new Object[]{"1", "com/android/tools/idea/gradle/service/notification/GradleNotificationExtension", "updateNotification"}));
            }
            if (error == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", new Object[]{"2", "com/android/tools/idea/gradle/service/notification/GradleNotificationExtension", "updateNotification"}));
            }
            msg = error.getMessage();
            if (msg == null) return;
            if (msg.isEmpty() != false) return;
            if (msg.startsWith("Unable to find 'build folder for project")) {
                GradleNotificationExtension.updateNotification(notification, project, msg, new NotificationHyperlink[]{new OpenUrlHyperlink("https://code.google.com/p/android/issues/detail?id=70490", "Open bug report")});
            }
            if (msg.startsWith("The project is using an unsupported version of the Android Gradle plug-in")) {
                fixGradleModelHyperlink = msg.contains("Please read the migration guide") != false ? new FixGradleModelVersionHyperlink() : new FixGradleModelVersionHyperlink("Fix plug-in version and re-import project", false);
                GradleNotificationExtension.updateNotification(notification, project, msg, new NotificationHyperlink[]{fixGradleModelHyperlink});
                return;
            }
            if (msg.contains("failed to parse SDK")) {
                pathOfBrokenSdk = GradleNotificationExtension.findPathOfSdkMissingOrEmptyAddonsFolder(project);
                if (pathOfBrokenSdk != null) {
                    newMsg = String.format("The directory '%1$s', in the Android SDK at '%2$s', is either missing or empty", new Object[]{"add-ons", pathOfBrokenSdk});
                    sdkHomeDir = new File(pathOfBrokenSdk);
                    if (!sdkHomeDir.canWrite()) {
                        format = "\n\nCurrent user (%1$s) does not have write access to the SDK directory.";
                        newMsg = newMsg + String.format(format, new Object[]{SystemProperties.getUserName()});
                    }
                } else {
                    newMsg = GradleNotificationExtension.splitLines(msg).get(0);
                }
                GradleNotificationExtension.updateNotification(notification, project, newMsg, new NotificationHyperlink[0]);
                return;
            }
            lines = GradleNotificationExtension.splitLines(msg);
            lastLine = lines.get(lines.size() - 1);
            if ("Please fix the project's Gradle settings.".equals(lastLine)) {
                GradleNotificationExtension.updateNotification(notification, project, msg, new NotificationHyperlink[]{new OpenGradleSettingsHyperlink()});
                return;
            }
            if (!"Please fix the 'sdk.dir' property in the local.properties file.".equals(lastLine) || !(file = new File(project.getBasePath(), "local.properties")).isFile()) break block55;
            reader = null;
            try {
                reader = new BufferedReader(new FileReader(file));
                counter = 0;
lbl38:
                // 2 sources

                while ((line = reader.readLine()) != null) {
                    if (!line.startsWith("sdk.dir")) ** GOTO lbl-1000
                    GradleNotificationExtension.updateNotification(notification, project, msg, new NotificationHyperlink[]{new OpenFileHyperlink(file.getPath(), counter)});
                    ** GOTO lbl54
                }
                ** GOTO lbl62
            }
            catch (IOException e) {
                try {
                    GradleNotificationExtension.LOG.info("Unable to read file: " + file.getPath(), (Throwable)e);
                }
                catch (Throwable var11_25) {
                    try {
                        Closeables.close(reader, (boolean)true);
                        throw var11_25;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    throw var11_25;
                }
lbl54:
                // 1 sources

                try {
                    Closeables.close((Closeable)reader, (boolean)true);
                    return;
                }
                catch (IOException e) {
                    // empty catch block
                }
                return;
lbl-1000:
                // 1 sources

                {
                    ++counter;
                    ** GOTO lbl38
                }
lbl62:
                // 1 sources

                try {
                    Closeables.close((Closeable)reader, (boolean)true);
                }
                catch (IOException e) {}
                try {
                    Closeables.close((Closeable)reader, (boolean)true);
                }
                catch (IOException e) {}
            }
            GradleNotificationExtension.updateNotification(notification, project, msg, new NotificationHyperlink[]{new OpenFileHyperlink(file.getPath(), 0)});
            return;
        }
        if (lastLine.contains("Please install the Android Support Repository from the Android SDK Manager.")) {
            facets = ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID);
            if (!facets.isEmpty()) {
                GradleNotificationExtension.updateNotification(notification, project, msg, new NotificationHyperlink[]{new OpenAndroidSdkManagerHyperlink()});
                return;
            }
            GradleNotificationExtension.updateNotification(notification, project, msg, new NotificationHyperlink[0]);
            return;
        }
        if (lastLine.contains("Please point to a supported Gradle version in the project's Gradle settings or in the project's Gradle wrapper (if applicable.)")) {
            hyperlinks = Lists.newArrayList();
            wrapperPropertiesFile = GradleUtil.findWrapperPropertiesFile(project);
            if (wrapperPropertiesFile != null) {
                hyperlink = new FixGradleModelVersionHyperlink("Fix Gradle wrapper and re-import project", false);
                hyperlinks.add(hyperlink);
            }
            hyperlinks.add(new OpenGradleSettingsHyperlink());
            GradleNotificationExtension.updateNotification(notification, project, msg, hyperlinks);
            return;
        }
        firstLine = lines.get(0);
        matcher = GradleNotificationExtension.SDK_BUILD_TOOLS_TOO_LOW_PATTERN.matcher(firstLine);
        if (matcher.matches()) {
            buildToolInstalled = false;
            minimumVersion = matcher.group(3);
            localAndroidSdk = null;
            androidSdkData = AndroidSdkUtils.tryToChooseAndroidSdk();
            if (androidSdkData != null) {
                localAndroidSdk = androidSdkData.getLocalSdk();
            }
            if (localAndroidSdk != null) {
                buildTool = localAndroidSdk.getBuildTool(FullRevision.parseRevision((String)minimumVersion));
                v0 = buildToolInstalled = buildTool != null;
            }
            if ((module = GradleUtil.findModuleByGradlePath(project, gradlePath = matcher.group(2))) != null) {
                buildFile = GradleUtil.getGradleBuildFile(module);
                hyperlinks = Lists.newArrayList();
                if (!buildToolInstalled) {
                    hyperlinks.add(new InstallBuildToolsHyperlink(minimumVersion, buildFile));
                } else if (buildFile != null) {
                    hyperlinks.add(new FixBuildToolsVersionHyperlink(buildFile, minimumVersion));
                }
                if (buildFile != null) {
                    hyperlinks.add(new OpenFileHyperlink(buildFile.getPath()));
                }
                if (!hyperlinks.isEmpty()) {
                    GradleNotificationExtension.updateNotification(notification, project, msg, hyperlinks);
                    return;
                }
            }
        }
        if (!(missingPlatform = (matcher = GradleNotificationExtension.MISSING_PLATFORM_PATTERN_1.matcher(firstLine)).matches())) {
            matcher = GradleNotificationExtension.MISSING_PLATFORM_PATTERN_2.matcher(firstLine);
            missingPlatform = matcher.matches();
        }
        if (missingPlatform) {
            hyperlinks = Lists.newArrayList();
            platform = matcher.group(2);
            localAndroidSdk = null;
            androidSdkData = AndroidSdkUtils.tryToChooseAndroidSdk();
            if (androidSdkData != null) {
                localAndroidSdk = androidSdkData.getLocalSdk();
            }
            if (localAndroidSdk != null && (version = AndroidTargetHash.getPlatformVersion((String)platform)) != null && localAndroidSdk.getPkgInfo(PkgType.PKG_PLATFORM, version) == null) {
                hyperlinks.add(new InstallPlatformHyperlink(new AndroidVersion[]{version}));
            }
            if (hyperlinks.isEmpty() && !(facets = ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID)).isEmpty()) {
                hyperlinks.add(new OpenAndroidSdkManagerHyperlink());
            }
            GradleNotificationExtension.updateNotification(notification, project, msg, hyperlinks);
            return;
        }
        matcher = GradleNotificationExtension.MISSING_BUILD_TOOLS_PATTERN.matcher(firstLine);
        if (matcher.matches()) {
            version = matcher.group(2);
            hyperlink = new InstallBuildToolsHyperlink(version, null);
            GradleNotificationExtension.updateNotification(notification, project, msg, new NotificationHyperlink[]{hyperlink});
        }
        if ((matcher = GradleNotificationExtension.UNKNOWN_HOST_PATTERN.matcher(firstLine)).matches()) {
            hyperlinks = Lists.newArrayList();
            httpSettings = HttpConfigurable.getInstance();
            host = matcher.group(1);
            if (httpSettings.USE_HTTP_PROXY && Objects.equal((Object)host, (Object)httpSettings.PROXY_HOST)) {
                hyperlinks.add(new DisableIdeProxySettingsHyperlink());
                hyperlinks.add(new OpenHttpSettingsHyperlink());
            }
            if ((enableOfflineMode = ToggleOfflineModeHyperlink.enableOfflineMode(project)) != null) {
                hyperlinks.add(enableOfflineMode);
            }
            gradleDocsUrl = "http://www.gradle.org/docs/current/userguide/userguide_single.html#sec:accessing_the_web_via_a_proxy";
            hyperlinks.add(new OpenUrlHyperlink(gradleDocsUrl, "Learn about configuring HTTP proxies in Gradle"));
            GradleNotificationExtension.updateNotification(notification, project, msg, hyperlinks);
            return;
        }
        if (GradleNotificationExtension.isInternetConnectionError(firstLine)) {
            hyperlinks = Lists.newArrayList();
            enableOfflineMode = ToggleOfflineModeHyperlink.enableOfflineMode(project);
            if (enableOfflineMode != null) {
                hyperlinks.add(enableOfflineMode);
            }
            GradleNotificationExtension.updateNotification(notification, project, msg, hyperlinks);
            return;
        }
        if (firstLine.startsWith("No cached version of ") && firstLine.contains("available for offline mode.")) {
            hyperlinks = Lists.newArrayList();
            disableOfflineMode = ToggleOfflineModeHyperlink.disableOfflineMode(project);
            if (disableOfflineMode != null) {
                hyperlinks.add(disableOfflineMode);
            }
            GradleNotificationExtension.updateNotification(notification, project, firstLine, hyperlinks);
            return;
        }
        matcher = GradleNotificationExtension.MISSING_MATCHING_DEPENDENCY_PATTERN.matcher(firstLine);
        if (matcher.matches()) {
            dependency = matcher.group(1);
            GradleNotificationExtension.createMissingDependencyNotification(notification, project, firstLine, dependency, new NotificationHyperlink[0]);
            return;
        }
        matcher = GradleNotificationExtension.MISSING_DEPENDENCY_PATTERN.matcher(firstLine);
        if (matcher.matches() && lines.size() > 1 && lines.get(1).startsWith("Required by:") && !Strings.isNullOrEmpty((String)(dependency = matcher.group(1)))) {
            if (lastLine != null && (errorLocation = GradleNotificationExtension.getErrorLocation(lastLine)) != null) {
                filePath = (String)errorLocation.getFirst();
                line = (Integer)errorLocation.getSecond();
                GradleNotificationExtension.createMissingDependencyNotification(notification, project, msg, dependency, new NotificationHyperlink[]{new OpenFileHyperlink(filePath, line - 1)});
                return;
            }
            GradleNotificationExtension.createMissingDependencyNotification(notification, project, msg, dependency, new NotificationHyperlink[0]);
            return;
        }
        for (String line : lines) {
            if (line == null || !(matcher = GradleNotificationExtension.MISSING_MATCHING_DEPENDENCY_PATTERN.matcher(line)).matches()) continue;
            dependency = matcher.group(1);
            GradleNotificationExtension.createMissingDependencyNotification(notification, project, line, dependency, new NotificationHyperlink[0]);
            return;
        }
        if (lastLine == null) return;
        if (lastLine.contains("This is an unexpected error. Please file a bug containing the idea.log file.")) {
            GradleNotificationExtension.updateNotification(notification, project, msg, new NotificationHyperlink[]{new FileBugHyperlink(), new ShowLogHyperlink()});
            return;
        }
        errorLocation = GradleNotificationExtension.getErrorLocation(lastLine);
        if (errorLocation == null) return;
        filePath = (String)errorLocation.getFirst();
        line = (Integer)errorLocation.getSecond();
        GradleNotificationExtension.updateNotification(notification, project, msg, new NotificationHyperlink[]{new OpenFileHyperlink(filePath, line - 1)});
    }

    private static void createMissingDependencyNotification(@NotNull NotificationData notification, @NotNull Project project, @NotNull String msg, @NotNull String dependency, NotificationHyperlink ... additionalHyperlinks) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/service/notification/GradleNotificationExtension", "createMissingDependencyNotification"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/service/notification/GradleNotificationExtension", "createMissingDependencyNotification"));
        }
        if (msg == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/gradle/service/notification/GradleNotificationExtension", "createMissingDependencyNotification"));
        }
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/android/tools/idea/gradle/service/notification/GradleNotificationExtension", "createMissingDependencyNotification"));
        }
        if (additionalHyperlinks == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/android/tools/idea/gradle/service/notification/GradleNotificationExtension", "createMissingDependencyNotification"));
        }
        ArrayList hyperlinks = Lists.newArrayList((Object[])additionalHyperlinks);
        ToggleOfflineModeHyperlink disableOfflineMode = ToggleOfflineModeHyperlink.disableOfflineMode(project);
        if (disableOfflineMode != null) {
            hyperlinks.add(0, disableOfflineMode);
        }
        hyperlinks.add(new SearchInBuildFilesHyperlink(dependency));
        GradleNotificationExtension.updateNotification(notification, project, msg, hyperlinks);
    }

    @Nullable
    private static Pair<String, Integer> getErrorLocation(@NotNull String msg) {
        if (msg == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/service/notification/GradleNotificationExtension", "getErrorLocation"));
        }
        Matcher matcher = ERROR_LOCATION_IN_FILE_PATTERN.matcher(msg);
        if (matcher.matches()) {
            String filePath = matcher.group(1);
            int line = -1;
            try {
                line = Integer.parseInt(matcher.group(2));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            return Pair.create((Object)filePath, (Object)line);
        }
        matcher = ERROR_IN_FILE_PATTERN.matcher(msg);
        if (matcher.matches()) {
            String filePath = matcher.group(1);
            return Pair.create((Object)filePath, (Object)-1);
        }
        return null;
    }

    @Nullable
    private static String findPathOfSdkMissingOrEmptyAddonsFolder(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/service/notification/GradleNotificationExtension", "findPathOfSdkMissingOrEmptyAddonsFolder"));
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            String sdkHomeDirPath;
            File addonsDir;
            Sdk moduleSdk = ModuleRootManager.getInstance((Module)module).getSdk();
            if (moduleSdk == null || !AndroidSdkUtils.isAndroidSdk(moduleSdk) || (addonsDir = new File(sdkHomeDirPath = moduleSdk.getHomePath(), "add-ons")).isDirectory() && FileUtil.notNullize((File[])addonsDir.listFiles()).length != 0) continue;
            return sdkHomeDirPath;
        }
        return null;
    }

    @NotNull
    private static List<String> splitLines(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/service/notification/GradleNotificationExtension", "splitLines"));
        }
        ArrayList arrayList = Lists.newArrayList((Iterable)Splitter.on((char)'\n').split((CharSequence)s));
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/service/notification/GradleNotificationExtension", "splitLines"));
        }
        return arrayList;
    }

    private static void updateNotification(@NotNull NotificationData notification, @NotNull Project project, @NotNull String errorMsg, @NotNull List<NotificationHyperlink> hyperlinks) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/service/notification/GradleNotificationExtension", "updateNotification"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/service/notification/GradleNotificationExtension", "updateNotification"));
        }
        if (errorMsg == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/gradle/service/notification/GradleNotificationExtension", "updateNotification"));
        }
        if (hyperlinks == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/android/tools/idea/gradle/service/notification/GradleNotificationExtension", "updateNotification"));
        }
        GradleNotificationExtension.updateNotification(notification, project, errorMsg, hyperlinks.toArray(new NotificationHyperlink[hyperlinks.size()]));
    }

    private static boolean isInternetConnectionError(@NotNull String msg) {
        if (msg == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/service/notification/GradleNotificationExtension", "isInternetConnectionError"));
        }
        return msg.startsWith("Could not GET ") || msg.startsWith("Could not HEAD ") || msg.startsWith("Network is unreachable");
    }

    @VisibleForTesting
    static void updateNotification(@NotNull NotificationData notification, @NotNull Project project, @NotNull String errorMsg, NotificationHyperlink ... hyperlinks) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/service/notification/GradleNotificationExtension", "updateNotification"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/service/notification/GradleNotificationExtension", "updateNotification"));
        }
        if (errorMsg == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/gradle/service/notification/GradleNotificationExtension", "updateNotification"));
        }
        if (hyperlinks == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/android/tools/idea/gradle/service/notification/GradleNotificationExtension", "updateNotification"));
        }
        String title = String.format(FAILED_TO_SYNC_GRADLE_PROJECT_ERROR_GROUP_FORMAT, project.getName());
        GradleNotificationExtension.updateNotification(notification, project, title, errorMsg, hyperlinks);
    }

    public static void updateNotification(@NotNull NotificationData notification, final @NotNull Project project, @NotNull String title, @NotNull String errorMsg, NotificationHyperlink ... hyperlinks) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/service/notification/GradleNotificationExtension", "updateNotification"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/service/notification/GradleNotificationExtension", "updateNotification"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/gradle/service/notification/GradleNotificationExtension", "updateNotification"));
        }
        if (errorMsg == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/android/tools/idea/gradle/service/notification/GradleNotificationExtension", "updateNotification"));
        }
        if (hyperlinks == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/android/tools/idea/gradle/service/notification/GradleNotificationExtension", "updateNotification"));
        }
        String text = errorMsg;
        int hyperlinkCount = hyperlinks.length;
        if (hyperlinkCount > 0) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < hyperlinkCount; ++i) {
                b.append(hyperlinks[i].toString());
                if (i >= hyperlinkCount - 1) continue;
                b.append("<br>");
            }
            text = text + '\n' + b.toString();
        }
        notification.setTitle(title);
        notification.setMessage(text);
        notification.setNotificationCategory(NotificationCategory.convert((NotificationType)DEFAULT_NOTIFICATION_TYPE));
        for (final NotificationHyperlink hyperlink : hyperlinks) {
            notification.setListener(hyperlink.getUrl(), (NotificationListener)new NotificationListener.Adapter(){

                protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                    if (notification == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/service/notification/GradleNotificationExtension$1", "hyperlinkActivated"));
                    }
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/service/notification/GradleNotificationExtension$1", "hyperlinkActivated"));
                    }
                    hyperlink.executeIfClicked(project, e);
                }
            });
        }
    }
}

