/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification;

import com.android.tools.idea.gradle.service.notification.NotificationHyperlink;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.openapi.externalSystem.service.notification.EditableNotificationMessageElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FixGradleVersionInWrapperHyperlink
extends NotificationHyperlink {
    @NotNull
    private final File myWrapperPropertiesFile;
    @NotNull
    private final String myGradleVersion;

    @Nullable
    static NotificationHyperlink createIfProjectUsesGradleWrapper(@NotNull Project project, @NotNull String supportedGradleVersion) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/service/notification/FixGradleVersionInWrapperHyperlink", "createIfProjectUsesGradleWrapper"));
        }
        if (supportedGradleVersion == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/service/notification/FixGradleVersionInWrapperHyperlink", "createIfProjectUsesGradleWrapper"));
        }
        File wrapperPropertiesFile = GradleUtil.findWrapperPropertiesFile(project);
        if (wrapperPropertiesFile != null) {
            return new FixGradleVersionInWrapperHyperlink(wrapperPropertiesFile, supportedGradleVersion);
        }
        return null;
    }

    private FixGradleVersionInWrapperHyperlink(@NotNull File wrapperPropertiesFile, @NotNull String gradleVersion) {
        if (wrapperPropertiesFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/service/notification/FixGradleVersionInWrapperHyperlink", "<init>"));
        }
        if (gradleVersion == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/service/notification/FixGradleVersionInWrapperHyperlink", "<init>"));
        }
        super("fixGradleVersionInWrapper", "Fix Gradle wrapper and re-import project");
        this.myWrapperPropertiesFile = wrapperPropertiesFile;
        this.myGradleVersion = gradleVersion;
    }

    @Override
    protected void execute(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/service/notification/FixGradleVersionInWrapperHyperlink", "execute"));
        }
        FixGradleVersionInWrapperHyperlink.updateGradleVersion(project, this.myWrapperPropertiesFile, this.myGradleVersion);
    }

    @Override
    public boolean executeIfClicked(@NotNull Project project, @NotNull HyperlinkEvent event) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/service/notification/FixGradleVersionInWrapperHyperlink", "executeIfClicked"));
        }
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/service/notification/FixGradleVersionInWrapperHyperlink", "executeIfClicked"));
        }
        boolean updated = FixGradleVersionInWrapperHyperlink.updateGradleVersion(project, this.myWrapperPropertiesFile, this.myGradleVersion);
        if (updated) {
            EditableNotificationMessageElement.disableLink((HyperlinkEvent)event);
        }
        return updated;
    }

    static boolean updateGradleVersion(@NotNull Project project, @NotNull File wrapperPropertiesFile, @NotNull String gradleVersion) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/service/notification/FixGradleVersionInWrapperHyperlink", "updateGradleVersion"));
        }
        if (wrapperPropertiesFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/service/notification/FixGradleVersionInWrapperHyperlink", "updateGradleVersion"));
        }
        if (gradleVersion == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/gradle/service/notification/FixGradleVersionInWrapperHyperlink", "updateGradleVersion"));
        }
        try {
            boolean updated = GradleUtil.updateGradleDistributionUrl(gradleVersion, wrapperPropertiesFile);
            if (updated) {
                VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)wrapperPropertiesFile, (boolean)true);
                if (virtualFile != null) {
                    virtualFile.refresh(false, false);
                }
                return true;
            }
        }
        catch (IOException e) {
            String msg = String.format("Unable to update Gradle wrapper to use Gradle %1$s\n", gradleVersion);
            msg = msg + e.getMessage();
            Messages.showErrorDialog((Project)project, (String)msg, (String)"Quick Fix Failed");
        }
        return false;
    }
}

