/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification;

import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.gradle.project.AndroidGradleNotification;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.service.notification.FixGradleVersionInWrapperHyperlink;
import com.android.tools.idea.gradle.service.notification.NotificationHyperlink;
import com.android.tools.idea.gradle.service.notification.SearchInBuildFilesHyperlink;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;

class FixGradleModelVersionHyperlink
extends NotificationHyperlink {
    private final boolean myOpenMigrationGuide;

    FixGradleModelVersionHyperlink() {
        this("Open migration guide, fix plug-in version and sync project", true);
    }

    FixGradleModelVersionHyperlink(@NotNull String text, boolean openMigrationGuide) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/service/notification/FixGradleModelVersionHyperlink", "<init>"));
        }
        super("fixGradleElements", text);
        this.myOpenMigrationGuide = openMigrationGuide;
    }

    @Override
    protected void execute(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/service/notification/FixGradleModelVersionHyperlink", "execute"));
        }
        if (this.myOpenMigrationGuide) {
            BrowserUtil.browse((String)"http://tools.android.com/tech-docs/new-build-system/migrating_to_09");
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        boolean atLeastOnUpdated = false;
        for (Module module : moduleManager.getModules()) {
            GradleBuildFile buildFile;
            Object pluginVersion;
            VirtualFile file = GradleUtil.getGradleBuildFile(module);
            if (file == null || (pluginVersion = (buildFile = new GradleBuildFile(file, project)).getValue(BuildFileKey.PLUGIN_VERSION)) == null) continue;
            WriteCommandAction.runWriteCommandAction((Project)project, (Runnable)new Runnable(){

                @Override
                public void run() {
                    buildFile.setValue(BuildFileKey.PLUGIN_VERSION, "0.12.2");
                }
            });
            atLeastOnUpdated = true;
        }
        if (!atLeastOnUpdated) {
            String msg = "Unable to find any references to the Android Gradle plug-in in build.gradle files.\n\nPlease click the link to perform a textual search and then update the build files manually.";
            SearchInBuildFilesHyperlink hyperlink = new SearchInBuildFilesHyperlink("com.android.tools.build:gradle");
            AndroidGradleNotification.getInstance(project).showBalloon("Quick Fix Failed", msg, NotificationType.ERROR, hyperlink);
            return;
        }
        File wrapperPropertiesFile = GradleUtil.findWrapperPropertiesFile(project);
        if (wrapperPropertiesFile != null) {
            FixGradleVersionInWrapperHyperlink.updateGradleVersion(project, wrapperPropertiesFile, "1.12");
        }
        GradleProjectImporter.getInstance().requestProjectSync(project, null);
    }
}

