/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification;

import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.service.notification.NotificationHyperlink;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.project.Project;
import com.intellij.util.net.HttpConfigurable;
import org.jetbrains.annotations.NotNull;

class DisableIdeProxySettingsHyperlink
extends NotificationHyperlink {
    DisableIdeProxySettingsHyperlink() {
        super("disable.proxy.settings", "Disable the IDE's proxy settings and sync project");
    }

    @Override
    protected void execute(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/service/notification/DisableIdeProxySettingsHyperlink", "execute"));
        }
        DisableIdeProxySettingsHyperlink.disableProxySettings(HttpConfigurable.getInstance());
        GradleProjectImporter.getInstance().requestProjectSync(project, null);
    }

    @VisibleForTesting
    static void disableProxySettings(@NotNull HttpConfigurable proxySettings) {
        if (proxySettings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/service/notification/DisableIdeProxySettingsHyperlink", "disableProxySettings"));
        }
        proxySettings.USE_HTTP_PROXY = false;
    }
}

