/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification;

import com.android.tools.idea.gradle.service.notification.NotificationHyperlink;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.project.Project;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class CustomNotificationListener
extends NotificationListener.Adapter {
    @NotNull
    private final Project myProject;
    @NotNull
    private final NotificationHyperlink[] myHyperlinks;

    public CustomNotificationListener(@NotNull Project project, NotificationHyperlink ... hyperlinks) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/service/notification/CustomNotificationListener", "<init>"));
        }
        if (hyperlinks == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/service/notification/CustomNotificationListener", "<init>"));
        }
        this.myProject = project;
        this.myHyperlinks = hyperlinks;
    }

    protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/service/notification/CustomNotificationListener", "hyperlinkActivated"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/service/notification/CustomNotificationListener", "hyperlinkActivated"));
        }
        for (NotificationHyperlink hyperlink : this.myHyperlinks) {
            if (!hyperlink.executeIfClicked(this.myProject, e)) continue;
            return;
        }
    }

    @NotNull
    NotificationHyperlink[] getHyperlinks() {
        if (this.myHyperlinks == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/service/notification/CustomNotificationListener", "getHyperlinks"));
        }
        return this.myHyperlinks;
    }
}

