/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.project.ChooseSdkPathDialog;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.sdk.DefaultSdks;
import com.android.tools.idea.sdk.SelectSdkDialog;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SdkSync {
    private static final String ERROR_DIALOG_TITLE = "Sync Android SDKs";

    private SdkSync() {
    }

    public static void syncIdeAndProjectAndroidHomes(@NotNull LocalProperties localProperties) {
        if (localProperties == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/SdkSync", "syncIdeAndProjectAndroidHomes"));
        }
        SdkSync.syncIdeAndProjectAndroidHomes(localProperties, new FindValidSdkPathTask());
    }

    @VisibleForTesting
    static void syncIdeAndProjectAndroidHomes(final @NotNull LocalProperties localProperties, @NotNull FindValidSdkPathTask findSdkPathTask) {
        if (localProperties == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/SdkSync", "syncIdeAndProjectAndroidHomes"));
        }
        if (findSdkPathTask == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/project/SdkSync", "syncIdeAndProjectAndroidHomes"));
        }
        if (localProperties.hasAndroidDirProperty()) {
            return;
        }
        final File androidHomePath = DefaultSdks.getDefaultAndroidHome();
        final File projectAndroidHomePath = localProperties.getAndroidSdkPath();
        if (androidHomePath != null) {
            if (projectAndroidHomePath == null) {
                SdkSync.setProjectSdk(localProperties, androidHomePath);
                return;
            }
            if (!DefaultSdks.isValidAndroidSdkPath(projectAndroidHomePath)) {
                UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!ApplicationManager.getApplication().isUnitTestMode()) {
                            String format = "The path\n'%1$s'\ndoes not refer to an Android SDK.\n\nAndroid Studio will use its default SDK instead:\n'%2$s'\nand will modify the project's local.properties file.";
                            Messages.showErrorDialog((String)String.format(format, projectAndroidHomePath, androidHomePath.getPath()), (String)SdkSync.ERROR_DIALOG_TITLE);
                        }
                        SdkSync.setProjectSdk(localProperties, androidHomePath);
                    }
                });
                return;
            }
        } else {
            if (projectAndroidHomePath == null || !DefaultSdks.isValidAndroidSdkPath(projectAndroidHomePath)) {
                File selectedPath = findSdkPathTask.selectValidSdkPath();
                if (selectedPath == null) {
                    throw new ExternalSystemException("Unable to continue until an Android SDK is specified");
                }
                SdkSync.setIdeSdk(selectedPath, localProperties);
                return;
            }
            SdkSync.setIdeSdk(projectAndroidHomePath, localProperties);
            return;
        }
        if (!FileUtil.filesEqual((File)androidHomePath, (File)projectAndroidHomePath)) {
            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    ChooseSdkPathDialog dialog = new ChooseSdkPathDialog(androidHomePath, projectAndroidHomePath);
                    dialog.show();
                    switch (dialog.getExitCode()) {
                        case 3: {
                            SdkSync.setProjectSdk(localProperties, androidHomePath);
                            break;
                        }
                        case 4: {
                            SdkSync.setIdeSdk(projectAndroidHomePath, localProperties);
                        }
                    }
                }
            });
        }
    }

    private static void setIdeSdk(final @NotNull File projectAndroidHomePath, @NotNull LocalProperties localProperties) {
        if (projectAndroidHomePath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/SdkSync", "setIdeSdk"));
        }
        if (localProperties == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/project/SdkSync", "setIdeSdk"));
        }
        SdkSync.setProjectSdk(localProperties, projectAndroidHomePath);
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        DefaultSdks.setDefaultAndroidHome(projectAndroidHomePath);
                    }
                });
            }
        });
    }

    private static void setProjectSdk(@NotNull LocalProperties localProperties, @NotNull File androidHomePath) {
        if (localProperties == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/SdkSync", "setProjectSdk"));
        }
        if (androidHomePath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/project/SdkSync", "setProjectSdk"));
        }
        if (FileUtil.filesEqual((File)localProperties.getAndroidSdkPath(), (File)androidHomePath)) {
            return;
        }
        localProperties.setAndroidSdkPath(androidHomePath);
        try {
            localProperties.save();
        }
        catch (IOException e) {
            String msg = String.format("Unable to save '%1$s'", localProperties.getFilePath().getPath());
            throw new ExternalSystemException(msg, (Throwable)e, new String[0]);
        }
    }

    @VisibleForTesting
    static class FindValidSdkPathTask {
        FindValidSdkPathTask() {
        }

        @Nullable
        File selectValidSdkPath() {
            final AtomicReference pathRef = new AtomicReference();
            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    FindValidSdkPathTask.findValidSdkPath(pathRef);
                }
            });
            return (File)pathRef.get();
        }

        private static void findValidSdkPath(@NotNull AtomicReference<File> pathRef) {
            if (pathRef == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/SdkSync$FindValidSdkPathTask", "findValidSdkPath"));
            }
            Sdk jdk = DefaultSdks.getDefaultJdk();
            String jdkPath = jdk != null ? jdk.getHomePath() : null;
            SelectSdkDialog dialog = new SelectSdkDialog(jdkPath, null);
            dialog.setModal(true);
            if (!dialog.showAndGet()) {
                String msg = "An Android SDK is needed to continue. Would you like to try again?";
                int result = Messages.showYesNoDialog((String)msg, (String)SdkSync.ERROR_DIALOG_TITLE, null);
                if (result == 0) {
                    FindValidSdkPathTask.findValidSdkPath(pathRef);
                }
                return;
            }
            File path = new File(dialog.getAndroidHome());
            if (!DefaultSdks.isValidAndroidSdkPath(path)) {
                String format = "The path\n'%1$s'\ndoes not refer to a valid Android SDK. Would you like to try again?";
                int result = Messages.showYesNoDialog((String)String.format(format, path.getPath()), (String)SdkSync.ERROR_DIALOG_TITLE, null);
                if (result == 0) {
                    FindValidSdkPathTask.findValidSdkPath(pathRef);
                }
                return;
            }
            pathRef.set(path);
        }
    }
}

