/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.annotations.NonNull;
import com.android.tools.idea.gradle.messages.Message;
import com.android.tools.idea.gradle.messages.ProjectSyncMessages;
import com.android.tools.idea.gradle.service.notification.NotificationHyperlink;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.LintRequest;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Severity;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Processor;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.inspections.lint.IntellijLintClient;
import org.jetbrains.android.inspections.lint.IntellijLintIssueRegistry;
import org.jetbrains.android.inspections.lint.IntellijLintRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectValidator {
    public static final Key<List<Message>> VALIDATION_MESSAGES = Key.create((String)"gradle.validation.messages");
    private static final Set<String> FILES_TO_PROCESS = ImmutableSet.of((Object)"settings.gradle", (Object)"build.gradle", (Object)"local.properties", (Object)"gradle-wrapper.properties");

    private ProjectValidator() {
    }

    public static boolean validate(@NotNull Project project, @NotNull File rootDir) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/ProjectValidator", "validate"));
        }
        if (rootDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/project/ProjectValidator", "validate"));
        }
        VirtualFile file = VfsUtil.findFileByIoFile((File)rootDir, (boolean)true);
        if (file == null) {
            return false;
        }
        VirtualFile rootDirectory = file.isDirectory() ? file : file.getParent();
        final ArrayList files = Lists.newArrayList();
        VfsUtil.processFileRecursivelyWithoutIgnored((VirtualFile)rootDirectory, (Processor)new Processor<VirtualFile>(){

            public boolean process(VirtualFile virtualFile) {
                if (FILES_TO_PROCESS.contains(virtualFile.getName().toLowerCase())) {
                    files.add(VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile));
                }
                return true;
            }
        });
        MyLintClient lintClient = new MyLintClient(project);
        ImmutableList modules = ImmutableList.of();
        IntellijLintRequest request = new IntellijLintRequest(lintClient, project, null, (List)modules, false){

            @NonNull
            public List<File> getFiles() {
                return files;
            }
        };
        LintDriver lintDriver = new LintDriver((IssueRegistry)new IntellijLintIssueRegistry(), (LintClient)lintClient);
        lintDriver.analyze((LintRequest)request);
        return !lintClient.hasFatalError();
    }

    public static void mergeQueuedMessages(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/ProjectValidator", "mergeQueuedMessages"));
        }
        List messages = (List)project.getUserData(VALIDATION_MESSAGES);
        if (messages == null) {
            return;
        }
        ProjectSyncMessages projectSyncMessages = ProjectSyncMessages.getInstance(project);
        for (Message message : messages) {
            projectSyncMessages.add(message, new NotificationHyperlink[0]);
        }
        project.putUserData(VALIDATION_MESSAGES, null);
    }

    private static class MyLintClient
    extends IntellijLintClient {
        private static final String GROUP_NAME = "Project import";
        private boolean myFatalError = false;
        private final List<Message> myMessages = Lists.newArrayList();

        protected MyLintClient(@NonNull Project project) {
            super(project);
            project.putUserData(VALIDATION_MESSAGES, this.myMessages);
        }

        @Override
        public void report(@NonNull Context context, @NonNull Issue issue, @NonNull Severity severity, @Nullable Location location, @NonNull String message, @Nullable Object data) {
            this.myFatalError |= severity.compareTo((Enum)Severity.ERROR) <= 0;
            File file = location != null ? location.getFile() : null;
            VirtualFile virtualFile = file != null ? LocalFileSystem.getInstance().findFileByIoFile(file) : null;
            Position start = location != null ? location.getStart() : null;
            Message.Type type = MyLintClient.convertSeverity(severity);
            if (virtualFile != null && start != null) {
                try {
                    int line = start.getLine();
                    int column = start.getColumn();
                    int offset = start.getOffset();
                    if (line == -1 && offset >= 0) {
                        Document document;
                        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
                        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.myProject);
                        PsiFile psiFile = psiManager.findFile(virtualFile);
                        if (psiFile != null && (document = psiDocumentManager.getDocument(psiFile)) != null) {
                            line = document.getLineNumber(offset);
                            column = offset - document.getLineStartOffset(line);
                        }
                    }
                    this.myMessages.add(new Message(this.myProject, GROUP_NAME, type, virtualFile, line, column, message));
                }
                catch (Exception e) {
                    this.myMessages.add(new Message(GROUP_NAME, type, message));
                }
            } else {
                this.myMessages.add(new Message(GROUP_NAME, type, message));
            }
        }

        @Override
        public void log(@NonNull Severity severity, @Nullable Throwable exception, @Nullable String format, Object ... args) {
            this.myMessages.add(new Message(GROUP_NAME, MyLintClient.convertSeverity(severity), format != null ? String.format(format, args) : ""));
            if (exception != null) {
                LOG.warn("Exception occurred during validation of project", exception);
            }
        }

        @NonNull
        private static Message.Type convertSeverity(@NonNull Severity severity) {
            switch (severity) {
                case ERROR: 
                case FATAL: {
                    return Message.Type.ERROR;
                }
                case IGNORE: {
                    return Message.Type.INFO;
                }
                default: {
                    return Message.Type.INFO;
                }
                case WARNING: 
            }
            return Message.Type.WARNING;
        }

        public boolean hasFatalError() {
            return this.myFatalError;
        }

        @Override
        @NonNull
        protected List<Issue> getIssues() {
            return new IntellijLintIssueRegistry().getIssues();
        }

        @Override
        @Nullable
        protected Module getModule() {
            return null;
        }

        @Override
        public boolean isProjectDirectory(@NonNull File dir) {
            return new File(dir, "build.gradle").exists();
        }
    }
}

