/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProjectImportUtil {
    @NonNls
    private static final String ANDROID_NATURE_NAME = "com.android.ide.eclipse.adt.AndroidNature";
    private static final Logger LOG = Logger.getInstance(ProjectImportUtil.class);

    private ProjectImportUtil() {
    }

    @Nullable
    public static VirtualFile findImportTarget(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/ProjectImportUtil", "findImportTarget"));
        }
        if (file.isDirectory()) {
            VirtualFile target = ProjectImportUtil.findMatchingChild(file, "build.gradle", "settings.gradle");
            if (target != null) {
                return target;
            }
            target = ProjectImportUtil.findMatchingChild(file, ".project");
            if (target != null) {
                return ProjectImportUtil.findImportTarget(target);
            }
        } else {
            if (".project".equals(file.getName()) && ProjectImportUtil.hasAndroidNature(file)) {
                return file;
            }
            if (".classpath".equals(file.getName())) {
                return ProjectImportUtil.findImportTarget(file.getParent());
            }
        }
        return file;
    }

    @Nullable
    private static VirtualFile findMatchingChild(@NotNull VirtualFile parent, String ... validNames) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/ProjectImportUtil", "findMatchingChild"));
        }
        if (validNames == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/project/ProjectImportUtil", "findMatchingChild"));
        }
        if (parent.isDirectory()) {
            for (VirtualFile child : parent.getChildren()) {
                for (String name : validNames) {
                    if (!name.equals(child.getName())) continue;
                    return child;
                }
            }
        }
        return null;
    }

    private static boolean hasAndroidNature(@NotNull VirtualFile projectFile) {
        if (projectFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/ProjectImportUtil", "hasAndroidNature"));
        }
        File dotProjectFile = new File(projectFile.getPath());
        try {
            Element naturesElement = JDOMUtil.loadDocument((File)dotProjectFile).getRootElement().getChild("natures");
            if (naturesElement != null) {
                List naturesList = naturesElement.getChildren("nature");
                for (Element nature : naturesList) {
                    String natureName = nature.getText();
                    if (!ANDROID_NATURE_NAME.equals(natureName)) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            LOG.info(String.format("Unable to get natures for Eclipse project file '%1$s", projectFile.getPath()), (Throwable)e);
        }
        return false;
    }
}

