/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.util.Pair;
import java.io.File;
import java.net.UnknownHostException;
import java.util.regex.Pattern;
import org.gradle.tooling.UnsupportedVersionException;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectImportErrorHandler;

public class ProjectImportErrorHandler
extends AbstractProjectImportErrorHandler {
    public static final String FAILED_TO_PARSE_SDK_ERROR = "failed to parse SDK";
    public static final String INSTALL_ANDROID_SUPPORT_REPO = "Please install the Android Support Repository from the Android SDK Manager.";
    public static final String FIX_SDK_DIR_PROPERTY = "Please fix the 'sdk.dir' property in the local.properties file.";
    private static final Pattern SDK_NOT_FOUND = Pattern.compile("The SDK directory '(.*?)' does not exist.");
    private static final String EMPTY_LINE = "\n\n";
    private static final String UNSUPPORTED_GRADLE_VERSION_ERROR = "Gradle version 1.12 is required";
    private static final String SDK_DIR_PROPERTY_MISSING = "No sdk.dir property defined in local.properties file.";

    @Nullable
    public ExternalSystemException getUserFriendlyError(@NotNull Throwable error, @NotNull String projectPath, @Nullable String buildFilePath) {
        String msg;
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/ProjectImportErrorHandler", "getUserFriendlyError"));
        }
        if (projectPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/project/ProjectImportErrorHandler", "getUserFriendlyError"));
        }
        if (error instanceof ExternalSystemException) {
            return (ExternalSystemException)error;
        }
        Pair rootCauseAndLocation = this.getRootCauseAndLocation(error);
        Throwable rootCause = (Throwable)rootCauseAndLocation.getFirst();
        if (ProjectImportErrorHandler.isOldGradleVersion(rootCause)) {
            String msg2 = String.format("You are using an unsupported version of Gradle. Please use version %1$s.", "1.12");
            msg2 = msg2 + "\nPlease point to a supported Gradle version in the project's Gradle settings or in the project's Gradle wrapper (if applicable.)";
            return this.createUserFriendlyError(msg2, null, new String[0]);
        }
        if (rootCause instanceof UnknownHostException) {
            return this.createUserFriendlyError(String.format("Unknown host '%1$s'.", rootCause.getMessage()), null, new String[0]);
        }
        if ((rootCause instanceof IllegalStateException || rootCause instanceof ExternalSystemException) && (msg = rootCause.getMessage()) != null) {
            if (msg.startsWith("failed to find target android-")) {
                return this.createUserFriendlyError(msg, null, new String[0]);
            }
            if (msg.startsWith("failed to find Build Tools")) {
                return this.createUserFriendlyError(msg, null, new String[0]);
            }
        }
        if (rootCause instanceof RuntimeException) {
            msg = rootCause.getMessage();
            if (msg != null && msg.contains("Could not find") && msg.contains("com.android.support:")) {
                String newMsg = msg + EMPTY_LINE + INSTALL_ANDROID_SUPPORT_REPO;
                return this.createUserFriendlyError(newMsg, null, new String[0]);
            }
            if (msg != null && msg.contains(FAILED_TO_PARSE_SDK_ERROR)) {
                String newMsg = msg + EMPTY_LINE + "The Android SDK may be missing the directory 'add-ons'.";
                return this.createUserFriendlyError(newMsg, null, new String[0]);
            }
            if (msg != null && (msg.equals(SDK_DIR_PROPERTY_MISSING) || SDK_NOT_FOUND.matcher(msg).matches())) {
                String newMsg = msg;
                File buildProperties = new File(projectPath, "local.properties");
                if (buildProperties.isFile()) {
                    newMsg = newMsg + "\n\nPlease fix the 'sdk.dir' property in the local.properties file.";
                }
                return this.createUserFriendlyError(newMsg, null, new String[0]);
            }
        }
        return null;
    }

    private static boolean isOldGradleVersion(@NotNull Throwable error) {
        String msg;
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/ProjectImportErrorHandler", "isOldGradleVersion"));
        }
        if (error instanceof UnsupportedVersionException) {
            return true;
        }
        if (error instanceof UnsupportedMethodException && (msg = error.getMessage()) != null && msg.contains("GradleProject.getBuildScript")) {
            return true;
        }
        if (error instanceof ClassNotFoundException && (msg = error.getMessage()) != null && msg.contains(ToolingModelBuilderRegistry.class.getName())) {
            return true;
        }
        return error instanceof RuntimeException && (msg = error.getMessage()) != null && msg.startsWith(UNSUPPORTED_GRADLE_VERSION_ERROR);
    }
}

