/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.parser.Dependency;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.Iterables;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashSet;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GradleProjectDependencyParser {
    private static Set<String> parse(VirtualFile moduleRoot, Project project) {
        VirtualFile file1 = moduleRoot.findChild("build.gradle");
        if (file1 == null) {
            return Collections.emptySet();
        }
        HashSet result = new HashSet();
        GradleBuildFile buildFile = new GradleBuildFile(file1, project);
        for (Dependency dependency : Iterables.filter(buildFile.getDependencies(), Dependency.class)) {
            if (dependency.type != Dependency.Type.MODULE) continue;
            String moduleName = dependency.getValueAsString();
            result.add(moduleName);
        }
        return result;
    }

    public static Function<VirtualFile, Iterable<String>> newInstance(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/GradleProjectDependencyParser", "newInstance"));
        }
        return CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<VirtualFile, Iterable<String>>(){

            public Iterable<String> load(@NotNull VirtualFile key) throws Exception {
                if (key == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/GradleProjectDependencyParser$1", "load"));
                }
                return GradleProjectDependencyParser.parse(key, project);
            }
        });
    }
}

