/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.facet.AndroidGradleFacetConfiguration;
import com.android.tools.idea.gradle.parser.GradleSettingsFile;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.base.Joiner;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.ModuleAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GradleBuildFileUpdater
extends ModuleAdapter
implements BulkFileListener {
    private static final Logger LOG = Logger.getInstance(GradleBuildFileUpdater.class);
    private final Project myProject;

    public GradleBuildFileUpdater(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/GradleBuildFileUpdater", "<init>"));
        }
        this.myProject = project;
    }

    public void moduleAdded(@NotNull Project project, @NotNull Module module) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/GradleBuildFileUpdater", "moduleAdded"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/project/GradleBuildFileUpdater", "moduleAdded"));
        }
        GradleSettingsFile settingsFile = GradleSettingsFile.get(project);
        if (settingsFile != null) {
            settingsFile.addModule(module);
        }
    }

    public void moduleRemoved(@NotNull Project project, @NotNull Module module) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/GradleBuildFileUpdater", "moduleRemoved"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/project/GradleBuildFileUpdater", "moduleRemoved"));
        }
        GradleSettingsFile settingsFile = GradleSettingsFile.get(project);
        if (settingsFile != null) {
            settingsFile.removeModule(module);
        }
    }

    public void before(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/GradleBuildFileUpdater", "before"));
        }
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/GradleBuildFileUpdater", "after"));
        }
        for (VFileEvent vFileEvent : events) {
            GradleSettingsFile settingsFile;
            String newPath;
            String oldPath;
            AndroidGradleFacet androidGradleFacet;
            Module[] modules;
            VirtualFile eventFile;
            VFilePropertyChangeEvent propChangeEvent;
            if (!(vFileEvent instanceof VFilePropertyChangeEvent) || !"name".equals((propChangeEvent = (VFilePropertyChangeEvent)vFileEvent).getPropertyName()) || !(eventFile = propChangeEvent.getFile()).isDirectory()) continue;
            Module module = null;
            for (Module m : modules = ModuleManager.getInstance((Project)this.myProject).getModules()) {
                VirtualFile moduleDir;
                VirtualFile file = GradleUtil.getGradleBuildFile(m);
                if (file == null || (moduleDir = file.getParent()) == null || !FileUtil.pathsEqual((String)eventFile.getPath(), (String)moduleDir.getPath())) continue;
                module = m;
                break;
            }
            if (module == null || (androidGradleFacet = AndroidGradleFacet.getInstance(module)) == null || (oldPath = ((AndroidGradleFacetConfiguration)androidGradleFacet.getConfiguration()).GRADLE_PROJECT_PATH).equals(newPath = GradleBuildFileUpdater.updateProjectNameInGradlePath(androidGradleFacet, eventFile)) || (settingsFile = GradleSettingsFile.get(this.myProject)) == null) continue;
            settingsFile.removeModule(oldPath);
            settingsFile.addModule(newPath, VfsUtilCore.virtualToIoFile((VirtualFile)eventFile));
        }
    }

    @NotNull
    private static String updateProjectNameInGradlePath(@NotNull AndroidGradleFacet androidGradleFacet, @NotNull VirtualFile moduleDir) {
        String newPath;
        if (androidGradleFacet == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/GradleBuildFileUpdater", "updateProjectNameInGradlePath"));
        }
        if (moduleDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/project/GradleBuildFileUpdater", "updateProjectNameInGradlePath"));
        }
        String gradlePath = ((AndroidGradleFacetConfiguration)androidGradleFacet.getConfiguration()).GRADLE_PROJECT_PATH;
        if (gradlePath.equals(":")) {
            String string = gradlePath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/GradleBuildFileUpdater", "updateProjectNameInGradlePath"));
            }
            return string;
        }
        List<String> pathSegments = GradleUtil.getPathSegments(gradlePath);
        pathSegments.remove(pathSegments.size() - 1);
        pathSegments.add(moduleDir.getName());
        ((AndroidGradleFacetConfiguration)androidGradleFacet.getConfiguration()).GRADLE_PROJECT_PATH = newPath = Joiner.on((String)":").join(pathSegments);
        String string = newPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/GradleBuildFileUpdater", "updateProjectNameInGradlePath"));
        }
        return string;
    }
}

