/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.util.BuildMode;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildSettings {
    private static final Key<BuildMode> PROJECT_BUILD_MODE_KEY = Key.create((String)"android.gradle.project.build.mode");
    private static final Key<String[]> SELECTED_MODULE_NAMES_KEY = Key.create((String)"android.gradle.project.selected.module.names");
    @NotNull
    private final Project myProject;

    @NotNull
    public static BuildSettings getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/BuildSettings", "getInstance"));
        }
        BuildSettings buildSettings = (BuildSettings)ServiceManager.getService((Project)project, BuildSettings.class);
        if (buildSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/BuildSettings", "getInstance"));
        }
        return buildSettings;
    }

    public BuildSettings(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/BuildSettings", "<init>"));
        }
        this.myProject = project;
    }

    public void removeAll() {
        this.setModulesToBuild(null);
        this.setBuildMode(null);
    }

    @Nullable
    public BuildMode getBuildMode() {
        return (BuildMode)this.myProject.getUserData(PROJECT_BUILD_MODE_KEY);
    }

    public void setBuildMode(@Nullable BuildMode action) {
        this.myProject.putUserData(PROJECT_BUILD_MODE_KEY, (Object)action);
    }

    public void setModulesToBuild(@Nullable Module[] modules) {
        String[] moduleNames = null;
        if (modules != null) {
            int moduleCount = modules.length;
            moduleNames = new String[moduleCount];
            for (int i = 0; i < moduleCount; ++i) {
                moduleNames[i] = modules[i].getName();
            }
        }
        this.myProject.putUserData(SELECTED_MODULE_NAMES_KEY, moduleNames);
    }

    @Nullable
    public String[] getModulesToBuildNames() {
        return (String[])this.myProject.getUserData(SELECTED_MODULE_NAMES_KEY);
    }
}

