/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.invoker.messages;

import com.android.tools.idea.gradle.invoker.messages.GradleBuildTreeViewConfiguration;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.intellij.ide.errorTreeView.ErrorTreeElement;
import com.intellij.ide.errorTreeView.ErrorTreeElementKind;
import com.intellij.ide.errorTreeView.ErrorViewStructure;
import com.intellij.ide.errorTreeView.GroupingElement;
import com.intellij.ide.errorTreeView.NavigatableMessageElement;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.ide.errorTreeView.SimpleMessageElement;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleBuildTreeStructure
extends ErrorViewStructure {
    private final List<ErrorTreeElement> myMessages;
    private final ListMultimap<ErrorTreeElementKind, ErrorTreeElement> myMessagesByType;
    private final ListMultimap<String, NavigatableMessageElement> myGroupNameToMessagesMap;
    @NotNull
    private final Project myProject;
    @NotNull
    private final GradleBuildTreeViewConfiguration myConfiguration;

    GradleBuildTreeStructure(@NotNull Project project, @NotNull GradleBuildTreeViewConfiguration configuration) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/invoker/messages/GradleBuildTreeStructure", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/invoker/messages/GradleBuildTreeStructure", "<init>"));
        }
        super(project, false);
        this.myMessages = Lists.newCopyOnWriteArrayList();
        this.myMessagesByType = ArrayListMultimap.create();
        this.myGroupNameToMessagesMap = ArrayListMultimap.create();
        this.myProject = project;
        this.myConfiguration = configuration;
    }

    @Nullable
    public ErrorTreeElement getFirstMessage(@NotNull ErrorTreeElementKind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/invoker/messages/GradleBuildTreeStructure", "getFirstMessage"));
        }
        List elements = this.myMessagesByType.get((Object)kind);
        return elements.isEmpty() ? null : (ErrorTreeElement)elements.get(0);
    }

    public int getChildCount(GroupingElement groupingElement) {
        return this.myGroupNameToMessagesMap.get((Object)groupingElement.getName()).size();
    }

    public ErrorTreeElement[] getChildElements(Object element) {
        if (element instanceof ErrorTreeElement && element.getClass().getName().contains("MyRootElement")) {
            ArrayList messages = Lists.newArrayListWithExpectedSize((int)this.myMessages.size());
            for (ErrorTreeElement message : this.myMessages) {
                if (!this.canShow(message)) continue;
                messages.add(message);
            }
            return messages.toArray(new ErrorTreeElement[messages.size()]);
        }
        if (element instanceof GroupingElement) {
            List children = this.myGroupNameToMessagesMap.get((Object)((GroupingElement)element).getName());
            ArrayList messages = Lists.newArrayListWithExpectedSize((int)children.size());
            for (NavigatableMessageElement message : children) {
                if (!this.canShow((ErrorTreeElement)message)) continue;
                messages.add(message);
            }
            return messages.toArray(new ErrorTreeElement[messages.size()]);
        }
        return ErrorTreeElement.EMPTY_ARRAY;
    }

    private boolean canShow(@NotNull ErrorTreeElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/invoker/messages/GradleBuildTreeStructure", "canShow"));
        }
        if (element instanceof GroupingElement) {
            List children = this.myGroupNameToMessagesMap.get((Object)((GroupingElement)element).getName());
            for (NavigatableMessageElement child : children) {
                if (!this.canShow((ErrorTreeElement)child)) continue;
                return true;
            }
            return false;
        }
        return this.myConfiguration.canShow(element.getKind());
    }

    public void addMessage(@NotNull ErrorTreeElementKind kind, @NotNull String[] text, @Nullable VirtualFile underFileGroup, @Nullable VirtualFile file, int line, int column, @Nullable Object data) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/invoker/messages/GradleBuildTreeStructure", "addMessage"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/invoker/messages/GradleBuildTreeStructure", "addMessage"));
        }
        if (underFileGroup != null || file != null) {
            if (file == null) {
                column = -1;
                line = -1;
            }
            int uiLine = line < 0 ? -1 : line + 1;
            int uiColumn = column < 0 ? -1 : column + 1;
            VirtualFile group = underFileGroup != null ? underFileGroup : file;
            VirtualFile nav = file != null ? file : underFileGroup;
            this.addNavigatableMessage(group.getPresentableUrl(), (Navigatable)new OpenFileDescriptor(this.myProject, nav, line, column), kind, text, data, NewErrorTreeViewPanel.createExportPrefix((int)uiLine), NewErrorTreeViewPanel.createRendererPrefix((int)uiLine, (int)uiColumn), group);
            return;
        }
        this.addSimpleMessage(kind, text, data);
    }

    public void addNavigatableMessage(@Nullable String groupName, @Nullable Navigatable navigatable, @NotNull ErrorTreeElementKind kind, @NotNull String[] message, @Nullable Object data, @NotNull String exportText, @NotNull String rendererTextPrefix, @Nullable VirtualFile file) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/gradle/invoker/messages/GradleBuildTreeStructure", "addNavigatableMessage"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/android/tools/idea/gradle/invoker/messages/GradleBuildTreeStructure", "addNavigatableMessage"));
        }
        if (exportText == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/android/tools/idea/gradle/invoker/messages/GradleBuildTreeStructure", "addNavigatableMessage"));
        }
        if (rendererTextPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "6", "com/android/tools/idea/gradle/invoker/messages/GradleBuildTreeStructure", "addNavigatableMessage"));
        }
        if (groupName != null) {
            GroupingElement grouping = this.getGroupingElement(groupName, data, file);
            NavigatableMessageElement e = new NavigatableMessageElement(kind, grouping, message, navigatable, exportText, rendererTextPrefix);
            this.myMessagesByType.put((Object)kind, (Object)e);
            this.myGroupNameToMessagesMap.put((Object)groupName, (Object)e);
            this.myMessages.add((ErrorTreeElement)grouping);
            return;
        }
        this.myMessages.add((ErrorTreeElement)new NavigatableMessageElement(kind, null, message, navigatable, exportText, rendererTextPrefix));
    }

    private void addSimpleMessage(@NotNull ErrorTreeElementKind kind, @NotNull String[] text, @Nullable Object data) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/invoker/messages/GradleBuildTreeStructure", "addSimpleMessage"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/invoker/messages/GradleBuildTreeStructure", "addSimpleMessage"));
        }
        SimpleMessageElement element = new SimpleMessageElement(kind, text, data);
        this.myMessagesByType.put((Object)kind, (Object)element);
        this.myMessages.add((ErrorTreeElement)element);
    }
}

