/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.invoker;

import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.facet.AndroidGradleFacetConfiguration;
import com.android.tools.idea.gradle.invoker.GradleInvocationResult;
import com.android.tools.idea.gradle.invoker.GradleTasksExecutor;
import com.android.tools.idea.gradle.invoker.console.view.GradleConsoleView;
import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.GradleBuilds;
import com.android.tools.idea.gradle.util.Projects;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;

public class GradleInvoker {
    private static final Logger LOG = Logger.getInstance(GradleInvoker.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private Collection<BeforeGradleInvocationTask> myBeforeTasks;
    @NotNull
    private Collection<AfterGradleInvocationTask> myAfterTasks;

    public static GradleInvoker getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/invoker/GradleInvoker", "getInstance"));
        }
        return (GradleInvoker)ServiceManager.getService((Project)project, GradleInvoker.class);
    }

    public GradleInvoker(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/invoker/GradleInvoker", "<init>"));
        }
        this.myBeforeTasks = Sets.newLinkedHashSet();
        this.myAfterTasks = Sets.newLinkedHashSet();
        this.myProject = project;
    }

    @VisibleForTesting
    void addBeforeGradleInvocationTask(@NotNull BeforeGradleInvocationTask task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/invoker/GradleInvoker", "addBeforeGradleInvocationTask"));
        }
        this.myBeforeTasks.add(task);
    }

    public void addAfterGradleInvocationTask(@NotNull AfterGradleInvocationTask task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/invoker/GradleInvoker", "addAfterGradleInvocationTask"));
        }
        this.myAfterTasks.add(task);
    }

    public void removeAfterGradleInvocationTask(@NotNull AfterGradleInvocationTask task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/invoker/GradleInvoker", "removeAfterGradleInvocationTask"));
        }
        this.myAfterTasks.remove(task);
    }

    public void cleanProject() {
        this.setProjectBuildMode(BuildMode.CLEAN);
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        List<String> tasks = this.findTasksToExecute(moduleManager.getModules(), BuildMode.SOURCE_GEN, GradleBuilds.TestCompileType.NONE);
        tasks.add(0, "clean");
        this.executeTasks(tasks);
    }

    public void assembleTranslate() {
        this.setProjectBuildMode(BuildMode.ASSEMBLE_TRANSLATE);
        this.executeTasks(Lists.newArrayList((Object[])new String[]{"assembleTranslate"}));
    }

    public void generateSources() {
        BuildMode buildMode = BuildMode.SOURCE_GEN;
        this.setProjectBuildMode(buildMode);
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        List<String> tasks = this.findTasksToExecute(moduleManager.getModules(), buildMode, GradleBuilds.TestCompileType.NONE);
        this.executeTasks(tasks);
    }

    public void compileJava(@NotNull Module[] modules) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/invoker/GradleInvoker", "compileJava"));
        }
        BuildMode buildMode = BuildMode.COMPILE_JAVA;
        this.setProjectBuildMode(buildMode);
        List<String> tasks = this.findTasksToExecute(modules, buildMode, GradleBuilds.TestCompileType.NONE);
        this.executeTasks(tasks);
    }

    public void assemble(@NotNull Module[] modules, @NotNull GradleBuilds.TestCompileType testCompileType) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/invoker/GradleInvoker", "assemble"));
        }
        if (testCompileType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/invoker/GradleInvoker", "assemble"));
        }
        BuildMode buildMode = BuildMode.ASSEMBLE;
        this.setProjectBuildMode(buildMode);
        List<String> tasks = this.findTasksToExecute(modules, buildMode, testCompileType);
        this.executeTasks(tasks);
    }

    public void rebuild() {
        BuildMode buildMode = BuildMode.REBUILD;
        this.setProjectBuildMode(buildMode);
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        List<String> tasks = this.findTasksToExecute(moduleManager.getModules(), buildMode, GradleBuilds.TestCompileType.NONE);
        if (!tasks.isEmpty()) {
            tasks.add(0, "clean");
        }
        this.executeTasks(tasks);
    }

    private void setProjectBuildMode(@NotNull BuildMode buildMode) {
        if (buildMode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/invoker/GradleInvoker", "setProjectBuildMode"));
        }
        BuildSettings.getInstance(this.myProject).setBuildMode(buildMode);
    }

    private List<String> findTasksToExecute(@NotNull Module[] modules, @NotNull BuildMode buildMode, @NotNull GradleBuilds.TestCompileType testCompileType) {
        Project project;
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/invoker/GradleInvoker", "findTasksToExecute"));
        }
        if (buildMode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/invoker/GradleInvoker", "findTasksToExecute"));
        }
        if (testCompileType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/gradle/invoker/GradleInvoker", "findTasksToExecute"));
        }
        ArrayList tasks = Lists.newArrayList();
        if (BuildMode.ASSEMBLE == buildMode && Projects.lastGradleSyncFailed(project = modules[0].getProject())) {
            return Collections.singletonList("assemble");
        }
        for (Module module : modules) {
            AndroidGradleFacet androidGradleFacet;
            if ("buildSrc".equals(module.getName()) || (androidGradleFacet = AndroidGradleFacet.getInstance(module)) == null) continue;
            String gradleProjectPath = ((AndroidGradleFacetConfiguration)androidGradleFacet.getConfiguration()).GRADLE_PROJECT_PATH;
            AndroidFacet androidFacet = AndroidFacet.getInstance(module);
            JpsAndroidModuleProperties properties = androidFacet != null ? androidFacet.getProperties() : null;
            GradleBuilds.findAndAddBuildTask((String)module.getName(), (BuildMode)buildMode, (String)gradleProjectPath, (JpsAndroidModuleProperties)properties, (List)tasks, (GradleBuilds.TestCompileType)testCompileType);
        }
        if (tasks.isEmpty()) {
            String format = "Unable to find Gradle tasks for project '%1$s' using BuildMode %2$s";
            LOG.info(String.format(format, this.myProject.getName(), buildMode.name()));
        }
        return tasks;
    }

    public void executeTasks(@NotNull List<String> gradleTasks) {
        if (gradleTasks == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/invoker/GradleInvoker", "executeTasks"));
        }
        this.executeTasks(gradleTasks, Collections.<String>emptyList());
    }

    public void executeTasks(final @NotNull List<String> gradleTasks, final @NotNull List<String> commandLineArguments) {
        if (gradleTasks == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/invoker/GradleInvoker", "executeTasks"));
        }
        if (commandLineArguments == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/invoker/GradleInvoker", "executeTasks"));
        }
        LOG.info("About to execute Gradle tasks: " + gradleTasks);
        if (gradleTasks.isEmpty()) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            for (BeforeGradleInvocationTask listener : this.myBeforeTasks) {
                listener.execute(gradleTasks);
            }
            return;
        }
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                FileDocumentManager.getInstance().saveAllDocuments();
                AfterGradleInvocationTask[] afterGradleInvocationTasks = GradleInvoker.this.myAfterTasks.toArray(new AfterGradleInvocationTask[GradleInvoker.this.myAfterTasks.size()]);
                GradleTasksExecutor executor = new GradleTasksExecutor(GradleInvoker.this.myProject, gradleTasks, commandLineArguments, afterGradleInvocationTasks);
                executor.queue();
            }
        });
    }

    public void clearConsoleAndBuildMessages() {
        GradleConsoleView.getInstance(this.myProject).clear();
        GradleTasksExecutor.clearMessageView(this.myProject);
    }

    public static interface AfterGradleInvocationTask {
        public void execute(@NotNull GradleInvocationResult var1);
    }

    @VisibleForTesting
    static interface BeforeGradleInvocationTask {
        public void execute(@NotNull List<String> var1);
    }
}

