/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dependency;

import com.android.tools.idea.gradle.dependency.Dependency;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class LibraryDependency
extends Dependency {
    @NotNull
    private final Map<PathType, Collection<String>> myPathsByType;
    @NotNull
    private String myName;

    @VisibleForTesting
    public LibraryDependency(@NotNull File binaryPath, @NotNull DependencyScope scope) {
        if (binaryPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/dependency/LibraryDependency", "<init>"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/dependency/LibraryDependency", "<init>"));
        }
        this(FileUtil.getNameWithoutExtension((File)binaryPath), scope);
        this.addPath(PathType.BINARY, binaryPath);
    }

    LibraryDependency(@NotNull String name, @NotNull DependencyScope scope) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/dependency/LibraryDependency", "<init>"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/dependency/LibraryDependency", "<init>"));
        }
        super(scope);
        this.myPathsByType = Maps.newEnumMap(PathType.class);
        this.setName(name);
    }

    void addPath(@NotNull PathType type, @NotNull File path) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/dependency/LibraryDependency", "addPath"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/dependency/LibraryDependency", "addPath"));
        }
        HashSet paths = this.myPathsByType.get((Object)type);
        if (paths == null) {
            paths = Sets.newHashSet();
            this.myPathsByType.put(type, paths);
        }
        paths.add(path.getPath());
    }

    @NotNull
    public Collection<String> getPaths(@NotNull PathType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/dependency/LibraryDependency", "getPaths"));
        }
        Collection<String> paths = this.myPathsByType.get((Object)type);
        Collection<Object> collection = paths == null ? Collections.emptyList() : paths;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dependency/LibraryDependency", "getPaths"));
        }
        return collection;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dependency/LibraryDependency", "getName"));
        }
        return string;
    }

    void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/dependency/LibraryDependency", "setName"));
        }
        this.myName = name;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "name='" + this.myName + '\'' + ", scope=" + this.getScope() + ", pathsByType=" + this.myPathsByType + "]";
    }

    public static enum PathType {
        BINARY,
        SOURCE,
        DOC;

    }
}

