/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.customizer.android;

import com.android.tools.idea.gradle.IdeaAndroidProject;
import com.android.tools.idea.gradle.customizer.AbstractDependenciesModuleCustomizer;
import com.android.tools.idea.gradle.dependency.Dependency;
import com.android.tools.idea.gradle.dependency.DependencySet;
import com.android.tools.idea.gradle.dependency.LibraryDependency;
import com.android.tools.idea.gradle.dependency.ModuleDependency;
import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.facet.AndroidGradleFacetConfiguration;
import com.android.tools.idea.gradle.messages.Message;
import com.android.tools.idea.gradle.messages.ProjectSyncMessages;
import com.google.common.base.Objects;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DependenciesModuleCustomizer
extends AbstractDependenciesModuleCustomizer<IdeaAndroidProject> {
    private static final Logger LOG = Logger.getInstance(AbstractDependenciesModuleCustomizer.class);

    @Override
    protected void setUpDependencies(@NotNull ModifiableRootModel model, @NotNull IdeaAndroidProject androidProject, @NotNull List<Message> errorsFound) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/customizer/android/DependenciesModuleCustomizer", "setUpDependencies"));
        }
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/customizer/android/DependenciesModuleCustomizer", "setUpDependencies"));
        }
        if (errorsFound == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/gradle/customizer/android/DependenciesModuleCustomizer", "setUpDependencies"));
        }
        DependencySet dependencies = Dependency.extractFrom(androidProject);
        for (LibraryDependency libraryDependency : dependencies.onLibraries()) {
            this.updateDependency(model, libraryDependency);
        }
        for (ModuleDependency moduleDependency : dependencies.onModules()) {
            this.updateDependency(model, moduleDependency, errorsFound);
        }
        Collection unresolvedDependencies = androidProject.getDelegate().getUnresolvedDependencies();
        ProjectSyncMessages projectSyncMessages = ProjectSyncMessages.getInstance(model.getProject());
        projectSyncMessages.reportUnresolvedDependencies(unresolvedDependencies, model.getModule());
    }

    private void updateDependency(@NotNull ModifiableRootModel model, @NotNull LibraryDependency dependency) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/customizer/android/DependenciesModuleCustomizer", "updateDependency"));
        }
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/customizer/android/DependenciesModuleCustomizer", "updateDependency"));
        }
        Collection<String> binaryPaths = dependency.getPaths(LibraryDependency.PathType.BINARY);
        this.setUpLibraryDependency(model, dependency.getName(), dependency.getScope(), binaryPaths);
    }

    private void updateDependency(@NotNull ModifiableRootModel model, @NotNull ModuleDependency dependency, @NotNull List<Message> errorsFound) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/customizer/android/DependenciesModuleCustomizer", "updateDependency"));
        }
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/customizer/android/DependenciesModuleCustomizer", "updateDependency"));
        }
        if (errorsFound == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/gradle/customizer/android/DependenciesModuleCustomizer", "updateDependency"));
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)model.getProject());
        Module moduleDependency = null;
        for (Module module : moduleManager.getModules()) {
            String gradlePath;
            AndroidGradleFacet androidGradleFacet = AndroidGradleFacet.getInstance(module);
            if (androidGradleFacet == null || !Objects.equal((Object)(gradlePath = ((AndroidGradleFacetConfiguration)androidGradleFacet.getConfiguration()).GRADLE_PROJECT_PATH), (Object)dependency.getGradlePath())) continue;
            moduleDependency = module;
            break;
        }
        if (moduleDependency != null) {
            ModuleOrderEntry orderEntry = model.addModuleOrderEntry(moduleDependency);
            orderEntry.setExported(true);
            return;
        }
        LibraryDependency backup = dependency.getBackupDependency();
        boolean hasLibraryBackup = backup != null;
        String msg = String.format("Unable to find module with Gradle path '%1$s'.", dependency.getGradlePath());
        Message.Type type = Message.Type.ERROR;
        if (hasLibraryBackup) {
            msg = msg + String.format(" Linking to library '%1$s' instead.", backup.getName());
            type = Message.Type.WARNING;
        }
        LOG.info(msg);
        errorsFound.add(new Message("Failed to set up dependencies", type, msg));
        if (hasLibraryBackup) {
            this.updateDependency(model, backup);
        }
    }
}

