/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.customizer;

import com.android.tools.idea.gradle.customizer.ModuleCustomizer;
import com.android.tools.idea.gradle.messages.Message;
import com.android.tools.idea.gradle.messages.ProjectSyncMessages;
import com.android.tools.idea.gradle.service.notification.NotificationHyperlink;
import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDependenciesModuleCustomizer<T>
implements ModuleCustomizer<T> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void customizeModule(@NotNull Module module, @NotNull Project project, @Nullable T model) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "customizeModule"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "customizeModule"));
        }
        if (model == null) {
            return;
        }
        ArrayList errorsFound = Lists.newArrayList();
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        ModifiableRootModel rootModel = moduleRootManager.getModifiableModel();
        try {
            AbstractDependenciesModuleCustomizer.removeExistingDependencies(rootModel);
            this.setUpDependencies(rootModel, model, errorsFound);
        }
        finally {
            rootModel.commit();
        }
        AbstractDependenciesModuleCustomizer.notifyUser(errorsFound, module);
    }

    protected abstract void setUpDependencies(@NotNull ModifiableRootModel var1, @NotNull T var2, @NotNull List<Message> var3);

    private static void notifyUser(@NotNull List<Message> errorsFound, @NotNull Module module) {
        if (errorsFound == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "notifyUser"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "notifyUser"));
        }
        if (!errorsFound.isEmpty()) {
            ProjectSyncMessages messages = ProjectSyncMessages.getInstance(module.getProject());
            for (Message error : errorsFound) {
                messages.add(error, new NotificationHyperlink[0]);
            }
        }
    }

    private static void removeExistingDependencies(@NotNull ModifiableRootModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "removeExistingDependencies"));
        }
        DependencyRemover dependencyRemover = new DependencyRemover(model);
        for (OrderEntry orderEntry : model.getOrderEntries()) {
            orderEntry.accept((RootPolicy)dependencyRemover, null);
        }
    }

    protected void setUpLibraryDependency(@NotNull ModifiableRootModel model, @NotNull String libraryName, @NotNull DependencyScope scope, @NotNull Collection<String> binaryPaths) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "setUpLibraryDependency"));
        }
        if (libraryName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "setUpLibraryDependency"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "setUpLibraryDependency"));
        }
        if (binaryPaths == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "setUpLibraryDependency"));
        }
        List<String> empty = Collections.emptyList();
        this.setUpLibraryDependency(model, libraryName, scope, binaryPaths, empty, empty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUpLibraryDependency(@NotNull ModifiableRootModel model, @NotNull String libraryName, @NotNull DependencyScope scope, @NotNull Collection<String> binaryPaths, @NotNull Collection<String> sourcePaths, @NotNull Collection<String> documentationPaths) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "setUpLibraryDependency"));
        }
        if (libraryName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "setUpLibraryDependency"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "setUpLibraryDependency"));
        }
        if (binaryPaths == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "setUpLibraryDependency"));
        }
        if (sourcePaths == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "setUpLibraryDependency"));
        }
        if (documentationPaths == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "setUpLibraryDependency"));
        }
        LibraryTable libraryTable = ProjectLibraryTable.getInstance((Project)model.getProject());
        Library library = libraryTable.getLibraryByName(libraryName);
        if (library == null) {
            LibraryTable.ModifiableModel libraryTableModel = libraryTable.getModifiableModel();
            try {
                library = libraryTableModel.createLibrary(libraryName);
                AbstractDependenciesModuleCustomizer.updateLibraryBinaryPaths(library, binaryPaths);
            }
            finally {
                libraryTableModel.commit();
            }
        }
        AbstractDependenciesModuleCustomizer.updateLibrarySourcesIfAbsent(library, sourcePaths, OrderRootType.SOURCES);
        AbstractDependenciesModuleCustomizer.updateLibrarySourcesIfAbsent(library, documentationPaths, OrderRootType.DOCUMENTATION);
        for (String binaryPath : binaryPaths) {
            File annotations;
            if (!binaryPath.endsWith("res") || binaryPath.length() <= "res".length() || binaryPath.charAt(binaryPath.length() - "res".length() - 1) != File.separatorChar || !(annotations = new File(binaryPath.substring(0, binaryPath.length() - "res".length()), "annotations.zip")).isFile()) continue;
            AbstractDependenciesModuleCustomizer.updateLibrarySourcesIfAbsent(library, Collections.singletonList(annotations.getPath()), AnnotationOrderRootType.getInstance());
        }
        LibraryOrderEntry orderEntry = model.addLibraryEntry(library);
        orderEntry.setScope(scope);
        orderEntry.setExported(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateLibraryBinaryPaths(@NotNull Library library, @NotNull Collection<String> binaryPaths) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "updateLibraryBinaryPaths"));
        }
        if (binaryPaths == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "updateLibraryBinaryPaths"));
        }
        Library.ModifiableModel libraryModel = library.getModifiableModel();
        try {
            for (String path : binaryPaths) {
                String url = AbstractDependenciesModuleCustomizer.pathToUrl(path);
                libraryModel.addRoot(url, OrderRootType.CLASSES);
            }
        }
        finally {
            libraryModel.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateLibrarySourcesIfAbsent(@NotNull Library library, @NotNull Collection<String> paths, @NotNull OrderRootType pathType) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "updateLibrarySourcesIfAbsent"));
        }
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "updateLibrarySourcesIfAbsent"));
        }
        if (pathType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "updateLibrarySourcesIfAbsent"));
        }
        if (paths.isEmpty() || library.getFiles(pathType).length > 0) {
            return;
        }
        Library.ModifiableModel libraryModel = library.getModifiableModel();
        try {
            for (String path : paths) {
                libraryModel.addRoot(AbstractDependenciesModuleCustomizer.pathToUrl(path), pathType);
            }
        }
        finally {
            libraryModel.commit();
        }
    }

    @NotNull
    public static String pathToUrl(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "pathToUrl"));
        }
        File file = new File(path);
        String name = file.getName();
        boolean isJarFile = FileUtilRt.extensionEquals((String)name, (String)"jar") || FileUtilRt.extensionEquals((String)name, (String)"zip");
        String protocol = isJarFile ? "jar" : "file";
        String filePath = FileUtil.toSystemIndependentName((String)file.getPath());
        String url = VirtualFileManager.constructUrl((String)protocol, (String)filePath);
        if (isJarFile) {
            url = url + "!/";
        }
        String string = url;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer", "pathToUrl"));
        }
        return string;
    }

    private static class DependencyRemover
    extends RootPolicy<Object> {
        @NotNull
        private final ModifiableRootModel myModel;

        DependencyRemover(@NotNull ModifiableRootModel model) {
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/customizer/AbstractDependenciesModuleCustomizer$DependencyRemover", "<init>"));
            }
            this.myModel = model;
        }

        public Object visitLibraryOrderEntry(LibraryOrderEntry libraryOrderEntry, Object value) {
            this.myModel.removeOrderEntry((OrderEntry)libraryOrderEntry);
            return value;
        }

        public Object visitModuleOrderEntry(ModuleOrderEntry moduleOrderEntry, Object value) {
            this.myModel.removeOrderEntry((OrderEntry)moduleOrderEntry);
            return value;
        }
    }
}

